/*
 * Decompiled with CFR 0.152.
 */
package co.streamx.fluent.extree.function.math;

import java.math.BigDecimal;
import java.math.BigInteger;

public enum UnaryOperator {
    Abs{

        @Override
        public Number eval(Number value) {
            if (value instanceof Byte) {
                return (byte)Math.abs(value.byteValue());
            }
            if (value instanceof Double) {
                return Math.abs(value.doubleValue());
            }
            if (value instanceof Float) {
                return Float.valueOf(Math.abs(value.floatValue()));
            }
            if (value instanceof Integer) {
                return Math.abs(value.intValue());
            }
            if (value instanceof Long) {
                return Math.abs(value.longValue());
            }
            if (value instanceof Short) {
                return (short)Math.abs(value.shortValue());
            }
            if (value instanceof BigInteger) {
                return ((BigInteger)value).abs();
            }
            if (value instanceof BigDecimal) {
                return ((BigDecimal)value).abs();
            }
            throw new ArithmeticException(value.getClass().toString());
        }
    }
    ,
    Negate{

        @Override
        public Number eval(Number value) {
            if (value instanceof Byte) {
                return (int)(-value.byteValue());
            }
            if (value instanceof Double) {
                return -value.doubleValue();
            }
            if (value instanceof Float) {
                return Float.valueOf(-value.floatValue());
            }
            if (value instanceof Integer) {
                return -value.intValue();
            }
            if (value instanceof Long) {
                return -value.longValue();
            }
            if (value instanceof Short) {
                return (int)(-value.shortValue());
            }
            if (value instanceof BigInteger) {
                return ((BigInteger)value).negate();
            }
            if (value instanceof BigDecimal) {
                return ((BigDecimal)value).negate();
            }
            throw new ArithmeticException(value.getClass().toString());
        }
    }
    ,
    Not{

        @Override
        public Number eval(Number value) {
            if (value instanceof Byte) {
                return ~value.byteValue();
            }
            if (value instanceof Integer) {
                return ~value.intValue();
            }
            if (value instanceof Long) {
                return value.longValue() ^ 0xFFFFFFFFFFFFFFFFL;
            }
            if (value instanceof Short) {
                return ~value.shortValue();
            }
            if (value instanceof BigInteger) {
                return ((BigInteger)value).not();
            }
            throw new ArithmeticException(value.getClass().toString());
        }
    };


    public abstract Number eval(Number var1);
}

