/*
 * Decompiled with CFR 0.152.
 */
package co.topl.brambl.cli.impl;

import cats.Applicative;
import cats.Eval;
import cats.Eval$;
import cats.Functor;
import cats.Monad;
import cats.Semigroupal;
import cats.UnorderedFoldable$;
import cats.data.IndexedStateT;
import cats.data.IndexedStateT$;
import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import cats.data.Validated;
import cats.data.Validated$;
import cats.data.package;
import cats.implicits$;
import cats.syntax.ValidatedIdSyntax$;
import co.topl.brambl.builders.locks.LockTemplate;
import co.topl.brambl.builders.locks.PropositionTemplate;
import co.topl.brambl.cli.impl.And;
import co.topl.brambl.cli.impl.Digest;
import co.topl.brambl.cli.impl.Height;
import co.topl.brambl.cli.impl.InvalidQuivrContract;
import co.topl.brambl.cli.impl.Locked;
import co.topl.brambl.cli.impl.Or;
import co.topl.brambl.cli.impl.ParseError;
import co.topl.brambl.cli.impl.Sign;
import co.topl.brambl.cli.impl.TemplateAST;
import co.topl.brambl.cli.impl.Threshold;
import co.topl.brambl.cli.impl.ThresholdPredicate;
import co.topl.brambl.cli.impl.Tick;
import co.topl.brambl.utils.Encoding$;
import com.google.protobuf.ByteString;
import java.io.Serializable;
import quivr.models.Data$;
import quivr.models.Digest$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class TemplateAST$ {
    public static final TemplateAST$ MODULE$ = new TemplateAST$();

    public <F> IndexedStateT<Eval, Set<Object>, Set<Object>, Validated<NonEmptyList<ParseError>, LockTemplate<F>>> compilePredicate(ThresholdPredicate template, Monad<F> evidence$1) {
        Seq<TemplateAST> innerPropositions;
        ThresholdPredicate thresholdPredicate = template;
        if (thresholdPredicate == null) {
            throw new MatchError((Object)thresholdPredicate);
        }
        int threshold = thresholdPredicate.threshold();
        IndexedStateT indexedStateT = threshold > (innerPropositions = thresholdPredicate.innerPropositions()).length() ? package.State$.MODULE$.pure((Object)ValidatedIdSyntax$.MODULE$.invalidNel$extension(implicits$.MODULE$.catsSyntaxValidatedId((Object)new InvalidQuivrContract(0, "Threshold cannot be greater than the number of inner propositions")))) : (threshold < 1 ? package.State$.MODULE$.pure((Object)ValidatedIdSyntax$.MODULE$.invalidNel$extension(implicits$.MODULE$.catsSyntaxValidatedId((Object)new InvalidQuivrContract(0, "Threshold cannot be less than 1")))) : ((IndexedStateT)implicits$.MODULE$.toTraverseOps(innerPropositions.map((Function1 & Serializable)x -> MODULE$.compile((TemplateAST)x, evidence$1)), UnorderedFoldable$.MODULE$.catsTraverseForSeq()).sequence((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Applicative)IndexedStateT$.MODULE$.catsDataMonadForIndexedStateT((Monad)Eval$.MODULE$.catsBimonadForEval()))).map((Function1 & Serializable)templatesS -> ((Validated)implicits$.MODULE$.toTraverseOps(templatesS, UnorderedFoldable$.MODULE$.catsTraverseForSeq()).sequence((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Applicative)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyList$.MODULE$.catsDataSemigroupForNonEmptyList()))).map((Function1 & Serializable)innerProps -> new LockTemplate.PredicateTemplate(innerProps, threshold, evidence$1)), (Functor)Eval$.MODULE$.catsBimonadForEval()));
        return indexedStateT;
    }

    public <F> IndexedStateT<Eval, Set<Object>, Set<Object>, Validated<NonEmptyList<ParseError>, PropositionTemplate<F>>> compile(TemplateAST template, Monad<F> evidence$2) {
        IndexedStateT indexedStateT;
        TemplateAST templateAST = template;
        if (templateAST instanceof Sign) {
            Sign sign = (Sign)templateAST;
            int location = sign.location();
            int idx = sign.idx();
            indexedStateT = idx < 0 ? package.State$.MODULE$.pure((Object)ValidatedIdSyntax$.MODULE$.invalidNel$extension(implicits$.MODULE$.catsSyntaxValidatedId((Object)new InvalidQuivrContract(location, "Index cannot be less than 0")))) : (idx > 255 ? package.State$.MODULE$.pure((Object)ValidatedIdSyntax$.MODULE$.invalidNel$extension(implicits$.MODULE$.catsSyntaxValidatedId((Object)new InvalidQuivrContract(location, "Index cannot be greater than 255")))) : package.State$.MODULE$.apply((Function1 & Serializable)state -> state.contains((Object)BoxesRunTime.boxToInteger((int)idx)) ? new Tuple2(state, (Object)ValidatedIdSyntax$.MODULE$.invalidNel$extension(implicits$.MODULE$.catsSyntaxValidatedId((Object)new InvalidQuivrContract(location, "Index cannot be used more than once")))) : new Tuple2((Object)state.$plus((Object)BoxesRunTime.boxToInteger((int)idx)), (Object)ValidatedIdSyntax$.MODULE$.validNel$extension(implicits$.MODULE$.catsSyntaxValidatedId((Object)new PropositionTemplate.SignatureTemplate("ExtendedEd25519", idx, evidence$2))))));
        } else if (templateAST instanceof Threshold) {
            Threshold threshold = (Threshold)templateAST;
            int location = threshold.location();
            int threshold2 = threshold.threshold();
            Seq<TemplateAST> innerPropositions2 = threshold.innerPropositions();
            indexedStateT = ((IndexedStateT)implicits$.MODULE$.toTraverseOps(innerPropositions2.map((Function1 & Serializable)x -> MODULE$.compile((TemplateAST)x, evidence$2)), UnorderedFoldable$.MODULE$.catsTraverseForSeq()).sequence((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Applicative)IndexedStateT$.MODULE$.catsDataMonadForIndexedStateT((Monad)Eval$.MODULE$.catsBimonadForEval()))).map((Function1 & Serializable)innerPropositions -> threshold2 > innerPropositions.length() ? ValidatedIdSyntax$.MODULE$.invalidNel$extension(implicits$.MODULE$.catsSyntaxValidatedId((Object)new InvalidQuivrContract(location, "Threshold cannot be greater than the number of inner propositions"))) : (threshold2 < 1 ? ValidatedIdSyntax$.MODULE$.invalidNel$extension(implicits$.MODULE$.catsSyntaxValidatedId((Object)new InvalidQuivrContract(location, "Threshold cannot be less than 1"))) : ((Validated)implicits$.MODULE$.toTraverseOps(innerPropositions, UnorderedFoldable$.MODULE$.catsTraverseForSeq()).sequence((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Applicative)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyList$.MODULE$.catsDataSemigroupForNonEmptyList()))).map((Function1 & Serializable)innerProps -> new PropositionTemplate.ThresholdTemplate(innerProps, threshold2, evidence$2))), (Functor)Eval$.MODULE$.catsBimonadForEval());
        } else if (templateAST instanceof And) {
            And and = (And)templateAST;
            TemplateAST left = and.left();
            TemplateAST right = and.right();
            indexedStateT = (IndexedStateT)implicits$.MODULE$.catsSyntaxTuple2Semigroupal(new Tuple2(this.compile(left, evidence$2), this.compile(right, evidence$2))).mapN((Function2 & Serializable)(l2, r2) -> (Validated)implicits$.MODULE$.catsSyntaxTuple2Semigroupal(new Tuple2(l2, r2)).mapN((Function2 & Serializable)(l, r) -> new PropositionTemplate.AndTemplate(l, r, evidence$2), (Functor)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyList$.MODULE$.catsDataSemigroupForNonEmptyList()), (Semigroupal)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyList$.MODULE$.catsDataSemigroupForNonEmptyList())), (Functor)IndexedStateT$.MODULE$.catsDataMonadForIndexedStateT((Monad)Eval$.MODULE$.catsBimonadForEval()), (Semigroupal)IndexedStateT$.MODULE$.catsDataMonadForIndexedStateT((Monad)Eval$.MODULE$.catsBimonadForEval()));
        } else if (templateAST instanceof Or) {
            Or or = (Or)templateAST;
            TemplateAST left = or.left();
            TemplateAST right = or.right();
            indexedStateT = (IndexedStateT)implicits$.MODULE$.catsSyntaxTuple2Semigroupal(new Tuple2(this.compile(left, evidence$2), this.compile(right, evidence$2))).mapN((Function2 & Serializable)(l2, r2) -> (Validated)implicits$.MODULE$.catsSyntaxTuple2Semigroupal(new Tuple2(l2, r2)).mapN((Function2 & Serializable)(l, r) -> new PropositionTemplate.OrTemplate(l, r, evidence$2), (Functor)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyList$.MODULE$.catsDataSemigroupForNonEmptyList()), (Semigroupal)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyList$.MODULE$.catsDataSemigroupForNonEmptyList())), (Functor)IndexedStateT$.MODULE$.catsDataMonadForIndexedStateT((Monad)Eval$.MODULE$.catsBimonadForEval()), (Semigroupal)IndexedStateT$.MODULE$.catsDataMonadForIndexedStateT((Monad)Eval$.MODULE$.catsBimonadForEval()));
        } else if (templateAST instanceof Locked) {
            Locked locked = (Locked)templateAST;
            int location = locked.location();
            Option<String> someData = locked.someData();
            indexedStateT = package.State$.MODULE$.pure(someData.map((Function1 & Serializable)data -> {
                Validated validated;
                Either either = Encoding$.MODULE$.decodeFromBase58(data);
                if (either instanceof Left) {
                    validated = ValidatedIdSyntax$.MODULE$.invalidNel$extension(implicits$.MODULE$.catsSyntaxValidatedId((Object)new InvalidQuivrContract(location, "Invalid base58 encoding")));
                } else if (either instanceof Right) {
                    Right right = (Right)either;
                    byte[] decoded = (byte[])right.value();
                    validated = ValidatedIdSyntax$.MODULE$.validNel$extension(implicits$.MODULE$.catsSyntaxValidatedId((Object)new PropositionTemplate.LockedTemplate((Option)new Some((Object)Data$.MODULE$.defaultInstance().withValue(ByteString.copyFrom((byte[])decoded))), evidence$2)));
                } else {
                    throw new MatchError((Object)either);
                }
                return validated;
            }).getOrElse((Function0 & Serializable)() -> ValidatedIdSyntax$.MODULE$.validNel$extension(implicits$.MODULE$.catsSyntaxValidatedId((Object)new PropositionTemplate.LockedTemplate((Option)None$.MODULE$, evidence$2)))));
        } else if (templateAST instanceof Height) {
            Height height = (Height)templateAST;
            int location = height.location();
            long min = height.minHeight();
            long max = height.maxHeight();
            indexedStateT = package.State$.MODULE$.pure((Object)(min < 0L ? ValidatedIdSyntax$.MODULE$.invalidNel$extension(implicits$.MODULE$.catsSyntaxValidatedId((Object)new InvalidQuivrContract(location, "Min height cannot be less than 0"))) : (max < 0L ? ValidatedIdSyntax$.MODULE$.invalidNel$extension(implicits$.MODULE$.catsSyntaxValidatedId((Object)new InvalidQuivrContract(location, "Max height cannot be less than 0"))) : (min > max ? ValidatedIdSyntax$.MODULE$.invalidNel$extension(implicits$.MODULE$.catsSyntaxValidatedId((Object)new InvalidQuivrContract(location, "Min height cannot be greater than max height"))) : ValidatedIdSyntax$.MODULE$.validNel$extension(implicits$.MODULE$.catsSyntaxValidatedId((Object)new PropositionTemplate.HeightTemplate("header", min, max, evidence$2)))))));
        } else if (templateAST instanceof Tick) {
            Tick tick = (Tick)templateAST;
            int location = tick.location();
            long min = tick.minTick();
            long max = tick.maxTick();
            indexedStateT = package.State$.MODULE$.pure((Object)(min < 0L ? ValidatedIdSyntax$.MODULE$.invalidNel$extension(implicits$.MODULE$.catsSyntaxValidatedId((Object)new InvalidQuivrContract(location, "Min tick cannot be less than 0"))) : (max < 0L ? ValidatedIdSyntax$.MODULE$.invalidNel$extension(implicits$.MODULE$.catsSyntaxValidatedId((Object)new InvalidQuivrContract(location, "Max tick cannot be less than 0"))) : (min > max ? ValidatedIdSyntax$.MODULE$.invalidNel$extension(implicits$.MODULE$.catsSyntaxValidatedId((Object)new InvalidQuivrContract(location, "Min tick cannot be greater than max tick"))) : ValidatedIdSyntax$.MODULE$.validNel$extension(implicits$.MODULE$.catsSyntaxValidatedId((Object)new PropositionTemplate.TickTemplate(min, max, evidence$2)))))));
        } else if (templateAST instanceof Digest) {
            Validated validated;
            Digest digest = (Digest)templateAST;
            int location = digest.location();
            String digest2 = digest.digest();
            Either either = Encoding$.MODULE$.decodeFromBase58(digest2);
            if (either instanceof Left) {
                validated = ValidatedIdSyntax$.MODULE$.invalidNel$extension(implicits$.MODULE$.catsSyntaxValidatedId((Object)new InvalidQuivrContract(location, "Invalid base58 encoding")));
            } else if (either instanceof Right) {
                Right right = (Right)either;
                byte[] decoded = (byte[])right.value();
                validated = ValidatedIdSyntax$.MODULE$.validNel$extension(implicits$.MODULE$.catsSyntaxValidatedId((Object)new PropositionTemplate.DigestTemplate("Blake2b256", new quivr.models.Digest(ByteString.copyFrom((byte[])decoded), Digest$.MODULE$.$lessinit$greater$default$2()), evidence$2)));
            } else {
                throw new MatchError((Object)either);
            }
            indexedStateT = package.State$.MODULE$.pure((Object)validated);
        } else {
            throw new MatchError((Object)templateAST);
        }
        return indexedStateT;
    }

    private TemplateAST$() {
    }
}

