/*
 * Decompiled with CFR 0.152.
 */
package co.topl.brambl.cli.impl;

import cats.Applicative;
import cats.FlatMap;
import cats.Functor;
import cats.Monad;
import cats.Semigroupal;
import cats.data.NonEmptyList$;
import cats.data.Validated;
import cats.data.Validated$;
import cats.effect.kernel.MonadCancel;
import cats.effect.kernel.Resource;
import cats.effect.kernel.Sync;
import cats.effect.kernel.Sync$;
import cats.implicits$;
import cats.syntax.OptionOps$;
import co.topl.brambl.builders.TransactionBuilderApi;
import co.topl.brambl.builders.locks.LockTemplate;
import co.topl.brambl.builders.locks.PropositionTemplate;
import co.topl.brambl.cli.impl.WalletStateAlgebra$;
import co.topl.brambl.codecs.LockTemplateCodecs$;
import co.topl.brambl.dataApi.WalletStateAlgebra;
import co.topl.brambl.models.Indices;
import co.topl.brambl.models.Indices$;
import co.topl.brambl.models.LockAddress;
import co.topl.brambl.models.box.Lock;
import co.topl.brambl.utils.Encoding$;
import co.topl.brambl.wallet.WalletApi;
import io.circe.Decoder$;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Json;
import io.circe.syntax.package;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import quivr.models.Proposition;
import quivr.models.VerificationKey;
import quivr.models.VerificationKey$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class WalletStateAlgebra$ {
    public static final WalletStateAlgebra$ MODULE$ = new WalletStateAlgebra$();

    public <F> WalletStateAlgebra<F> make(Resource<F, Connection> connection, TransactionBuilderApi<F> transactionBuilderApi, WalletApi<F> walletApi, Sync<F> evidence$1) {
        return new WalletStateAlgebra<F>(connection, evidence$1, transactionBuilderApi, walletApi){
            private final Resource connection$1;
            private final Sync evidence$1$1;
            private final TransactionBuilderApi transactionBuilderApi$1;
            private final WalletApi walletApi$1;

            public F getIndicesBySignature(Proposition.DigitalSignature signatureProposition) {
                return (F)this.connection$1.use((Function1 & Serializable)conn -> implicits$.MODULE$.toFlatMapOps(Sync$.MODULE$.apply($this.evidence$1$1).blocking((Function0 & Serializable)() -> conn.createStatement()), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)stmnt -> implicits$.MODULE$.toFlatMapOps(Sync$.MODULE$.apply($this.evidence$1$1).blocking((Function0 & Serializable)() -> stmnt.executeQuery(new StringBuilder(0).append("SELECT x_party, y_contract, z_state, routine, vk FROM ").append(new StringBuilder(33).append("cartesian WHERE routine = '").append(signatureProposition.routine()).append("' AND ").toString()).append(new StringBuilder(7).append("vk = '").append(Encoding$.MODULE$.encodeToBase58(signatureProposition.verificationKey().toByteArray())).append("'").toString()).toString())), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)rs -> implicits$.MODULE$.toFlatMapOps(Sync$.MODULE$.apply($this.evidence$1$1).delay((Function0)(JFunction0.mcI.sp & Serializable)() -> rs.getInt("x_party")), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)x -> anon.1.$anonfun$getIndicesBySignature$7(this, rs, BoxesRunTime.unboxToInt((Object)x))))), (MonadCancel)this.evidence$1$1);
            }

            public F getLockByIndex(Indices indices) {
                return (F)this.connection$1.use((Function1 & Serializable)conn -> implicits$.MODULE$.toFlatMapOps(Sync$.MODULE$.apply($this.evidence$1$1).blocking((Function0 & Serializable)() -> conn.createStatement()), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)stmnt -> implicits$.MODULE$.toFlatMapOps(Sync$.MODULE$.apply($this.evidence$1$1).blocking((Function0 & Serializable)() -> stmnt.executeQuery(new StringBuilder(0).append("SELECT x_party, y_contract, z_state, lock_predicate FROM ").append(new StringBuilder(31).append("cartesian WHERE x_party = ").append(indices.x()).append(" AND ").toString()).append(new StringBuilder(18).append("y_contract = ").append(indices.y()).append(" AND ").toString()).append(new StringBuilder(10).append("z_state = ").append(indices.z()).toString()).toString())), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)rs -> implicits$.MODULE$.toFlatMapOps(Sync$.MODULE$.apply($this.evidence$1$1).delay((Function0)(JFunction0.mcZ.sp & Serializable)() -> rs.next()), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)x$1 -> anon.1.$anonfun$getLockByIndex$7(this, rs, BoxesRunTime.unboxToBoolean((Object)x$1))))), (MonadCancel)this.evidence$1$1);
            }

            public F updateWalletState(String lockPredicate, String lockAddress, Option<String> routine, Option<String> vk, Indices indices) {
                return (F)this.connection$1.use((Function1 & Serializable)conn -> implicits$.MODULE$.toFlatMapOps(implicits$.MODULE$.toFunctorOps(Sync$.MODULE$.apply($this.evidence$1$1).blocking((Function0 & Serializable)() -> conn.createStatement()), (Functor)$this.evidence$1$1).map((Function1 & Serializable)stmnt -> {
                    String statement = new StringBuilder(6).append(new StringBuilder(110).append("INSERT INTO cartesian (x_party, y_contract, z_state, lock_predicate, address, routine, vk) VALUES (").append(indices.x()).append(", ").append(indices.y()).append(", ").append(indices.z()).append(", '").append(lockPredicate).append("', '").toString()).append(lockAddress).append("', ").append(routine.map((Function1 & Serializable)x -> new StringBuilder(2).append("'").append((String)x).append("'").toString()).getOrElse((Function0 & Serializable)() -> "NULL")).append(", ").append(vk.map((Function1 & Serializable)x -> new StringBuilder(2).append("'").append((String)x).append("'").toString()).getOrElse((Function0 & Serializable)() -> "NULL")).append(")").toString();
                    return new Tuple2(stmnt, (Object)statement);
                }), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)x$3 -> {
                    Tuple2 tuple2 = x$3;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    Statement stmnt = (Statement)tuple2._1();
                    String statement = (String)tuple2._2();
                    Object object = implicits$.MODULE$.toFunctorOps(Sync$.MODULE$.apply($this.evidence$1$1).blocking((Function0)(JFunction0.mcI.sp & Serializable)() -> stmnt.executeUpdate(statement)), (Functor)$this.evidence$1$1).map((Function1)(JFunction1.mcVI.sp & Serializable)x$2 -> {
                        int n = x$2;
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    });
                    return object;
                }), (MonadCancel)this.evidence$1$1);
            }

            public F getNextIndicesForFunds(String party, String contract) {
                return (F)this.connection$1.use((Function1 & Serializable)conn -> implicits$.MODULE$.toFlatMapOps(Sync$.MODULE$.apply($this.evidence$1$1).blocking((Function0 & Serializable)() -> conn.createStatement()), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)stmnt -> implicits$.MODULE$.toFlatMapOps(Sync$.MODULE$.apply($this.evidence$1$1).blocking((Function0 & Serializable)() -> stmnt.executeQuery(new StringBuilder(51).append("SELECT x_party, party FROM parties WHERE party = '").append(party).append("'").toString())), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)rs -> implicits$.MODULE$.toFlatMapOps(Sync$.MODULE$.apply($this.evidence$1$1).delay((Function0)(JFunction0.mcI.sp & Serializable)() -> rs.getInt("x_party")), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)x -> anon.1.$anonfun$getNextIndicesForFunds$7(this, stmnt, contract, BoxesRunTime.unboxToInt((Object)x))))), (MonadCancel)this.evidence$1$1);
            }

            private F validateParty(String party) {
                return (F)this.connection$1.use((Function1 & Serializable)conn -> implicits$.MODULE$.toFlatMapOps(Sync$.MODULE$.apply($this.evidence$1$1).blocking((Function0 & Serializable)() -> conn.createStatement()), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)stmnt -> implicits$.MODULE$.toFunctorOps(Sync$.MODULE$.apply($this.evidence$1$1).blocking((Function0 & Serializable)() -> stmnt.executeQuery(new StringBuilder(51).append("SELECT x_party, party FROM parties WHERE party = '").append(party).append("'").toString())), (Functor)$this.evidence$1$1).map((Function1 & Serializable)rs -> rs.next() ? Validated$.MODULE$.validNel((Object)party) : Validated$.MODULE$.invalidNel((Object)"Party not found"))), (MonadCancel)this.evidence$1$1);
            }

            private F validateContract(String contract) {
                return (F)this.connection$1.use((Function1 & Serializable)conn -> implicits$.MODULE$.toFlatMapOps(Sync$.MODULE$.apply($this.evidence$1$1).blocking((Function0 & Serializable)() -> conn.createStatement()), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)stmnt -> implicits$.MODULE$.toFunctorOps(Sync$.MODULE$.apply($this.evidence$1$1).blocking((Function0 & Serializable)() -> stmnt.executeQuery(new StringBuilder(62).append("SELECT y_contract, contract FROM contracts WHERE contract = '").append(contract).append("'").toString())), (Functor)$this.evidence$1$1).map((Function1 & Serializable)rs -> rs.next() ? Validated$.MODULE$.validNel((Object)contract) : Validated$.MODULE$.invalidNel((Object)"Contract not found"))), (MonadCancel)this.evidence$1$1);
            }

            public F validateCurrentIndicesForFunds(String party, String contract, Option<Object> someState) {
                return (F)implicits$.MODULE$.toFlatMapOps(this.validateParty(party), (FlatMap)this.evidence$1$1).flatMap((Function1 & Serializable)validatedParty -> implicits$.MODULE$.toFlatMapOps(this.validateContract(contract), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)validatedContract -> implicits$.MODULE$.toFunctorOps(this.getCurrentIndicesForFunds(party, contract, someState), (Functor)$this.evidence$1$1).map((Function1 & Serializable)indices -> (Validated)implicits$.MODULE$.catsSyntaxTuple3Semigroupal(new Tuple3(validatedParty, validatedContract, (Object)OptionOps$.MODULE$.toValidNel$extension(implicits$.MODULE$.catsSyntaxOption(indices), (Function0 & Serializable)() -> "Indices not found"))).mapN((Function3 & Serializable)(x$4, x$5, index) -> index, (Functor)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyList$.MODULE$.catsDataSemigroupForNonEmptyList()), (Semigroupal)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyList$.MODULE$.catsDataSemigroupForNonEmptyList())))));
            }

            public F getAddress(String party, String contract, Option<Object> someState) {
                return (F)this.connection$1.use((Function1 & Serializable)conn -> implicits$.MODULE$.toFlatMapOps(Sync$.MODULE$.apply($this.evidence$1$1).blocking((Function0 & Serializable)() -> conn.createStatement()), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)stmnt -> implicits$.MODULE$.toFlatMapOps(Sync$.MODULE$.apply($this.evidence$1$1).blocking((Function0 & Serializable)() -> stmnt.executeQuery(new StringBuilder(51).append("SELECT x_party, party FROM parties WHERE party = '").append(party).append("'").toString())), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)rs -> implicits$.MODULE$.toFlatMapOps(implicits$.MODULE$.toFunctorOps(Sync$.MODULE$.apply($this.evidence$1$1).delay((Function0)(JFunction0.mcI.sp & Serializable)() -> rs.getInt("x_party")), (Functor)$this.evidence$1$1).map((Function1 & Serializable)x -> anon.1.$anonfun$getAddress$7(contract, BoxesRunTime.unboxToInt((Object)x))), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)x$8 -> {
                    Tuple2 tuple2 = x$8;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    int x = tuple2._1$mcI$sp();
                    String query = (String)tuple2._2();
                    Object object = implicits$.MODULE$.toFlatMapOps(Sync$.MODULE$.apply($this.evidence$1$1).blocking((Function0 & Serializable)() -> stmnt.executeQuery(query)), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)rs -> implicits$.MODULE$.toFlatMapOps(implicits$.MODULE$.toFunctorOps(Sync$.MODULE$.apply($this.evidence$1$1).delay((Function0)(JFunction0.mcI.sp & Serializable)() -> rs.getInt("y_contract")), (Functor)$this.evidence$1$1).map((Function1 & Serializable)y -> anon.1.$anonfun$getAddress$12(someState, x, BoxesRunTime.unboxToInt((Object)y))), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)x$7 -> {
                        Tuple2 tuple2 = x$7;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        String query = (String)tuple2._2();
                        Object object = implicits$.MODULE$.toFlatMapOps(Sync$.MODULE$.apply($this.evidence$1$1).blocking((Function0 & Serializable)() -> stmnt.executeQuery(query)), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)rs -> implicits$.MODULE$.toFunctorOps(Sync$.MODULE$.apply($this.evidence$1$1).delay((Function0 & Serializable)() -> rs.getString("address")), (Functor)$this.evidence$1$1).map((Function1 & Serializable)address -> rs.next() ? new Some(address) : None$.MODULE$));
                        return object;
                    }));
                    return object;
                }))), (MonadCancel)this.evidence$1$1);
            }

            public F getCurrentIndicesForFunds(String party, String contract, Option<Object> someState) {
                return (F)this.connection$1.use((Function1 & Serializable)conn -> implicits$.MODULE$.toFlatMapOps(Sync$.MODULE$.apply($this.evidence$1$1).blocking((Function0 & Serializable)() -> conn.createStatement()), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)stmnt -> implicits$.MODULE$.toFlatMapOps(Sync$.MODULE$.apply($this.evidence$1$1).blocking((Function0 & Serializable)() -> stmnt.executeQuery(new StringBuilder(51).append("SELECT x_party, party FROM parties WHERE party = '").append(party).append("'").toString())), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)rs -> implicits$.MODULE$.toFlatMapOps(implicits$.MODULE$.toFunctorOps(Sync$.MODULE$.apply($this.evidence$1$1).delay((Function0)(JFunction0.mcI.sp & Serializable)() -> rs.getInt("x_party")), (Functor)$this.evidence$1$1).map((Function1 & Serializable)x -> anon.1.$anonfun$getCurrentIndicesForFunds$7(contract, BoxesRunTime.unboxToInt((Object)x))), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)x$10 -> {
                    Tuple2 tuple2 = x$10;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    int x = tuple2._1$mcI$sp();
                    String query = (String)tuple2._2();
                    Object object = implicits$.MODULE$.toFlatMapOps(Sync$.MODULE$.apply($this.evidence$1$1).blocking((Function0 & Serializable)() -> stmnt.executeQuery(query)), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)rs -> implicits$.MODULE$.toFlatMapOps(Sync$.MODULE$.apply($this.evidence$1$1).delay((Function0)(JFunction0.mcI.sp & Serializable)() -> rs.getInt("y_contract")), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)y -> anon.1.$anonfun$getCurrentIndicesForFunds$12(this, stmnt, someState, x, BoxesRunTime.unboxToInt((Object)y))));
                    return object;
                }))), (MonadCancel)this.evidence$1$1);
            }

            public F getCurrentAddress() {
                return (F)this.connection$1.use((Function1 & Serializable)conn -> implicits$.MODULE$.toFlatMapOps(Sync$.MODULE$.apply($this.evidence$1$1).blocking((Function0 & Serializable)() -> conn.createStatement()), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)stmnt -> implicits$.MODULE$.toFlatMapOps(Sync$.MODULE$.apply($this.evidence$1$1).blocking((Function0 & Serializable)() -> stmnt.executeQuery("SELECT address, MAX(z_state) FROM cartesian WHERE x_party = 1 AND y_contract = 1  group by x_party, y_contract")), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)rs -> implicits$.MODULE$.toFunctorOps(Sync$.MODULE$.apply($this.evidence$1$1).delay((Function0 & Serializable)() -> rs.getString("address")), (Functor)$this.evidence$1$1).map((Function1 & Serializable)lockAddress -> lockAddress))), (MonadCancel)this.evidence$1$1);
            }

            public F initWalletState(VerificationKey vk) {
                return (F)this.connection$1.use((Function1 & Serializable)conn -> implicits$.MODULE$.toFlatMapOps(Sync$.MODULE$.apply($this.evidence$1$1).delay((Function0 & Serializable)() -> conn.createStatement()), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)stmnt -> implicits$.MODULE$.toFlatMapOps(Sync$.MODULE$.apply($this.evidence$1$1).delay((Function0)(JFunction0.mcZ.sp & Serializable)() -> stmnt.execute("CREATE TABLE IF NOT EXISTS cartesian (id INTEGER PRIMARY KEY, x_party INTEGER NOT NULL, y_contract INTEGER NOT NULL, z_state INTEGER NOT NULL, lock_predicate TEXT NOT NULL, address TEXT NOT NULL, routine TEXT, vk TEXT)")), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)x$29 -> anon.1.$anonfun$initWalletState$5(this, stmnt, vk, BoxesRunTime.unboxToBoolean((Object)x$29)))), (MonadCancel)this.evidence$1$1);
            }

            public F getPreimage(Proposition.Digest digestProposition) {
                return (F)Sync$.MODULE$.apply(this.evidence$1$1).delay((Function0 & Serializable)() -> None$.MODULE$);
            }

            public F addEntityVks(String party, String contract, List<String> entities) {
                return (F)this.connection$1.use((Function1 & Serializable)conn -> implicits$.MODULE$.toFlatMapOps(Sync$.MODULE$.apply($this.evidence$1$1).blocking((Function0 & Serializable)() -> conn.createStatement()), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)stmnt -> implicits$.MODULE$.toFlatMapOps(Sync$.MODULE$.apply($this.evidence$1$1).blocking((Function0 & Serializable)() -> stmnt.executeQuery(new StringBuilder(44).append("SELECT x_party FROM parties WHERE party = '").append(party).append("'").toString())), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)rs -> implicits$.MODULE$.toFlatMapOps(Sync$.MODULE$.apply($this.evidence$1$1).delay((Function0)(JFunction0.mcI.sp & Serializable)() -> rs.getInt("x_party")), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)x -> anon.1.$anonfun$addEntityVks$7(this, stmnt, contract, entities, BoxesRunTime.unboxToInt((Object)x))))), (MonadCancel)this.evidence$1$1);
            }

            public F getEntityVks(String party, String contract) {
                return (F)this.connection$1.use((Function1 & Serializable)conn -> implicits$.MODULE$.toFlatMapOps(Sync$.MODULE$.apply($this.evidence$1$1).blocking((Function0 & Serializable)() -> conn.createStatement()), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)stmnt -> implicits$.MODULE$.toFlatMapOps(Sync$.MODULE$.apply($this.evidence$1$1).blocking((Function0 & Serializable)() -> stmnt.executeQuery(new StringBuilder(44).append("SELECT x_party FROM parties WHERE party = '").append(party).append("'").toString())), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)rs -> implicits$.MODULE$.toFlatMapOps(Sync$.MODULE$.apply($this.evidence$1$1).delay((Function0)(JFunction0.mcI.sp & Serializable)() -> rs.getInt("x_party")), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)x -> anon.1.$anonfun$getEntityVks$7(this, stmnt, contract, BoxesRunTime.unboxToInt((Object)x))))), (MonadCancel)this.evidence$1$1);
            }

            public F addNewLockTemplate(String contract, LockTemplate<F> lockTemplate) {
                return (F)this.connection$1.use((Function1 & Serializable)conn -> implicits$.MODULE$.toFlatMapOps(Sync$.MODULE$.apply($this.evidence$1$1).blocking((Function0 & Serializable)() -> conn.createStatement()), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)stmnt -> implicits$.MODULE$.toFlatMapOps(Sync$.MODULE$.apply($this.evidence$1$1).blocking((Function0 & Serializable)() -> stmnt.executeQuery("SELECT MAX(y_contract) as y_index FROM contracts")), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)rs -> implicits$.MODULE$.toFlatMapOps(implicits$.MODULE$.toFunctorOps(Sync$.MODULE$.apply($this.evidence$1$1).delay((Function0)(JFunction0.mcI.sp & Serializable)() -> rs.getInt("y_index")), (Functor)$this.evidence$1$1).map((Function1 & Serializable)y -> anon.1.$anonfun$addNewLockTemplate$7(this, contract, lockTemplate, BoxesRunTime.unboxToInt((Object)y))), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)x$34 -> {
                    Tuple2 tuple2 = x$34;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    String statement = (String)tuple2._2();
                    Object object = implicits$.MODULE$.toFunctorOps(Sync$.MODULE$.apply($this.evidence$1$1).blocking((Function0)(JFunction0.mcI.sp & Serializable)() -> stmnt.executeUpdate(statement)), (Functor)$this.evidence$1$1).map((Function1)(JFunction1.mcVI.sp & Serializable)x$33 -> {
                        int n = x$33;
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    });
                    return object;
                }))), (MonadCancel)this.evidence$1$1);
            }

            public F getLockTemplate(String contract) {
                return (F)this.connection$1.use((Function1 & Serializable)conn -> implicits$.MODULE$.toFlatMapOps(Sync$.MODULE$.apply($this.evidence$1$1).blocking((Function0 & Serializable)() -> conn.createStatement()), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)stmnt -> implicits$.MODULE$.toFlatMapOps(Sync$.MODULE$.apply($this.evidence$1$1).blocking((Function0 & Serializable)() -> stmnt.executeQuery(new StringBuilder(46).append("SELECT lock FROM contracts WHERE contract = '").append(contract).append("'").toString())), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)rs -> implicits$.MODULE$.toFunctorOps(Sync$.MODULE$.apply($this.evidence$1$1).delay((Function0 & Serializable)() -> rs.getString("lock")), (Functor)$this.evidence$1$1).map((Function1 & Serializable)lockStr -> !rs.next() ? None$.MODULE$ : io.circe.parser.package$.MODULE$.parse(lockStr).toOption().flatMap((Function1 & Serializable)x$35 -> LockTemplateCodecs$.MODULE$.decodeLockTemplate(x$35, (Monad)$this.evidence$1$1).toOption())))), (MonadCancel)this.evidence$1$1);
            }

            public F getLock(String party, String contract, int nextState) {
                return (F)implicits$.MODULE$.toFlatMapOps(this.getLockTemplate(contract), (FlatMap)this.evidence$1$1).flatMap((Function1 & Serializable)changeTemplate -> implicits$.MODULE$.toFlatMapOps(implicits$.MODULE$.toFunctorOps(this.getEntityVks(party, contract), (Functor)$this.evidence$1$1).map((Function1 & Serializable)x$36 -> x$36.map((Function1 & Serializable)x$37 -> x$37.map((Function1 & Serializable)vk -> (VerificationKey)VerificationKey$.MODULE$.parseFrom((byte[])Encoding$.MODULE$.decodeFromBase58(vk).toOption().get())))), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)entityVks -> implicits$.MODULE$.toFlatMapOps(implicits$.MODULE$.toTraverseOps((Object)entityVks.map((Function1 & Serializable)vks -> implicits$.MODULE$.toTraverseOps((Object)vks.map((Function1 & Serializable)x$38 -> $this.walletApi$1.deriveChildVerificationKey(x$38, nextState)), implicits$.MODULE$.catsStdInstancesForList()).sequence((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Applicative)$this.evidence$1$1)), implicits$.MODULE$.catsStdInstancesForOption()).sequence((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Applicative)$this.evidence$1$1), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)childVks -> implicits$.MODULE$.toFunctorOps(implicits$.MODULE$.toFunctorOps(implicits$.MODULE$.toTraverseOps((Object)changeTemplate.flatMap((Function1 & Serializable)template -> childVks.map((Function1 & Serializable)vks -> implicits$.MODULE$.toFunctorOps(template.build(vks), (Functor)$this.evidence$1$1).map((Function1 & Serializable)x$39 -> x$39.toOption()))), implicits$.MODULE$.catsStdInstancesForOption()).sequence((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Applicative)$this.evidence$1$1), (Functor)$this.evidence$1$1).map((Function1 & Serializable)x$40 -> x$40.flatten((.less.colon.less)$less$colon$less$.MODULE$.refl())), (Functor)$this.evidence$1$1).map((Function1 & Serializable)changeLock -> changeLock))));
            }

            public static final /* synthetic */ Option $anonfun$getIndicesBySignature$11(ResultSet rs$1, int x$41, int y$1, int z) {
                return rs$1.next() ? new Some((Object)new Indices(x$41, y$1, z, Indices$.MODULE$.apply$default$4())) : None$.MODULE$;
            }

            public static final /* synthetic */ Object $anonfun$getIndicesBySignature$9(anon.1 $this, ResultSet rs$1, int x$41, int y) {
                return implicits$.MODULE$.toFunctorOps(Sync$.MODULE$.apply($this.evidence$1$1).delay((Function0)(JFunction0.mcI.sp & Serializable)() -> rs$1.getInt("z_state")), (Functor)$this.evidence$1$1).map((Function1 & Serializable)z -> anon.1.$anonfun$getIndicesBySignature$11(rs$1, x$41, y, BoxesRunTime.unboxToInt((Object)z)));
            }

            public static final /* synthetic */ Object $anonfun$getIndicesBySignature$7(anon.1 $this, ResultSet rs$1, int x) {
                return implicits$.MODULE$.toFlatMapOps(Sync$.MODULE$.apply($this.evidence$1$1).delay((Function0)(JFunction0.mcI.sp & Serializable)() -> rs$1.getInt("y_contract")), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)y -> anon.1.$anonfun$getIndicesBySignature$9($this, rs$1, x, BoxesRunTime.unboxToInt((Object)y)));
            }

            public static final /* synthetic */ Object $anonfun$getLockByIndex$7(anon.1 $this, ResultSet rs$2, boolean x$1) {
                boolean bl = x$1;
                Object object = implicits$.MODULE$.toFunctorOps(Sync$.MODULE$.apply($this.evidence$1$1).delay((Function0 & Serializable)() -> rs$2.getString("lock_predicate")), (Functor)$this.evidence$1$1).map((Function1 & Serializable)lock_predicate -> new Some((Object)Lock.Predicate$.MODULE$.parseFrom((byte[])Encoding$.MODULE$.decodeFromBase58Check(lock_predicate).toOption().get())));
                return object;
            }

            public static final /* synthetic */ Option $anonfun$getNextIndicesForFunds$15(ResultSet rs$5, int x$42, int y$2, int z) {
                return rs$5.next() ? new Some((Object)new Indices(x$42, y$2, z + 1, Indices$.MODULE$.apply$default$4())) : None$.MODULE$;
            }

            public static final /* synthetic */ Object $anonfun$getNextIndicesForFunds$11(anon.1 $this, Statement stmnt$4, int x$42, int y) {
                return implicits$.MODULE$.toFlatMapOps(Sync$.MODULE$.apply($this.evidence$1$1).blocking((Function0 & Serializable)() -> stmnt$4.executeQuery(new StringBuilder(101).append("SELECT x_party, y_contract, MAX(z_state) as z_index FROM cartesian WHERE x_party = ").append(x$42).append(" AND y_contract = ").append(y).toString())), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)rs -> implicits$.MODULE$.toFunctorOps(Sync$.MODULE$.apply($this.evidence$1$1).delay((Function0)(JFunction0.mcI.sp & Serializable)() -> rs.getInt("z_index")), (Functor)$this.evidence$1$1).map((Function1 & Serializable)z -> anon.1.$anonfun$getNextIndicesForFunds$15(rs, x$42, y, BoxesRunTime.unboxToInt((Object)z))));
            }

            public static final /* synthetic */ Object $anonfun$getNextIndicesForFunds$7(anon.1 $this, Statement stmnt$4, String contract$1, int x) {
                return implicits$.MODULE$.toFlatMapOps(Sync$.MODULE$.apply($this.evidence$1$1).blocking((Function0 & Serializable)() -> stmnt$4.executeQuery(new StringBuilder(62).append("SELECT y_contract, contract FROM contracts WHERE contract = '").append(contract$1).append("'").toString())), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)rs -> implicits$.MODULE$.toFlatMapOps(Sync$.MODULE$.apply($this.evidence$1$1).delay((Function0)(JFunction0.mcI.sp & Serializable)() -> rs.getInt("y_contract")), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)y -> anon.1.$anonfun$getNextIndicesForFunds$11($this, stmnt$4, x, BoxesRunTime.unboxToInt((Object)y))));
            }

            public static final /* synthetic */ Tuple2 $anonfun$getAddress$7(String contract$4, int x) {
                String query = new StringBuilder(62).append("SELECT y_contract, contract FROM contracts WHERE contract = '").append(contract$4).append("'").toString();
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)x), (Object)query);
            }

            public static final /* synthetic */ String $anonfun$getAddress$13(int x$6) {
                return "z_state as z_index";
            }

            public static final /* synthetic */ String $anonfun$getAddress$15(int x) {
                return new StringBuilder(15).append(" AND z_state = ").append(x).toString();
            }

            public static final /* synthetic */ Tuple2 $anonfun$getAddress$12(Option someState$2, int x$43, int y) {
                String query = new StringBuilder(0).append("SELECT address, x_party, y_contract, ").append(someState$2.map((Function1 & Serializable)x$6 -> anon.1.$anonfun$getAddress$13(BoxesRunTime.unboxToInt((Object)x$6))).getOrElse((Function0 & Serializable)() -> "MAX(z_state) as z_index")).append(new StringBuilder(50).append(" FROM cartesian WHERE x_party = ").append(x$43).append(" AND y_contract = ").append(y).toString()).append(someState$2.map((Function1 & Serializable)x -> anon.1.$anonfun$getAddress$15(BoxesRunTime.unboxToInt((Object)x))).getOrElse((Function0 & Serializable)() -> "")).toString();
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)y), (Object)query);
            }

            public static final /* synthetic */ Tuple2 $anonfun$getCurrentIndicesForFunds$7(String contract$5, int x) {
                String query = new StringBuilder(62).append("SELECT y_contract, contract FROM contracts WHERE contract = '").append(contract$5).append("'").toString();
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)x), (Object)query);
            }

            public static final /* synthetic */ String $anonfun$getCurrentIndicesForFunds$14(int x$9) {
                return "z_state as z_index";
            }

            public static final /* synthetic */ String $anonfun$getCurrentIndicesForFunds$16(int x) {
                return new StringBuilder(15).append(" AND z_state = ").append(x).toString();
            }

            public static final /* synthetic */ Object $anonfun$getCurrentIndicesForFunds$19(anon.1 $this, int x) {
                return Sync$.MODULE$.apply($this.evidence$1$1).point((Object)BoxesRunTime.boxToInteger((int)x));
            }

            public static final /* synthetic */ Option $anonfun$getCurrentIndicesForFunds$22(ResultSet rs$11, int x$44, int y$3, int z) {
                return rs$11.next() ? new Some((Object)new Indices(x$44, y$3, z, Indices$.MODULE$.apply$default$4())) : None$.MODULE$;
            }

            public static final /* synthetic */ Object $anonfun$getCurrentIndicesForFunds$12(anon.1 $this, Statement stmnt$8, Option someState$3, int x$44, int y) {
                return implicits$.MODULE$.toFlatMapOps(Sync$.MODULE$.apply($this.evidence$1$1).blocking((Function0 & Serializable)() -> stmnt$8.executeQuery(new StringBuilder(0).append("SELECT x_party, y_contract, ").append(someState$3.map((Function1 & Serializable)x$9 -> anon.1.$anonfun$getCurrentIndicesForFunds$14(BoxesRunTime.unboxToInt((Object)x$9))).getOrElse((Function0 & Serializable)() -> "MAX(z_state) as z_index")).append(new StringBuilder(50).append(" FROM cartesian WHERE x_party = ").append(x$44).append(" AND y_contract = ").append(y).toString()).append(someState$3.map((Function1 & Serializable)x -> anon.1.$anonfun$getCurrentIndicesForFunds$16(BoxesRunTime.unboxToInt((Object)x))).getOrElse((Function0 & Serializable)() -> "")).toString())), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)rs -> implicits$.MODULE$.toFunctorOps(someState$3.map((Function1 & Serializable)x -> anon.1.$anonfun$getCurrentIndicesForFunds$19($this, BoxesRunTime.unboxToInt((Object)x))).getOrElse((Function0 & Serializable)() -> Sync$.MODULE$.apply($this.evidence$1$1).delay((Function0)(JFunction0.mcI.sp & Serializable)() -> rs.getInt("z_index"))), (Functor)$this.evidence$1$1).map((Function1 & Serializable)z -> anon.1.$anonfun$getCurrentIndicesForFunds$22(rs, x$44, y, BoxesRunTime.unboxToInt((Object)z))));
            }

            public static final /* synthetic */ void $anonfun$initWalletState$48(BoxedUnit x$13) {
                BoxedUnit boxedUnit = x$13;
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
            }

            public static final /* synthetic */ Object $anonfun$initWalletState$46(anon.1 $this, Statement stmnt$10, int x$14) {
                int n = x$14;
                Object object = implicits$.MODULE$.toFunctorOps(Sync$.MODULE$.apply($this.evidence$1$1).delay((Function0)(JFunction0.mcV.sp & Serializable)() -> stmnt$10.close()), (Functor)$this.evidence$1$1).map((Function1 & Serializable)x$13 -> {
                    anon.1.$anonfun$initWalletState$48(x$13);
                    return BoxedUnit.UNIT;
                });
                return object;
            }

            public static final /* synthetic */ Object $anonfun$initWalletState$44(anon.1 $this, Statement stmnt$10, Lock genesisHeightLock$1, LockAddress heightLockAddress$1, int x$15) {
                int n = x$15;
                Object object = implicits$.MODULE$.toFlatMapOps(Sync$.MODULE$.apply($this.evidence$1$1).delay((Function0)(JFunction0.mcI.sp & Serializable)() -> stmnt$10.executeUpdate(new StringBuilder(102).append("INSERT INTO cartesian (x_party, y_contract, z_state, lock_predicate, address) VALUES (0, 2, 1, '").append(Encoding$.MODULE$.encodeToBase58Check(genesisHeightLock$1.getPredicate().toByteArray())).append("', '").append(TransactionBuilderApi.implicits$.MODULE$.lockAddressOps(heightLockAddress$1).toBase58()).append("')").toString())), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)x$14 -> anon.1.$anonfun$initWalletState$46($this, stmnt$10, BoxesRunTime.unboxToInt((Object)x$14)));
                return object;
            }

            public static final /* synthetic */ Object $anonfun$initWalletState$35(anon.1 $this, VerificationKey vk$2, Statement stmnt$10, int x$16) {
                int n = x$16;
                Object object = implicits$.MODULE$.toFlatMapOps(implicits$.MODULE$.toFunctorOps($this.getLock("self", "default", 1), (Functor)$this.evidence$1$1).map((Function1 & Serializable)x$11 -> (Lock)x$11.get()), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)defaultSignatureLock -> implicits$.MODULE$.toFlatMapOps($this.transactionBuilderApi$1.lockAddress(defaultSignatureLock), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)signatureLockAddress -> implicits$.MODULE$.toFlatMapOps($this.walletApi$1.deriveChildVerificationKey(vk$2, 1), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)childVk -> implicits$.MODULE$.toFlatMapOps(implicits$.MODULE$.toFunctorOps($this.getLock("noparty", "genesis", 1), (Functor)$this.evidence$1$1).map((Function1 & Serializable)x$12 -> (Lock)x$12.get()), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)genesisHeightLock -> implicits$.MODULE$.toFlatMapOps($this.transactionBuilderApi$1.lockAddress(genesisHeightLock), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)heightLockAddress -> implicits$.MODULE$.toFlatMapOps(Sync$.MODULE$.apply($this.evidence$1$1).delay((Function0)(JFunction0.mcI.sp & Serializable)() -> stmnt$10.executeUpdate(new StringBuilder(138).append("INSERT INTO cartesian (x_party, y_contract, z_state, lock_predicate, address, routine, vk) VALUES (1, 1, 1, '").append(Encoding$.MODULE$.encodeToBase58Check(defaultSignatureLock.getPredicate().toByteArray())).append("', '").append(TransactionBuilderApi.implicits$.MODULE$.lockAddressOps(signatureLockAddress).toBase58()).append("', ").append("'ExtendedEd25519', ").append("'").append(Encoding$.MODULE$.encodeToBase58(childVk.toByteArray())).append("'").append(")").toString())), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)x$15 -> anon.1.$anonfun$initWalletState$44($this, stmnt$10, genesisHeightLock, heightLockAddress, BoxesRunTime.unboxToInt((Object)x$15))))))));
                return object;
            }

            public static final /* synthetic */ Object $anonfun$initWalletState$33(anon.1 $this, Statement stmnt$10, VerificationKey vk$2, int x$17) {
                int n = x$17;
                Object object = implicits$.MODULE$.toFlatMapOps(Sync$.MODULE$.apply($this.evidence$1$1).delay((Function0)(JFunction0.mcI.sp & Serializable)() -> stmnt$10.executeUpdate(new StringBuilder(74).append("INSERT INTO verification_keys (x_party, y_contract, vks) VALUES (0, 2, '").append(package.EncoderOps$.MODULE$.asJson$extension(io.circe.syntax.package$.MODULE$.EncoderOps(package$.MODULE$.List().apply((Seq)Nil$.MODULE$)), (Encoder)Encoder$.MODULE$.encodeList(Encoder$.MODULE$.encodeString())).toString()).append("')").toString())), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)x$16 -> anon.1.$anonfun$initWalletState$35($this, vk$2, stmnt$10, BoxesRunTime.unboxToInt((Object)x$16)));
                return object;
            }

            public static final /* synthetic */ Object $anonfun$initWalletState$31(anon.1 $this, Statement stmnt$10, VerificationKey vk$2, int x$18) {
                int n = x$18;
                Object object = implicits$.MODULE$.toFlatMapOps(Sync$.MODULE$.apply($this.evidence$1$1).delay((Function0)(JFunction0.mcI.sp & Serializable)() -> stmnt$10.executeUpdate(new StringBuilder(74).append("INSERT INTO verification_keys (x_party, y_contract, vks) VALUES (1, 1, '").append(package.EncoderOps$.MODULE$.asJson$extension(io.circe.syntax.package$.MODULE$.EncoderOps(package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{Encoding$.MODULE$.encodeToBase58(vk$2.toByteArray())}))), (Encoder)Encoder$.MODULE$.encodeList(Encoder$.MODULE$.encodeString())).toString()).append("')").toString())), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)x$17 -> anon.1.$anonfun$initWalletState$33($this, stmnt$10, vk$2, BoxesRunTime.unboxToInt((Object)x$17)));
                return object;
            }

            public static final /* synthetic */ Object $anonfun$initWalletState$29(anon.1 $this, Statement stmnt$10, LockTemplate.PredicateTemplate genesisTemplate$1, VerificationKey vk$2, int x$19) {
                int n = x$19;
                Object object = implicits$.MODULE$.toFlatMapOps(Sync$.MODULE$.apply($this.evidence$1$1).delay((Function0)(JFunction0.mcI.sp & Serializable)() -> stmnt$10.executeUpdate(new StringBuilder(76).append("INSERT INTO contracts (contract, y_contract, lock) VALUES ('genesis', 2, '").append(LockTemplateCodecs$.MODULE$.encodeLockTemplate((LockTemplate)genesisTemplate$1, (Monad)$this.evidence$1$1).toString()).append("')").toString())), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)x$18 -> anon.1.$anonfun$initWalletState$31($this, stmnt$10, vk$2, BoxesRunTime.unboxToInt((Object)x$18)));
                return object;
            }

            public static final /* synthetic */ Object $anonfun$initWalletState$27(anon.1 $this, Statement stmnt$10, LockTemplate.PredicateTemplate defaultTemplate$1, LockTemplate.PredicateTemplate genesisTemplate$1, VerificationKey vk$2, int x$20) {
                int n = x$20;
                Object object = implicits$.MODULE$.toFlatMapOps(Sync$.MODULE$.apply($this.evidence$1$1).delay((Function0)(JFunction0.mcI.sp & Serializable)() -> stmnt$10.executeUpdate(new StringBuilder(76).append("INSERT INTO contracts (contract, y_contract, lock) VALUES ('default', 1, '").append(LockTemplateCodecs$.MODULE$.encodeLockTemplate((LockTemplate)defaultTemplate$1, (Monad)$this.evidence$1$1).toString()).append("')").toString())), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)x$19 -> anon.1.$anonfun$initWalletState$29($this, stmnt$10, genesisTemplate$1, vk$2, BoxesRunTime.unboxToInt((Object)x$19)));
                return object;
            }

            public static final /* synthetic */ Object $anonfun$initWalletState$25(anon.1 $this, Statement stmnt$10, LockTemplate.PredicateTemplate defaultTemplate$1, LockTemplate.PredicateTemplate genesisTemplate$1, VerificationKey vk$2, int x$21) {
                int n = x$21;
                Object object = implicits$.MODULE$.toFlatMapOps(Sync$.MODULE$.apply($this.evidence$1$1).delay((Function0)(JFunction0.mcI.sp & Serializable)() -> stmnt$10.executeUpdate("INSERT INTO parties (party, x_party) VALUES ('self', 1)")), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)x$20 -> anon.1.$anonfun$initWalletState$27($this, stmnt$10, defaultTemplate$1, genesisTemplate$1, vk$2, BoxesRunTime.unboxToInt((Object)x$20)));
                return object;
            }

            public static final /* synthetic */ Object $anonfun$initWalletState$19(anon.1 $this, Statement stmnt$10, VerificationKey vk$2, boolean x$22) {
                boolean bl = x$22;
                Object object = implicits$.MODULE$.toFlatMapOps(Sync$.MODULE$.apply($this.evidence$1$1).delay((Function0 & Serializable)() -> new LockTemplate.PredicateTemplate((Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PropositionTemplate.SignatureTemplate[]{new PropositionTemplate.SignatureTemplate("ExtendedEd25519", 0, (Monad)$this.evidence$1$1)})), 1, (Monad)$this.evidence$1$1)), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)defaultTemplate -> implicits$.MODULE$.toFlatMapOps(Sync$.MODULE$.apply($this.evidence$1$1).delay((Function0 & Serializable)() -> new LockTemplate.PredicateTemplate((Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PropositionTemplate.HeightTemplate[]{new PropositionTemplate.HeightTemplate("header", 1L, Long.MAX_VALUE, (Monad)$this.evidence$1$1)})), 1, (Monad)$this.evidence$1$1)), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)genesisTemplate -> implicits$.MODULE$.toFlatMapOps(Sync$.MODULE$.apply($this.evidence$1$1).delay((Function0)(JFunction0.mcI.sp & Serializable)() -> stmnt$10.executeUpdate("INSERT INTO parties (party, x_party) VALUES ('noparty', 0)")), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)x$21 -> anon.1.$anonfun$initWalletState$25($this, stmnt$10, defaultTemplate, genesisTemplate, vk$2, BoxesRunTime.unboxToInt((Object)x$21)))));
                return object;
            }

            public static final /* synthetic */ Object $anonfun$initWalletState$17(anon.1 $this, Statement stmnt$10, VerificationKey vk$2, boolean x$23) {
                boolean bl = x$23;
                Object object = implicits$.MODULE$.toFlatMapOps(Sync$.MODULE$.apply($this.evidence$1$1).delay((Function0)(JFunction0.mcZ.sp & Serializable)() -> stmnt$10.execute("CREATE INDEX IF NOT EXISTS signature_idx ON cartesian (routine, vk)")), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)x$22 -> anon.1.$anonfun$initWalletState$19($this, stmnt$10, vk$2, BoxesRunTime.unboxToBoolean((Object)x$22)));
                return object;
            }

            public static final /* synthetic */ Object $anonfun$initWalletState$15(anon.1 $this, Statement stmnt$10, VerificationKey vk$2, boolean x$24) {
                boolean bl = x$24;
                Object object = implicits$.MODULE$.toFlatMapOps(Sync$.MODULE$.apply($this.evidence$1$1).delay((Function0)(JFunction0.mcZ.sp & Serializable)() -> stmnt$10.execute("CREATE UNIQUE INDEX IF NOT EXISTS cartesian_coordinates ON cartesian (x_party, y_contract, z_state)")), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)x$23 -> anon.1.$anonfun$initWalletState$17($this, stmnt$10, vk$2, BoxesRunTime.unboxToBoolean((Object)x$23)));
                return object;
            }

            public static final /* synthetic */ Object $anonfun$initWalletState$13(anon.1 $this, Statement stmnt$10, VerificationKey vk$2, boolean x$25) {
                boolean bl = x$25;
                Object object = implicits$.MODULE$.toFlatMapOps(Sync$.MODULE$.apply($this.evidence$1$1).delay((Function0)(JFunction0.mcZ.sp & Serializable)() -> stmnt$10.execute("CREATE INDEX IF NOT EXISTS party_names_idx ON parties (party)")), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)x$24 -> anon.1.$anonfun$initWalletState$15($this, stmnt$10, vk$2, BoxesRunTime.unboxToBoolean((Object)x$24)));
                return object;
            }

            public static final /* synthetic */ Object $anonfun$initWalletState$11(anon.1 $this, Statement stmnt$10, VerificationKey vk$2, boolean x$26) {
                boolean bl = x$26;
                Object object = implicits$.MODULE$.toFlatMapOps(Sync$.MODULE$.apply($this.evidence$1$1).delay((Function0)(JFunction0.mcZ.sp & Serializable)() -> stmnt$10.execute("CREATE UNIQUE INDEX IF NOT EXISTS contract_names_idx ON contracts (contract)")), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)x$25 -> anon.1.$anonfun$initWalletState$13($this, stmnt$10, vk$2, BoxesRunTime.unboxToBoolean((Object)x$25)));
                return object;
            }

            public static final /* synthetic */ Object $anonfun$initWalletState$9(anon.1 $this, Statement stmnt$10, VerificationKey vk$2, boolean x$27) {
                boolean bl = x$27;
                Object object = implicits$.MODULE$.toFlatMapOps(Sync$.MODULE$.apply($this.evidence$1$1).delay((Function0)(JFunction0.mcZ.sp & Serializable)() -> stmnt$10.execute("CREATE TABLE IF NOT EXISTS verification_keys (x_party INTEGER NOT NULL, y_contract INTEGER NOT NULL, vks TEXT NOT NULL, PRIMARY KEY (x_party, y_contract))")), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)x$26 -> anon.1.$anonfun$initWalletState$11($this, stmnt$10, vk$2, BoxesRunTime.unboxToBoolean((Object)x$26)));
                return object;
            }

            public static final /* synthetic */ Object $anonfun$initWalletState$7(anon.1 $this, Statement stmnt$10, VerificationKey vk$2, boolean x$28) {
                boolean bl = x$28;
                Object object = implicits$.MODULE$.toFlatMapOps(Sync$.MODULE$.apply($this.evidence$1$1).delay((Function0)(JFunction0.mcZ.sp & Serializable)() -> stmnt$10.execute("CREATE TABLE IF NOT EXISTS contracts (contract TEXT NOT NULL, y_contract INTEGER PRIMARY KEY ASC,  lock TEXT NOT NULL)")), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)x$27 -> anon.1.$anonfun$initWalletState$9($this, stmnt$10, vk$2, BoxesRunTime.unboxToBoolean((Object)x$27)));
                return object;
            }

            public static final /* synthetic */ Object $anonfun$initWalletState$5(anon.1 $this, Statement stmnt$10, VerificationKey vk$2, boolean x$29) {
                boolean bl = x$29;
                Object object = implicits$.MODULE$.toFlatMapOps(Sync$.MODULE$.apply($this.evidence$1$1).delay((Function0)(JFunction0.mcZ.sp & Serializable)() -> stmnt$10.execute("CREATE TABLE IF NOT EXISTS parties (party TEXT, x_party INTEGER PRIMARY KEY ASC)")), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)x$28 -> anon.1.$anonfun$initWalletState$7($this, stmnt$10, vk$2, BoxesRunTime.unboxToBoolean((Object)x$28)));
                return object;
            }

            public static final /* synthetic */ Tuple2 $anonfun$addEntityVks$11(int x$45, List entities$1, int y) {
                String statement = new StringBuilder(0).append(new StringBuilder(69).append("INSERT INTO verification_keys (x_party, y_contract, vks) VALUES (").append(x$45).append(", ").append(y).append(", ").toString()).append(new StringBuilder(3).append("'").append(package.EncoderOps$.MODULE$.asJson$extension(io.circe.syntax.package$.MODULE$.EncoderOps((Object)entities$1), (Encoder)Encoder$.MODULE$.encodeList(Encoder$.MODULE$.encodeString())).toString()).append("')").toString()).toString();
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)y), (Object)statement);
            }

            public static final /* synthetic */ Object $anonfun$addEntityVks$7(anon.1 $this, Statement stmnt$11, String contract$6, List entities$1, int x) {
                return implicits$.MODULE$.toFlatMapOps(Sync$.MODULE$.apply($this.evidence$1$1).blocking((Function0 & Serializable)() -> stmnt$11.executeQuery(new StringBuilder(52).append("SELECT y_contract FROM contracts WHERE contract = '").append(contract$6).append("'").toString())), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)rs -> implicits$.MODULE$.toFlatMapOps(implicits$.MODULE$.toFunctorOps(Sync$.MODULE$.apply($this.evidence$1$1).delay((Function0)(JFunction0.mcI.sp & Serializable)() -> rs.getInt("y_contract")), (Functor)$this.evidence$1$1).map((Function1 & Serializable)y -> anon.1.$anonfun$addEntityVks$11(x, entities$1, BoxesRunTime.unboxToInt((Object)y))), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)x$31 -> {
                    Tuple2 tuple2 = x$31;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    String statement = (String)tuple2._2();
                    Object object = implicits$.MODULE$.toFunctorOps(Sync$.MODULE$.apply($this.evidence$1$1).blocking((Function0)(JFunction0.mcI.sp & Serializable)() -> stmnt$11.executeUpdate(statement)), (Functor)$this.evidence$1$1).map((Function1)(JFunction1.mcVI.sp & Serializable)x$30 -> {
                        int n = x$30;
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    });
                    return object;
                }));
            }

            public static final /* synthetic */ Object $anonfun$getEntityVks$11(anon.1 $this, Statement stmnt$12, int x$46, int y) {
                return implicits$.MODULE$.toFlatMapOps(Sync$.MODULE$.apply($this.evidence$1$1).blocking((Function0 & Serializable)() -> stmnt$12.executeQuery(new StringBuilder(68).append("SELECT vks FROM verification_keys WHERE x_party = ").append(x$46).append(" AND y_contract = ").append(y).toString())), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)rs -> implicits$.MODULE$.toFunctorOps(Sync$.MODULE$.apply($this.evidence$1$1).delay((Function0 & Serializable)() -> rs.getString("vks")), (Functor)$this.evidence$1$1).map((Function1 & Serializable)vks -> !rs.next() ? None$.MODULE$ : io.circe.parser.package$.MODULE$.parse(vks).toOption().flatMap((Function1 & Serializable)x$32 -> x$32.as(Decoder$.MODULE$.decodeList(Decoder$.MODULE$.decodeString())).toOption())));
            }

            public static final /* synthetic */ Object $anonfun$getEntityVks$7(anon.1 $this, Statement stmnt$12, String contract$7, int x) {
                return implicits$.MODULE$.toFlatMapOps(Sync$.MODULE$.apply($this.evidence$1$1).blocking((Function0 & Serializable)() -> stmnt$12.executeQuery(new StringBuilder(52).append("SELECT y_contract FROM contracts WHERE contract = '").append(contract$7).append("'").toString())), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)rs -> implicits$.MODULE$.toFlatMapOps(Sync$.MODULE$.apply($this.evidence$1$1).delay((Function0)(JFunction0.mcI.sp & Serializable)() -> rs.getInt("y_contract")), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)y -> anon.1.$anonfun$getEntityVks$11($this, stmnt$12, x, BoxesRunTime.unboxToInt((Object)y))));
            }

            public static final /* synthetic */ Tuple2 $anonfun$addNewLockTemplate$7(anon.1 $this, String contract$8, LockTemplate lockTemplate$1, int y) {
                String statement = new StringBuilder(67).append("INSERT INTO contracts (contract, y_contract, lock) VALUES ('").append(contract$8).append("', ").append(y + 1).append(", '").append(LockTemplateCodecs$.MODULE$.encodeLockTemplate(lockTemplate$1, (Monad)$this.evidence$1$1).toString()).append("'").toString();
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)y), (Object)statement);
            }
            {
                this.connection$1 = connection$1;
                this.evidence$1$1 = evidence$1$1;
                this.transactionBuilderApi$1 = transactionBuilderApi$1;
                this.walletApi$1 = walletApi$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$addEntityVks$1(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.lang.String java.lang.String scala.collection.immutable.List java.sql.Connection ), $anonfun$addEntityVks$10(java.sql.ResultSet ), $anonfun$addEntityVks$11$adapted(int scala.collection.immutable.List java.lang.Object ), $anonfun$addEntityVks$12(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.sql.Statement scala.Tuple2 ), $anonfun$addEntityVks$13(java.sql.Statement java.lang.String ), $anonfun$addEntityVks$14(int ), $anonfun$addEntityVks$2(java.sql.Connection ), $anonfun$addEntityVks$3(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.lang.String java.lang.String scala.collection.immutable.List java.sql.Statement ), $anonfun$addEntityVks$4(java.sql.Statement java.lang.String ), $anonfun$addEntityVks$5(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.sql.Statement java.lang.String scala.collection.immutable.List java.sql.ResultSet ), $anonfun$addEntityVks$6(java.sql.ResultSet ), $anonfun$addEntityVks$7$adapted(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.sql.Statement java.lang.String scala.collection.immutable.List java.lang.Object ), $anonfun$addEntityVks$8(java.sql.Statement java.lang.String ), $anonfun$addEntityVks$9(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 int scala.collection.immutable.List java.sql.Statement java.sql.ResultSet ), $anonfun$addNewLockTemplate$1(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.lang.String co.topl.brambl.builders.locks.LockTemplate java.sql.Connection ), $anonfun$addNewLockTemplate$10(int ), $anonfun$addNewLockTemplate$2(java.sql.Connection ), $anonfun$addNewLockTemplate$3(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.lang.String co.topl.brambl.builders.locks.LockTemplate java.sql.Statement ), $anonfun$addNewLockTemplate$4(java.sql.Statement ), $anonfun$addNewLockTemplate$5(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.lang.String co.topl.brambl.builders.locks.LockTemplate java.sql.Statement java.sql.ResultSet ), $anonfun$addNewLockTemplate$6(java.sql.ResultSet ), $anonfun$addNewLockTemplate$7$adapted(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.lang.String co.topl.brambl.builders.locks.LockTemplate java.lang.Object ), $anonfun$addNewLockTemplate$8(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.sql.Statement scala.Tuple2 ), $anonfun$addNewLockTemplate$9(java.sql.Statement java.lang.String ), $anonfun$getAddress$1(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.lang.String java.lang.String scala.Option java.sql.Connection ), $anonfun$getAddress$10(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 scala.Option int java.sql.Statement java.sql.ResultSet ), $anonfun$getAddress$11(java.sql.ResultSet ), $anonfun$getAddress$12$adapted(scala.Option int java.lang.Object ), $anonfun$getAddress$13$adapted(java.lang.Object ), $anonfun$getAddress$14(), $anonfun$getAddress$15$adapted(java.lang.Object ), $anonfun$getAddress$16(), $anonfun$getAddress$17(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.sql.Statement scala.Tuple2 ), $anonfun$getAddress$18(java.sql.Statement java.lang.String ), $anonfun$getAddress$19(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.sql.ResultSet ), $anonfun$getAddress$2(java.sql.Connection ), $anonfun$getAddress$20(java.sql.ResultSet ), $anonfun$getAddress$21(java.sql.ResultSet java.lang.String ), $anonfun$getAddress$3(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.lang.String java.lang.String scala.Option java.sql.Statement ), $anonfun$getAddress$4(java.sql.Statement java.lang.String ), $anonfun$getAddress$5(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.lang.String java.sql.Statement scala.Option java.sql.ResultSet ), $anonfun$getAddress$6(java.sql.ResultSet ), $anonfun$getAddress$7$adapted(java.lang.String java.lang.Object ), $anonfun$getAddress$8(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.sql.Statement scala.Option scala.Tuple2 ), $anonfun$getAddress$9(java.sql.Statement java.lang.String ), $anonfun$getCurrentAddress$1(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.sql.Connection ), $anonfun$getCurrentAddress$2(java.sql.Connection ), $anonfun$getCurrentAddress$3(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.sql.Statement ), $anonfun$getCurrentAddress$4(java.sql.Statement ), $anonfun$getCurrentAddress$5(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.sql.ResultSet ), $anonfun$getCurrentAddress$6(java.sql.ResultSet ), $anonfun$getCurrentAddress$7(java.lang.String ), $anonfun$getCurrentIndicesForFunds$1(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.lang.String java.lang.String scala.Option java.sql.Connection ), $anonfun$getCurrentIndicesForFunds$10(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.sql.Statement scala.Option int java.sql.ResultSet ), $anonfun$getCurrentIndicesForFunds$11(java.sql.ResultSet ), $anonfun$getCurrentIndicesForFunds$12$adapted(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.sql.Statement scala.Option int java.lang.Object ), $anonfun$getCurrentIndicesForFunds$13(java.sql.Statement scala.Option int int ), $anonfun$getCurrentIndicesForFunds$14$adapted(java.lang.Object ), $anonfun$getCurrentIndicesForFunds$15(), $anonfun$getCurrentIndicesForFunds$16$adapted(java.lang.Object ), $anonfun$getCurrentIndicesForFunds$17(), $anonfun$getCurrentIndicesForFunds$18(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 scala.Option int int java.sql.ResultSet ), $anonfun$getCurrentIndicesForFunds$19$adapted(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.lang.Object ), $anonfun$getCurrentIndicesForFunds$2(java.sql.Connection ), $anonfun$getCurrentIndicesForFunds$20(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.sql.ResultSet ), $anonfun$getCurrentIndicesForFunds$21(java.sql.ResultSet ), $anonfun$getCurrentIndicesForFunds$22$adapted(java.sql.ResultSet int int java.lang.Object ), $anonfun$getCurrentIndicesForFunds$3(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.lang.String java.lang.String scala.Option java.sql.Statement ), $anonfun$getCurrentIndicesForFunds$4(java.sql.Statement java.lang.String ), $anonfun$getCurrentIndicesForFunds$5(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.lang.String java.sql.Statement scala.Option java.sql.ResultSet ), $anonfun$getCurrentIndicesForFunds$6(java.sql.ResultSet ), $anonfun$getCurrentIndicesForFunds$7$adapted(java.lang.String java.lang.Object ), $anonfun$getCurrentIndicesForFunds$8(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.sql.Statement scala.Option scala.Tuple2 ), $anonfun$getCurrentIndicesForFunds$9(java.sql.Statement java.lang.String ), $anonfun$getEntityVks$1(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.lang.String java.lang.String java.sql.Connection ), $anonfun$getEntityVks$10(java.sql.ResultSet ), $anonfun$getEntityVks$11$adapted(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.sql.Statement int java.lang.Object ), $anonfun$getEntityVks$12(java.sql.Statement int int ), $anonfun$getEntityVks$13(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.sql.ResultSet ), $anonfun$getEntityVks$14(java.sql.ResultSet ), $anonfun$getEntityVks$15(java.sql.ResultSet java.lang.String ), $anonfun$getEntityVks$16(io.circe.Json ), $anonfun$getEntityVks$2(java.sql.Connection ), $anonfun$getEntityVks$3(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.lang.String java.lang.String java.sql.Statement ), $anonfun$getEntityVks$4(java.sql.Statement java.lang.String ), $anonfun$getEntityVks$5(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.sql.Statement java.lang.String java.sql.ResultSet ), $anonfun$getEntityVks$6(java.sql.ResultSet ), $anonfun$getEntityVks$7$adapted(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.sql.Statement java.lang.String java.lang.Object ), $anonfun$getEntityVks$8(java.sql.Statement java.lang.String ), $anonfun$getEntityVks$9(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.sql.Statement int java.sql.ResultSet ), $anonfun$getIndicesBySignature$1(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 quivr.models.Proposition$DigitalSignature java.sql.Connection ), $anonfun$getIndicesBySignature$10(java.sql.ResultSet ), $anonfun$getIndicesBySignature$11$adapted(java.sql.ResultSet int int java.lang.Object ), $anonfun$getIndicesBySignature$2(java.sql.Connection ), $anonfun$getIndicesBySignature$3(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 quivr.models.Proposition$DigitalSignature java.sql.Statement ), $anonfun$getIndicesBySignature$4(java.sql.Statement quivr.models.Proposition$DigitalSignature ), $anonfun$getIndicesBySignature$5(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.sql.ResultSet ), $anonfun$getIndicesBySignature$6(java.sql.ResultSet ), $anonfun$getIndicesBySignature$7$adapted(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.sql.ResultSet java.lang.Object ), $anonfun$getIndicesBySignature$8(java.sql.ResultSet ), $anonfun$getIndicesBySignature$9$adapted(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.sql.ResultSet int java.lang.Object ), $anonfun$getLock$1(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.lang.String java.lang.String int scala.Option ), $anonfun$getLock$10(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 co.topl.brambl.builders.locks.LockTemplate scala.collection.immutable.List ), $anonfun$getLock$11(scala.util.Either ), $anonfun$getLock$12(scala.Option ), $anonfun$getLock$13(scala.Option ), $anonfun$getLock$2(scala.Option ), $anonfun$getLock$3(scala.collection.immutable.List ), $anonfun$getLock$4(java.lang.String ), $anonfun$getLock$5(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 int scala.Option scala.Option ), $anonfun$getLock$6(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 int scala.collection.immutable.List ), $anonfun$getLock$7(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 int quivr.models.VerificationKey ), $anonfun$getLock$8(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 scala.Option scala.Option ), $anonfun$getLock$9(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 scala.Option co.topl.brambl.builders.locks.LockTemplate ), $anonfun$getLockByIndex$1(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 co.topl.brambl.models.Indices java.sql.Connection ), $anonfun$getLockByIndex$2(java.sql.Connection ), $anonfun$getLockByIndex$3(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 co.topl.brambl.models.Indices java.sql.Statement ), $anonfun$getLockByIndex$4(java.sql.Statement co.topl.brambl.models.Indices ), $anonfun$getLockByIndex$5(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.sql.ResultSet ), $anonfun$getLockByIndex$6(java.sql.ResultSet ), $anonfun$getLockByIndex$7$adapted(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.sql.ResultSet java.lang.Object ), $anonfun$getLockByIndex$8(java.sql.ResultSet ), $anonfun$getLockByIndex$9(java.lang.String ), $anonfun$getLockTemplate$1(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.lang.String java.sql.Connection ), $anonfun$getLockTemplate$2(java.sql.Connection ), $anonfun$getLockTemplate$3(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.lang.String java.sql.Statement ), $anonfun$getLockTemplate$4(java.sql.Statement java.lang.String ), $anonfun$getLockTemplate$5(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.sql.ResultSet ), $anonfun$getLockTemplate$6(java.sql.ResultSet ), $anonfun$getLockTemplate$7(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.sql.ResultSet java.lang.String ), $anonfun$getLockTemplate$8(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 io.circe.Json ), $anonfun$getNextIndicesForFunds$1(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.lang.String java.lang.String java.sql.Connection ), $anonfun$getNextIndicesForFunds$10(java.sql.ResultSet ), $anonfun$getNextIndicesForFunds$11$adapted(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.sql.Statement int java.lang.Object ), $anonfun$getNextIndicesForFunds$12(java.sql.Statement int int ), $anonfun$getNextIndicesForFunds$13(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 int int java.sql.ResultSet ), $anonfun$getNextIndicesForFunds$14(java.sql.ResultSet ), $anonfun$getNextIndicesForFunds$15$adapted(java.sql.ResultSet int int java.lang.Object ), $anonfun$getNextIndicesForFunds$2(java.sql.Connection ), $anonfun$getNextIndicesForFunds$3(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.lang.String java.lang.String java.sql.Statement ), $anonfun$getNextIndicesForFunds$4(java.sql.Statement java.lang.String ), $anonfun$getNextIndicesForFunds$5(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.sql.Statement java.lang.String java.sql.ResultSet ), $anonfun$getNextIndicesForFunds$6(java.sql.ResultSet ), $anonfun$getNextIndicesForFunds$7$adapted(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.sql.Statement java.lang.String java.lang.Object ), $anonfun$getNextIndicesForFunds$8(java.sql.Statement java.lang.String ), $anonfun$getNextIndicesForFunds$9(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.sql.Statement int java.sql.ResultSet ), $anonfun$getPreimage$1(), $anonfun$initWalletState$1(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 quivr.models.VerificationKey java.sql.Connection ), $anonfun$initWalletState$10(java.sql.Statement ), $anonfun$initWalletState$11$adapted(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.sql.Statement quivr.models.VerificationKey java.lang.Object ), $anonfun$initWalletState$12(java.sql.Statement ), $anonfun$initWalletState$13$adapted(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.sql.Statement quivr.models.VerificationKey java.lang.Object ), $anonfun$initWalletState$14(java.sql.Statement ), $anonfun$initWalletState$15$adapted(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.sql.Statement quivr.models.VerificationKey java.lang.Object ), $anonfun$initWalletState$16(java.sql.Statement ), $anonfun$initWalletState$17$adapted(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.sql.Statement quivr.models.VerificationKey java.lang.Object ), $anonfun$initWalletState$18(java.sql.Statement ), $anonfun$initWalletState$19$adapted(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.sql.Statement quivr.models.VerificationKey java.lang.Object ), $anonfun$initWalletState$2(java.sql.Connection ), $anonfun$initWalletState$20(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 ), $anonfun$initWalletState$21(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.sql.Statement quivr.models.VerificationKey co.topl.brambl.builders.locks.LockTemplate$PredicateTemplate ), $anonfun$initWalletState$22(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 ), $anonfun$initWalletState$23(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.sql.Statement co.topl.brambl.builders.locks.LockTemplate$PredicateTemplate quivr.models.VerificationKey co.topl.brambl.builders.locks.LockTemplate$PredicateTemplate ), $anonfun$initWalletState$24(java.sql.Statement ), $anonfun$initWalletState$25$adapted(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.sql.Statement co.topl.brambl.builders.locks.LockTemplate$PredicateTemplate co.topl.brambl.builders.locks.LockTemplate$PredicateTemplate quivr.models.VerificationKey java.lang.Object ), $anonfun$initWalletState$26(java.sql.Statement ), $anonfun$initWalletState$27$adapted(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.sql.Statement co.topl.brambl.builders.locks.LockTemplate$PredicateTemplate co.topl.brambl.builders.locks.LockTemplate$PredicateTemplate quivr.models.VerificationKey java.lang.Object ), $anonfun$initWalletState$28(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.sql.Statement co.topl.brambl.builders.locks.LockTemplate$PredicateTemplate ), $anonfun$initWalletState$29$adapted(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.sql.Statement co.topl.brambl.builders.locks.LockTemplate$PredicateTemplate quivr.models.VerificationKey java.lang.Object ), $anonfun$initWalletState$3(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 quivr.models.VerificationKey java.sql.Statement ), $anonfun$initWalletState$30(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.sql.Statement co.topl.brambl.builders.locks.LockTemplate$PredicateTemplate ), $anonfun$initWalletState$31$adapted(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.sql.Statement quivr.models.VerificationKey java.lang.Object ), $anonfun$initWalletState$32(java.sql.Statement quivr.models.VerificationKey ), $anonfun$initWalletState$33$adapted(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.sql.Statement quivr.models.VerificationKey java.lang.Object ), $anonfun$initWalletState$34(java.sql.Statement ), $anonfun$initWalletState$35$adapted(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 quivr.models.VerificationKey java.sql.Statement java.lang.Object ), $anonfun$initWalletState$36(scala.Option ), $anonfun$initWalletState$37(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 quivr.models.VerificationKey java.sql.Statement co.topl.brambl.models.box.Lock ), $anonfun$initWalletState$38(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 quivr.models.VerificationKey java.sql.Statement co.topl.brambl.models.box.Lock co.topl.brambl.models.LockAddress ), $anonfun$initWalletState$39(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.sql.Statement co.topl.brambl.models.box.Lock co.topl.brambl.models.LockAddress quivr.models.VerificationKey ), $anonfun$initWalletState$4(java.sql.Statement ), $anonfun$initWalletState$40(scala.Option ), $anonfun$initWalletState$41(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.sql.Statement co.topl.brambl.models.box.Lock co.topl.brambl.models.LockAddress quivr.models.VerificationKey co.topl.brambl.models.box.Lock ), $anonfun$initWalletState$42(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.sql.Statement co.topl.brambl.models.box.Lock co.topl.brambl.models.LockAddress quivr.models.VerificationKey co.topl.brambl.models.box.Lock co.topl.brambl.models.LockAddress ), $anonfun$initWalletState$43(java.sql.Statement co.topl.brambl.models.box.Lock co.topl.brambl.models.LockAddress quivr.models.VerificationKey ), $anonfun$initWalletState$44$adapted(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.sql.Statement co.topl.brambl.models.box.Lock co.topl.brambl.models.LockAddress java.lang.Object ), $anonfun$initWalletState$45(java.sql.Statement co.topl.brambl.models.box.Lock co.topl.brambl.models.LockAddress ), $anonfun$initWalletState$46$adapted(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.sql.Statement java.lang.Object ), $anonfun$initWalletState$47(java.sql.Statement ), $anonfun$initWalletState$48$adapted(scala.runtime.BoxedUnit ), $anonfun$initWalletState$5$adapted(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.sql.Statement quivr.models.VerificationKey java.lang.Object ), $anonfun$initWalletState$6(java.sql.Statement ), $anonfun$initWalletState$7$adapted(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.sql.Statement quivr.models.VerificationKey java.lang.Object ), $anonfun$initWalletState$8(java.sql.Statement ), $anonfun$initWalletState$9$adapted(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.sql.Statement quivr.models.VerificationKey java.lang.Object ), $anonfun$updateWalletState$1(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 co.topl.brambl.models.Indices java.lang.String java.lang.String scala.Option scala.Option java.sql.Connection ), $anonfun$updateWalletState$10(int ), $anonfun$updateWalletState$2(java.sql.Connection ), $anonfun$updateWalletState$3(co.topl.brambl.models.Indices java.lang.String java.lang.String scala.Option scala.Option java.sql.Statement ), $anonfun$updateWalletState$4(java.lang.String ), $anonfun$updateWalletState$5(), $anonfun$updateWalletState$6(java.lang.String ), $anonfun$updateWalletState$7(), $anonfun$updateWalletState$8(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 scala.Tuple2 ), $anonfun$updateWalletState$9(java.sql.Statement java.lang.String ), $anonfun$validateContract$1(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.lang.String java.sql.Connection ), $anonfun$validateContract$2(java.sql.Connection ), $anonfun$validateContract$3(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.lang.String java.sql.Statement ), $anonfun$validateContract$4(java.sql.Statement java.lang.String ), $anonfun$validateContract$5(java.lang.String java.sql.ResultSet ), $anonfun$validateCurrentIndicesForFunds$1(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.lang.String java.lang.String scala.Option cats.data.Validated ), $anonfun$validateCurrentIndicesForFunds$2(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.lang.String java.lang.String scala.Option cats.data.Validated cats.data.Validated ), $anonfun$validateCurrentIndicesForFunds$3(cats.data.Validated cats.data.Validated scala.Option ), $anonfun$validateCurrentIndicesForFunds$4(), $anonfun$validateCurrentIndicesForFunds$5(java.lang.String java.lang.String co.topl.brambl.models.Indices ), $anonfun$validateParty$1(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.lang.String java.sql.Connection ), $anonfun$validateParty$2(java.sql.Connection ), $anonfun$validateParty$3(co.topl.brambl.cli.impl.WalletStateAlgebra$$anon$1 java.lang.String java.sql.Statement ), $anonfun$validateParty$4(java.sql.Statement java.lang.String ), $anonfun$validateParty$5(java.lang.String java.sql.ResultSet )}, serializedLambda);
            }
        };
    }

    private WalletStateAlgebra$() {
    }
}

