/*
 * Decompiled with CFR 0.152.
 */
package co.topl.brambl.cli.views;

import co.topl.brambl.codecs.AddressCodecs$;
import co.topl.brambl.models.Datum;
import co.topl.brambl.models.LockAddress;
import co.topl.brambl.models.TransactionId;
import co.topl.brambl.models.TransactionOutputAddress;
import co.topl.brambl.models.box.Value;
import co.topl.brambl.models.transaction.IoTransaction;
import co.topl.brambl.models.transaction.SpentTransactionOutput;
import co.topl.brambl.models.transaction.UnspentTransactionOutput;
import co.topl.brambl.utils.Encoding$;
import co.topl.consensus.models.BlockId;
import co.topl.genus.services.Txo;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.package$;

public final class BlockDisplayOps$ {
    public static final BlockDisplayOps$ MODULE$ = new BlockDisplayOps$();

    public String display(BlockId blockId, Seq<IoTransaction> ioTransactions) {
        return new StringBuilder(25).append("\nBlockId: ").append(this.display(blockId)).append("\n\nBlock Body:\n").append(((IterableOnceOps)ioTransactions.map((Function1 & Serializable)transaction -> MODULE$.display((IoTransaction)transaction))).mkString("\n------------\n")).append("\n").toString();
    }

    public String display(BlockId blockId) {
        return Encoding$.MODULE$.encodeToBase58(blockId.value().toByteArray());
    }

    public String display(IoTransaction transaction) {
        return new StringBuilder(66).append("\nTransactionId: ").append(this.display((Option<TransactionId>)transaction.transactionId())).append("\n\nInputs       : ").append((Object)(transaction.inputs().isEmpty() ? "No inputs" : ((IterableOnceOps)transaction.inputs().map((Function1 & Serializable)stxo -> MODULE$.display((SpentTransactionOutput)stxo))).mkString("\n-----------\n"))).append("\nOutputs      :\n").append(((IterableOnceOps)transaction.outputs().map((Function1 & Serializable)stxo -> MODULE$.display((UnspentTransactionOutput)stxo))).mkString("\n-----------\n")).append("\nDatum        :\n").append(this.display(transaction.datum())).append("\n").toString();
    }

    public String display(Datum datum) {
        return new StringBuilder(15).append("\nValue      : ").append(this.display(datum.value())).append("\n").toString();
    }

    public String display(Datum.IoTransaction datumIoTransation) {
        return new StringBuilder(9).append("\nValue: ").append(Encoding$.MODULE$.encodeToBase58(datumIoTransation.event().metadata().value().toByteArray())).append("\n").toString();
    }

    public String display(Datum.Value datumValue) {
        return new StringBuilder(78).append("\nEon        : \n").append(datumValue.eon().map((Function1 & Serializable)x -> new StringBuilder(21).append("Begin Slot: ").append(x.event().beginSlot()).append(" Height: ").append(x.event().height()).toString()).getOrElse((Function0 & Serializable)() -> "No eon")).append("\nEpoch      : \n").append(datumValue.epoch().map((Function1 & Serializable)x -> new StringBuilder(21).append("Begin Slot: ").append(x.event().beginSlot()).append(" Height: ").append(x.event().height()).toString()).getOrElse((Function0 & Serializable)() -> "No eon")).append("\nEra        : \n").append(datumValue.era().map((Function1 & Serializable)x -> new StringBuilder(21).append("Begin Slot: ").append(x.event().beginSlot()).append(" Height: ").append(x.event().height()).toString()).getOrElse((Function0 & Serializable)() -> "No eon")).append("\nHeader     : \n").append(datumValue.header().map((Function1 & Serializable)x -> new StringBuilder(8).append("Height: ").append(x.event().height()).toString()).getOrElse((Function0 & Serializable)() -> "No eon")).append("\nMetadata     : \n").append(datumValue.ioTransaction().map((Function1 & Serializable)x -> new StringBuilder(7).append("Value: ").append(Encoding$.MODULE$.encodeToBase58(x.event().metadata().value().toByteArray())).toString()).getOrElse((Function0 & Serializable)() -> "No eon")).append("\n").toString();
    }

    public String display(SpentTransactionOutput stxo) {
        return new StringBuilder(64).append("\nTxoAddress   : ").append(this.display(stxo.address())).append("\nAttestation  : Not implemented\nValue        : ").append(this.display(stxo.value().value())).append("\n").toString();
    }

    public String display(UnspentTransactionOutput stxo) {
        return new StringBuilder(49).append("\nLockAddress  : ").append(this.display(stxo.address())).append("\nType         : ").append(this.displayType(stxo.value().value())).append("\nValue        : ").append(this.display(stxo.value().value())).append("\n").toString();
    }

    public String display(Txo txo) {
        return new StringBuilder(57).append("\nTxoAddress : ").append(this.display(txo.outputAddress())).append("\nLockAddress: ").append(this.display(txo.transactionOutput().address())).append("\nType       : ").append(this.displayType(txo.transactionOutput().value().value())).append("\nValue      : ").append(this.display(txo.transactionOutput().value().value())).append("\n").toString();
    }

    public String display(TransactionOutputAddress transactionOutputAddress) {
        return new StringBuilder(1).append(Encoding$.MODULE$.encodeToBase58(transactionOutputAddress.id().value().toByteArray())).append("#").append(transactionOutputAddress.index()).toString();
    }

    public String display(Option<TransactionId> transactionId) {
        return (String)transactionId.map((Function1 & Serializable)id -> Encoding$.MODULE$.encodeToBase58(id.value().toByteArray())).getOrElse((Function0 & Serializable)() -> "No transaction id");
    }

    public String display(LockAddress lockAddress) {
        return AddressCodecs$.MODULE$.encodeAddress(lockAddress);
    }

    public String displayType(Value.Value txoValue) {
        return txoValue.isLvl() ? "LVL" : (txoValue.isAsset() ? "Asset" : (txoValue.isTopl() ? "TOPL" : "Unknown txo type"));
    }

    public String display(Value.Value txoValue) {
        return txoValue.isLvl() ? package$.MODULE$.BigInt().apply(((Value.LVL)txoValue.lvl().get()).quantity().value().toByteArray()).toString() : (txoValue.isAsset() ? new StringBuilder(0).append(package$.MODULE$.BigInt().apply(((Value.Asset)txoValue.asset().get()).quantity().value().toByteArray()).toString()).append(((Value.Asset)txoValue.asset().get()).label()).toString() : (txoValue.isTopl() ? package$.MODULE$.BigInt().apply(((Value.TOPL)txoValue.topl().get()).quantity().value().toByteArray()).toString() : "Undefine type"));
    }

    private BlockDisplayOps$() {
    }
}

