package co.touchlab.kapture

/**
 * Mark a class or specific property as freezable. Kapture will ignore checks for this value and assume things are OK.
 * This annotation does not actually freeze the value, or ensure it is OK to be frozen.
 */
@Target(
    AnnotationTarget.PROPERTY,
    AnnotationTarget.CLASS,
    AnnotationTarget.LOCAL_VARIABLE,
    AnnotationTarget.VALUE_PARAMETER
)
@Retention(AnnotationRetention.BINARY)
public annotation class Freezeable

/**
 * Mark a function as one which will freeze it's lambda argument. This tells Kapture to check the contents of the lambda.
 */
@Target(AnnotationTarget.FUNCTION)
@Retention(AnnotationRetention.BINARY)
public annotation class FreezingBlockCall