(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'Kermit-kermit-core-js-legacy'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'Kermit-kermit-core-js-legacy'.");
    }
    root['Kermit-kermit-core-js-legacy'] = factory(typeof this['Kermit-kermit-core-js-legacy'] === 'undefined' ? {} : this['Kermit-kermit-core-js-legacy'], kotlin);
  }
}(this, function (_, Kotlin) {
  'use strict';
  var $$importsForInline$$ = _.$$importsForInline$$ || (_.$$importsForInline$$ = {});
  var IllegalStateException_init = Kotlin.kotlin.IllegalStateException_init_pdl1vj$;
  var defineInlineFunction = Kotlin.defineInlineFunction;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var println = Kotlin.kotlin.io.println_s8jyv4$;
  var printStackTrace = Kotlin.kotlin.printStackTrace_dbl4o4$;
  var Unit = Kotlin.kotlin.Unit;
  var Annotation = Kotlin.kotlin.Annotation;
  var Kind_INTERFACE = Kotlin.Kind.INTERFACE;
  var toList = Kotlin.kotlin.collections.toList_us0mfu$;
  var listOf = Kotlin.kotlin.collections.listOf_mh5how$;
  var StringBuilder_init = Kotlin.kotlin.text.StringBuilder_init;
  var Kind_OBJECT = Kotlin.Kind.OBJECT;
  var Enum = Kotlin.kotlin.Enum;
  var throwISE = Kotlin.throwISE;
  var stackTraceToString = Kotlin.kotlin.stackTraceToString_dbl4o4$;
  CommonWriter.prototype = Object.create(LogWriter.prototype);
  CommonWriter.prototype.constructor = CommonWriter;
  Severity.prototype = Object.create(Enum.prototype);
  Severity.prototype.constructor = Severity;
  ConsoleWriter.prototype = Object.create(LogWriter.prototype);
  ConsoleWriter.prototype.constructor = ConsoleWriter;
  function BaseLogger(config) {
    this.config_bavj4r$_0 = config;
  }
  Object.defineProperty(BaseLogger.prototype, 'config', {
    get: function () {
      return this.config_bavj4r$_0;
    }
  });
  Object.defineProperty(BaseLogger.prototype, 'mutableConfig', {
    configurable: true,
    get: function () {
      var it = this.config;
      if (!Kotlin.isType(it, MutableLoggerConfig)) {
        throw IllegalStateException_init('Logger config is not mutable');
      }
      return it;
    }
  });
  BaseLogger.prototype.logBlock_lb0tcp$ = defineInlineFunction('Kermit-kermit-core-js-legacy.co.touchlab.kermit.BaseLogger.logBlock_lb0tcp$', function (severity, tag, throwable, message) {
    if (this.config.minSeverity.compareTo_11rb$(severity) <= 0) {
      this.processLog_u3soen$(severity, tag, throwable, message());
    }
  });
  BaseLogger.prototype.log_u3soen$ = defineInlineFunction('Kermit-kermit-core-js-legacy.co.touchlab.kermit.BaseLogger.log_u3soen$', function (severity, tag, throwable, message) {
    if (this.config.minSeverity.compareTo_11rb$(severity) <= 0) {
      this.processLog_u3soen$(severity, tag, throwable, message);
    }
  });
  BaseLogger.prototype.processLog_u3soen$ = function (severity, tag, throwable, message) {
    var tmp$;
    tmp$ = this.config.logWriterList.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      if (element.isLoggable_ogbtr5$(tag, severity)) {
        element.log_hbb6rz$(severity, message, tag, throwable);
      }
    }
  };
  BaseLogger.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'BaseLogger',
    interfaces: []
  };
  var DEFAULT_MIN_SEVERITY;
  function CommonWriter(messageStringFormatter) {
    if (messageStringFormatter === void 0)
      messageStringFormatter = DefaultFormatter_getInstance();
    LogWriter.call(this);
    this.messageStringFormatter_ehmsh4$_0 = messageStringFormatter;
  }
  CommonWriter.prototype.log_hbb6rz$$default = function (severity, message, tag, throwable) {
    println(this.messageStringFormatter_ehmsh4$_0.formatMessage_7nnujc$(severity, new Tag(tag), new Message(message)));
    throwable != null ? (printStackTrace(throwable), Unit) : null;
  };
  CommonWriter.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CommonWriter',
    interfaces: [LogWriter]
  };
  function ExperimentalKermitApi() {
  }
  ExperimentalKermitApi.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ExperimentalKermitApi',
    interfaces: [Annotation]
  };
  function LogWriter() {
  }
  LogWriter.prototype.isLoggable_ogbtr5$ = function (tag, severity) {
    return true;
  };
  LogWriter.prototype.log_hbb6rz$ = function (severity, message, tag, throwable, callback$default) {
    if (throwable === void 0)
      throwable = null;
    callback$default ? callback$default(severity, message, tag, throwable) : this.log_hbb6rz$$default(severity, message, tag, throwable);
  };
  LogWriter.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'LogWriter',
    interfaces: []
  };
  function LoggerConfig() {
  }
  LoggerConfig.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'LoggerConfig',
    interfaces: []
  };
  function loggerConfigInit(logWriters, minSeverity) {
    if (minSeverity === void 0)
      minSeverity = DEFAULT_MIN_SEVERITY;
    return new StaticConfig(minSeverity, toList(logWriters));
  }
  function StaticConfig(minSeverity, logWriterList) {
    if (minSeverity === void 0)
      minSeverity = DEFAULT_MIN_SEVERITY;
    if (logWriterList === void 0)
      logWriterList = listOf(new CommonWriter());
    this.minSeverity_i0wz5z$_0 = minSeverity;
    this.logWriterList_jutvv7$_0 = logWriterList;
  }
  Object.defineProperty(StaticConfig.prototype, 'minSeverity', {
    get: function () {
      return this.minSeverity_i0wz5z$_0;
    }
  });
  Object.defineProperty(StaticConfig.prototype, 'logWriterList', {
    get: function () {
      return this.logWriterList_jutvv7$_0;
    }
  });
  StaticConfig.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'StaticConfig',
    interfaces: [LoggerConfig]
  };
  StaticConfig.prototype.component1 = function () {
    return this.minSeverity;
  };
  StaticConfig.prototype.component2 = function () {
    return this.logWriterList;
  };
  StaticConfig.prototype.copy_9wotj7$ = function (minSeverity, logWriterList) {
    return new StaticConfig(minSeverity === void 0 ? this.minSeverity : minSeverity, logWriterList === void 0 ? this.logWriterList : logWriterList);
  };
  StaticConfig.prototype.toString = function () {
    return 'StaticConfig(minSeverity=' + Kotlin.toString(this.minSeverity) + (', logWriterList=' + Kotlin.toString(this.logWriterList)) + ')';
  };
  StaticConfig.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.minSeverity) | 0;
    result = result * 31 + Kotlin.hashCode(this.logWriterList) | 0;
    return result;
  };
  StaticConfig.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.minSeverity, other.minSeverity) && Kotlin.equals(this.logWriterList, other.logWriterList)))));
  };
  function MessageStringFormatter() {
  }
  MessageStringFormatter.prototype.formatSeverity_7vw6fh$ = function (severity) {
    return severity.toString() + ':';
  };
  MessageStringFormatter.prototype.formatTag_sdpcza$ = function (tag) {
    return '(' + tag.tag_8be2vx$ + ')';
  };
  MessageStringFormatter.prototype.formatMessage_7nnujc$ = function (severity, tag, message) {
    if (severity == null && tag == null)
      return message.message_8be2vx$;
    var sb = StringBuilder_init();
    if (severity != null)
      sb.append_pdl1vj$(this.formatSeverity_7vw6fh$(severity)).append_pdl1vj$(' ');
    var tmp$ = tag != null;
    if (tmp$) {
      tmp$ = tag.tag_8be2vx$.length > 0;
    }
    if (tmp$)
      sb.append_pdl1vj$(this.formatTag_sdpcza$(tag)).append_pdl1vj$(' ');
    sb.append_pdl1vj$(message.message_8be2vx$);
    return sb.toString();
  };
  MessageStringFormatter.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'MessageStringFormatter',
    interfaces: []
  };
  function Tag(tag) {
    this.tag_8be2vx$ = tag;
  }
  Tag.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Tag',
    interfaces: []
  };
  Tag.prototype.unbox = function () {
    return this.tag_8be2vx$;
  };
  Tag.prototype.toString = function () {
    return 'Tag(tag=' + Kotlin.toString(this.tag_8be2vx$) + ')';
  };
  Tag.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.tag_8be2vx$) | 0;
    return result;
  };
  Tag.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.tag_8be2vx$, other.tag_8be2vx$))));
  };
  function Message(message) {
    this.message_8be2vx$ = message;
  }
  Message.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Message',
    interfaces: []
  };
  Message.prototype.unbox = function () {
    return this.message_8be2vx$;
  };
  Message.prototype.toString = function () {
    return 'Message(message=' + Kotlin.toString(this.message_8be2vx$) + ')';
  };
  Message.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.message_8be2vx$) | 0;
    return result;
  };
  Message.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.message_8be2vx$, other.message_8be2vx$))));
  };
  function DefaultFormatter() {
    DefaultFormatter_instance = this;
  }
  DefaultFormatter.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'DefaultFormatter',
    interfaces: [MessageStringFormatter]
  };
  var DefaultFormatter_instance = null;
  function DefaultFormatter_getInstance() {
    if (DefaultFormatter_instance === null) {
      new DefaultFormatter();
    }
    return DefaultFormatter_instance;
  }
  function NoTagFormatter() {
    NoTagFormatter_instance = this;
  }
  NoTagFormatter.prototype.formatTag_sdpcza$ = function (tag) {
    return '';
  };
  NoTagFormatter.prototype.formatMessage_7nnujc$ = function (severity, tag, message) {
    return MessageStringFormatter.prototype.formatMessage_7nnujc$.call(this, severity, null, message);
  };
  NoTagFormatter.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'NoTagFormatter',
    interfaces: [MessageStringFormatter]
  };
  var NoTagFormatter_instance = null;
  function NoTagFormatter_getInstance() {
    if (NoTagFormatter_instance === null) {
      new NoTagFormatter();
    }
    return NoTagFormatter_instance;
  }
  function SimpleFormatter() {
    SimpleFormatter_instance = this;
  }
  SimpleFormatter.prototype.formatTag_sdpcza$ = function (tag) {
    return '';
  };
  SimpleFormatter.prototype.formatMessage_7nnujc$ = function (severity, tag, message) {
    return message.message_8be2vx$;
  };
  SimpleFormatter.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'SimpleFormatter',
    interfaces: [MessageStringFormatter]
  };
  var SimpleFormatter_instance = null;
  function SimpleFormatter_getInstance() {
    if (SimpleFormatter_instance === null) {
      new SimpleFormatter();
    }
    return SimpleFormatter_instance;
  }
  function MutableLoggerConfig() {
  }
  MutableLoggerConfig.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'MutableLoggerConfig',
    interfaces: [LoggerConfig]
  };
  function mutableLoggerConfigInit(logWriters, minSeverity) {
    if (minSeverity === void 0)
      minSeverity = DEFAULT_MIN_SEVERITY;
    var $receiver = mutableLoggerConfigInit_0(toList(logWriters));
    $receiver.minSeverity = minSeverity;
    return $receiver;
  }
  function Severity(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function Severity_initFields() {
    Severity_initFields = function () {
    };
    Severity$Verbose_instance = new Severity('Verbose', 0);
    Severity$Debug_instance = new Severity('Debug', 1);
    Severity$Info_instance = new Severity('Info', 2);
    Severity$Warn_instance = new Severity('Warn', 3);
    Severity$Error_instance = new Severity('Error', 4);
    Severity$Assert_instance = new Severity('Assert', 5);
  }
  var Severity$Verbose_instance;
  function Severity$Verbose_getInstance() {
    Severity_initFields();
    return Severity$Verbose_instance;
  }
  var Severity$Debug_instance;
  function Severity$Debug_getInstance() {
    Severity_initFields();
    return Severity$Debug_instance;
  }
  var Severity$Info_instance;
  function Severity$Info_getInstance() {
    Severity_initFields();
    return Severity$Info_instance;
  }
  var Severity$Warn_instance;
  function Severity$Warn_getInstance() {
    Severity_initFields();
    return Severity$Warn_instance;
  }
  var Severity$Error_instance;
  function Severity$Error_getInstance() {
    Severity_initFields();
    return Severity$Error_instance;
  }
  var Severity$Assert_instance;
  function Severity$Assert_getInstance() {
    Severity_initFields();
    return Severity$Assert_instance;
  }
  Severity.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Severity',
    interfaces: [Enum]
  };
  function Severity$values() {
    return [Severity$Verbose_getInstance(), Severity$Debug_getInstance(), Severity$Info_getInstance(), Severity$Warn_getInstance(), Severity$Error_getInstance(), Severity$Assert_getInstance()];
  }
  Severity.values = Severity$values;
  function Severity$valueOf(name) {
    switch (name) {
      case 'Verbose':
        return Severity$Verbose_getInstance();
      case 'Debug':
        return Severity$Debug_getInstance();
      case 'Info':
        return Severity$Info_getInstance();
      case 'Warn':
        return Severity$Warn_getInstance();
      case 'Error':
        return Severity$Error_getInstance();
      case 'Assert':
        return Severity$Assert_getInstance();
      default:
        throwISE('No enum constant co.touchlab.kermit.Severity.' + name);
    }
  }
  Severity.valueOf_61zpoe$ = Severity$valueOf;
  function ConsoleWriter(messageStringFormatter, console) {
    LogWriter.call(this);
    this.messageStringFormatter_0 = messageStringFormatter;
    this.console_0 = console;
  }
  ConsoleWriter.prototype.log_hbb6rz$$default = function (severity, message, tag, throwable) {
    var output = {v: this.messageStringFormatter_0.formatMessage_7nnujc$(null, new Tag(tag), new Message(message))};
    if (throwable != null) {
      output.v += ' ' + stackTraceToString(throwable);
    }
    switch (severity.name) {
      case 'Assert':
      case 'Error':
        this.console_0.error_yhszz7$([output.v]);
        break;
      case 'Warn':
        this.console_0.warn_yhszz7$([output.v]);
        break;
      case 'Info':
        this.console_0.info_yhszz7$([output.v]);
        break;
      case 'Debug':
      case 'Verbose':
        this.console_0.log_yhszz7$([output.v]);
        break;
    }
  };
  ConsoleWriter.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ConsoleWriter',
    interfaces: [LogWriter]
  };
  function ConsoleWriter_init(messageStringFormatter, $this) {
    if (messageStringFormatter === void 0)
      messageStringFormatter = DefaultFormatter_getInstance();
    $this = $this || Object.create(ConsoleWriter.prototype);
    ConsoleWriter.call($this, messageStringFormatter, ConsoleActual_getInstance());
    return $this;
  }
  function ConsoleIntf() {
  }
  ConsoleIntf.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'ConsoleIntf',
    interfaces: []
  };
  function ConsoleActual() {
    ConsoleActual_instance = this;
  }
  ConsoleActual.prototype.error_yhszz7$ = function (o) {
    var tmp$;
    (tmp$ = console).error.apply(tmp$, o);
  };
  ConsoleActual.prototype.warn_yhszz7$ = function (o) {
    var tmp$;
    (tmp$ = console).warn.apply(tmp$, o);
  };
  ConsoleActual.prototype.info_yhszz7$ = function (o) {
    var tmp$;
    (tmp$ = console).info.apply(tmp$, o);
  };
  ConsoleActual.prototype.log_yhszz7$ = function (o) {
    var tmp$;
    (tmp$ = console).log.apply(tmp$, o);
  };
  ConsoleActual.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'ConsoleActual',
    interfaces: [ConsoleIntf]
  };
  var ConsoleActual_instance = null;
  function ConsoleActual_getInstance() {
    if (ConsoleActual_instance === null) {
      new ConsoleActual();
    }
    return ConsoleActual_instance;
  }
  function JsMutableLoggerConfig(logWriters) {
    this.minSeverity_q9jskm$_0 = DEFAULT_MIN_SEVERITY;
    this.logWriterList_e6r0ng$_0 = logWriters;
  }
  Object.defineProperty(JsMutableLoggerConfig.prototype, 'minSeverity', {
    configurable: true,
    get: function () {
      return this.minSeverity_q9jskm$_0;
    },
    set: function (minSeverity) {
      this.minSeverity_q9jskm$_0 = minSeverity;
    }
  });
  Object.defineProperty(JsMutableLoggerConfig.prototype, 'logWriterList', {
    configurable: true,
    get: function () {
      return this.logWriterList_e6r0ng$_0;
    },
    set: function (logWriterList) {
      this.logWriterList_e6r0ng$_0 = logWriterList;
    }
  });
  JsMutableLoggerConfig.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'JsMutableLoggerConfig',
    interfaces: [MutableLoggerConfig]
  };
  function mutableLoggerConfigInit_0(logWriters) {
    return new JsMutableLoggerConfig(logWriters);
  }
  function platformLogWriter(messageStringFormatter) {
    if (messageStringFormatter === void 0)
      messageStringFormatter = DefaultFormatter_getInstance();
    return ConsoleWriter_init();
  }
  $$importsForInline$$['Kermit-kermit-core-js-legacy'] = _;
  var package$co = _.co || (_.co = {});
  var package$touchlab = package$co.touchlab || (package$co.touchlab = {});
  var package$kermit = package$touchlab.kermit || (package$touchlab.kermit = {});
  package$kermit.BaseLogger = BaseLogger;
  Object.defineProperty(package$kermit, 'DEFAULT_MIN_SEVERITY_8be2vx$', {
    get: function () {
      return DEFAULT_MIN_SEVERITY;
    }
  });
  package$kermit.CommonWriter = CommonWriter;
  package$kermit.ExperimentalKermitApi = ExperimentalKermitApi;
  package$kermit.LogWriter = LogWriter;
  package$kermit.LoggerConfig = LoggerConfig;
  package$kermit.loggerConfigInit_kf1w37$ = loggerConfigInit;
  package$kermit.StaticConfig = StaticConfig;
  package$kermit.MessageStringFormatter = MessageStringFormatter;
  package$kermit.Tag = Tag;
  package$kermit.Message = Message;
  Object.defineProperty(package$kermit, 'DefaultFormatter', {
    get: DefaultFormatter_getInstance
  });
  Object.defineProperty(package$kermit, 'NoTagFormatter', {
    get: NoTagFormatter_getInstance
  });
  Object.defineProperty(package$kermit, 'SimpleFormatter', {
    get: SimpleFormatter_getInstance
  });
  package$kermit.MutableLoggerConfig = MutableLoggerConfig;
  package$kermit.mutableLoggerConfigInit_kf1w37$ = mutableLoggerConfigInit;
  Object.defineProperty(Severity, 'Verbose', {
    get: Severity$Verbose_getInstance
  });
  Object.defineProperty(Severity, 'Debug', {
    get: Severity$Debug_getInstance
  });
  Object.defineProperty(Severity, 'Info', {
    get: Severity$Info_getInstance
  });
  Object.defineProperty(Severity, 'Warn', {
    get: Severity$Warn_getInstance
  });
  Object.defineProperty(Severity, 'Error', {
    get: Severity$Error_getInstance
  });
  Object.defineProperty(Severity, 'Assert', {
    get: Severity$Assert_getInstance
  });
  package$kermit.Severity = Severity;
  package$kermit.ConsoleWriter_init_tvdhvi$ = ConsoleWriter_init;
  package$kermit.ConsoleWriter = ConsoleWriter;
  package$kermit.ConsoleIntf = ConsoleIntf;
  package$kermit.JsMutableLoggerConfig = JsMutableLoggerConfig;
  package$kermit.mutableLoggerConfigInit_c3jlhg$ = mutableLoggerConfigInit_0;
  package$kermit.platformLogWriter_tvdhvi$ = platformLogWriter;
  DefaultFormatter.prototype.formatSeverity_7vw6fh$ = MessageStringFormatter.prototype.formatSeverity_7vw6fh$;
  DefaultFormatter.prototype.formatTag_sdpcza$ = MessageStringFormatter.prototype.formatTag_sdpcza$;
  DefaultFormatter.prototype.formatMessage_7nnujc$ = MessageStringFormatter.prototype.formatMessage_7nnujc$;
  NoTagFormatter.prototype.formatSeverity_7vw6fh$ = MessageStringFormatter.prototype.formatSeverity_7vw6fh$;
  SimpleFormatter.prototype.formatSeverity_7vw6fh$ = MessageStringFormatter.prototype.formatSeverity_7vw6fh$;
  DEFAULT_MIN_SEVERITY = Severity$Verbose_getInstance();
  Kotlin.defineModule('Kermit-kermit-core-js-legacy', _);
  return _;
}));

//# sourceMappingURL=Kermit-kermit-core-js-legacy.js.map
