/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.flow.javascript;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NotAFunctionException;
import org.mozilla.javascript.PropertyException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class ScriptableResult
extends ScriptableObject {
    public String getClassName() {
        return "Result";
    }

    public ScriptableResult() {
    }

    ScriptableResult(Scriptable scope, ResultSet rs, int startRow, int maxRows) throws SQLException, PropertyException, NotAFunctionException, JavaScriptException {
        Context cx = Context.getCurrentContext();
        Scriptable rowMap = cx.newObject(scope, "Array");
        this.put("rows", (Scriptable)this, rowMap);
        Scriptable rowByIndex = cx.newObject(scope, "Array");
        this.put("rowsByIndex", (Scriptable)this, rowByIndex);
        ResultSetMetaData rsmd = rs.getMetaData();
        int noOfColumns = rsmd.getColumnCount();
        Scriptable columnNames = cx.newObject(scope, "Array", new Object[]{new Integer(noOfColumns)});
        this.put("columnNames", (Scriptable)this, columnNames);
        int i = 1;
        while (i <= noOfColumns) {
            columnNames.put(i - 1, columnNames, (Object)rsmd.getColumnName(i));
            ++i;
        }
        int i2 = 0;
        while (i2 < startRow) {
            rs.next();
            ++i2;
        }
        int processedRows = 0;
        int index = 0;
        boolean isLimited = false;
        while (rs.next()) {
            if (maxRows != -1 && processedRows == maxRows) {
                isLimited = true;
                break;
            }
            Scriptable columns = cx.newObject(scope, "Array", new Object[]{new Integer(noOfColumns)});
            Row columnMap = new Row();
            columnMap.setParentScope(columns.getParentScope());
            columnMap.setPrototype(ScriptableObject.getObjectPrototype((Scriptable)scope));
            int i3 = 1;
            while (i3 <= noOfColumns) {
                Object value = rs.getObject(i3);
                if (rs.wasNull()) {
                    value = null;
                }
                columns.put(i3 - 1, columns, value);
                columnMap.put(rsmd.getColumnName(i3), (Scriptable)columnMap, value);
                ++i3;
            }
            rowMap.put(index, rowMap, (Object)columnMap);
            rowByIndex.put(index, rowByIndex, (Object)columns);
            ++processedRows;
            ++index;
        }
        this.put("rowCount", (Scriptable)this, new Integer(index));
        this.put("isLimitedByMaxRows", (Scriptable)this, new Boolean(isLimited));
    }

    public static class Row
    extends ScriptableObject {
        public String getClassName() {
            return "Row";
        }

        public Object get(String name, Scriptable start) {
            return super.get(name.toUpperCase(), start);
        }

        public void put(String name, Scriptable start, Object value) {
            super.put(name.toUpperCase(), start, value);
        }
    }
}

