/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.generation;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.util.RequestForwardingHttpMethod;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.HttpURL;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.excalibur.xml.sax.SAXParser;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class GenericProxyGenerator
extends ServiceableGenerator {
    HttpURL destination;
    HttpServletRequest request;
    HttpServletResponse response;
    String path;
    SAXParser parser;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this.parser = (SAXParser)manager.lookup(SAXParser.ROLE);
    }

    public void dispose() {
        if (this.manager != null) {
            this.manager.release((Object)this.parser);
            this.parser = null;
        }
        super.dispose();
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        String url = par.getParameter("url", null);
        this.request = (HttpServletRequest)objectModel.get("httprequest");
        this.response = (HttpServletResponse)objectModel.get("httpresponse");
        if (url == null) {
            throw new ProcessingException("Missing the \"url\" parameter");
        }
        this.path = par.getParameter("path", null);
        if (this.path == null) {
            this.path = this.request.getRequestURI();
        }
        this.destination = new HttpURL(url);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        RequestForwardingHttpMethod method = new RequestForwardingHttpMethod(this.request, this.destination);
        HttpConnection conn = new HttpConnection(this.destination.getHost(), this.destination.getPort());
        HttpState state = new HttpState();
        state.setCredentials(null, this.destination.getHost(), (Credentials)new UsernamePasswordCredentials(this.destination.getUser(), this.destination.getPassword()));
        method.setPath(this.path);
        method.execute(state, conn);
        this.response.setStatus(method.getStatusCode());
        Header[] methodHeaders = method.getResponseHeaders();
        for (int i = 0; i < methodHeaders.length; ++i) {
            if (methodHeaders[i].getName().equals("DAV")) {
                this.response.addHeader(methodHeaders[i].getName(), methodHeaders[i].getValue());
                continue;
            }
            if (methodHeaders[i].getName().equals("Content-Length")) continue;
            this.response.setHeader(methodHeaders[i].getName(), methodHeaders[i].getValue());
        }
        this.response.setHeader("Connection", "close");
        if (method.getResponseHeader("Content-Type").getValue().startsWith("text/xml")) {
            InputStream stream = method.getResponseBodyAsStream();
            this.parser.parse(new InputSource(stream), this.contentHandler, this.lexicalHandler);
        } else {
            this.contentHandler.startDocument();
            this.contentHandler.startElement("", "no-xml-content", "no-xml-content", new AttributesImpl());
            this.contentHandler.endElement("", "no-xml-content", "no-xml-content");
            this.contentHandler.endDocument();
        }
        conn.close();
    }
}

