/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpURL;
import org.apache.commons.httpclient.cookie.CookieSpecBase;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;

public class RequestForwardingHttpMethod
extends EntityEnclosingMethod {
    HttpServletRequest originalRequest;
    HttpURL destination;

    public RequestForwardingHttpMethod(HttpServletRequest req, HttpURL destination) throws IOException {
        this.originalRequest = req;
        this.destination = destination;
        this.setFollowRedirects(true);
        this.setPath(req.getRequestURI());
        this.cloneHeaders();
        this.cloneCookies();
        this.setRequestBody((InputStream)this.originalRequest.getInputStream());
    }

    public String getName() {
        return this.originalRequest.getMethod();
    }

    private void cloneHeaders() {
        Enumeration e = this.originalRequest.getHeaderNames();
        while (e.hasMoreElements()) {
            String header = (String)e.nextElement();
            String headerValue = this.originalRequest.getHeader(header);
            this.addRequestHeader(header, headerValue);
        }
    }

    private void cloneCookies() {
        ArrayList<Cookie> newCookiesList = new ArrayList<Cookie>();
        javax.servlet.http.Cookie[] cookies = this.originalRequest.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                String domain = cookies[i].getDomain();
                String name = cookies[i].getName();
                String path = cookies[i].getPath();
                String value = cookies[i].getValue();
                Cookie cookie = new Cookie(domain, path, value);
                cookie.setName(name);
                newCookiesList.add(cookie);
            }
            CookieSpecBase cookieFormatter = new CookieSpecBase();
            Header cookieHeader = cookieFormatter.formatCookieHeader(newCookiesList.toArray(new Cookie[newCookiesList.size()]));
            this.addRequestHeader(cookieHeader);
        }
    }
}

