/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import junit.framework.Assert;
import org.apache.avalon.framework.context.DefaultContext;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceSelector;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.acting.Action;
import org.apache.cocoon.components.flow.AbstractInterpreter;
import org.apache.cocoon.components.flow.FlowHelper;
import org.apache.cocoon.components.flow.Interpreter;
import org.apache.cocoon.components.source.SourceResolverAdapter;
import org.apache.cocoon.core.container.ContainerTestCase;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.environment.mock.MockContext;
import org.apache.cocoon.environment.mock.MockRedirector;
import org.apache.cocoon.environment.mock.MockRequest;
import org.apache.cocoon.environment.mock.MockResponse;
import org.apache.cocoon.generation.Generator;
import org.apache.cocoon.matching.Matcher;
import org.apache.cocoon.selection.Selector;
import org.apache.cocoon.serialization.Serializer;
import org.apache.cocoon.sitemap.PatternException;
import org.apache.cocoon.transformation.Transformer;
import org.apache.cocoon.xml.WhitespaceFilter;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.cocoon.xml.dom.DOMBuilder;
import org.apache.cocoon.xml.dom.DOMStreamer;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.xml.sax.SAXParser;
import org.custommonkey.xmlunit.Diff;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public abstract class SitemapComponentTestCase
extends ContainerTestCase {
    public static final Parameters EMPTY_PARAMS = Parameters.EMPTY_PARAMETERS;
    private MockRequest request = new MockRequest();
    private MockResponse response = new MockResponse();
    private MockContext context = new MockContext();
    private MockRedirector redirector = new MockRedirector();
    private Map objectmodel = new HashMap();

    public final MockRequest getRequest() {
        return this.request;
    }

    public final MockResponse getResponse() {
        return this.response;
    }

    public final MockContext getContext() {
        return this.context;
    }

    public final MockRedirector getRedirector() {
        return this.redirector;
    }

    public final Map getObjectModel() {
        return this.objectmodel;
    }

    protected void addContext(DefaultContext context) {
        context.put((Object)"object-model.request", (Object)this.request);
        context.put((Object)"object-model.response", (Object)this.response);
        context.put((Object)"object-model", (Object)this.objectmodel);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.objectmodel.clear();
        this.request.reset();
        this.objectmodel.put("request", this.request);
        this.response.reset();
        this.objectmodel.put("response", this.response);
        this.context.reset();
        this.objectmodel.put("context", this.context);
        this.redirector.reset();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Map match(String type, String pattern, Parameters parameters) throws PatternException {
        Map result;
        org.apache.excalibur.source.SourceResolver resolver;
        ServiceSelector selector;
        block7: {
            selector = null;
            Matcher matcher = null;
            resolver = null;
            result = null;
            try {
                try {
                    selector = (ServiceSelector)this.lookup(Matcher.ROLE + "Selector");
                    Assert.assertNotNull((String)"Test lookup of matcher selector", (Object)selector);
                    resolver = (org.apache.excalibur.source.SourceResolver)this.lookup(org.apache.excalibur.source.SourceResolver.ROLE);
                    Assert.assertNotNull((String)"Test lookup of source resolver", (Object)resolver);
                    Assert.assertNotNull((String)"Test if matcher name is not null", (Object)type);
                    matcher = (Matcher)selector.select((Object)type);
                    Assert.assertNotNull((String)"Test lookup of matcher", (Object)matcher);
                    result = matcher.match(pattern, this.objectmodel, parameters);
                }
                catch (ServiceException ce) {
                    this.getLogger().error("Could not retrieve matcher", (Throwable)ce);
                    Assert.fail((String)("Could not retrieve matcher: " + ce.toString()));
                    Object var10_9 = null;
                    if (matcher != null) {
                        selector.release(matcher);
                    }
                    this.release(selector);
                    this.release(resolver);
                    return result;
                }
                Object var10_8 = null;
                if (matcher == null) break block7;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                if (matcher != null) {
                    selector.release(matcher);
                }
                this.release(selector);
                this.release(resolver);
                throw throwable;
            }
            selector.release((Object)matcher);
        }
        this.release(selector);
        this.release(resolver);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean select(String type, String expression, Parameters parameters) {
        boolean result;
        org.apache.excalibur.source.SourceResolver resolver;
        ServiceSelector selector;
        block7: {
            selector = null;
            Selector sel = null;
            resolver = null;
            result = false;
            try {
                try {
                    selector = (ServiceSelector)this.lookup(Selector.ROLE + "Selector");
                    Assert.assertNotNull((String)"Test lookup of selector selector", (Object)selector);
                    resolver = (org.apache.excalibur.source.SourceResolver)this.lookup(org.apache.excalibur.source.SourceResolver.ROLE);
                    Assert.assertNotNull((String)"Test lookup of source resolver", (Object)resolver);
                    Assert.assertNotNull((String)"Test if selector name is not null", (Object)type);
                    sel = (Selector)selector.select((Object)type);
                    Assert.assertNotNull((String)"Test lookup of selector", (Object)sel);
                    result = sel.select(expression, this.objectmodel, parameters);
                }
                catch (ServiceException ce) {
                    this.getLogger().error("Could not retrieve selector", (Throwable)ce);
                    Assert.fail((String)("Could not retrieve selector: " + ce.toString()));
                    Object var10_9 = null;
                    if (sel != null) {
                        selector.release(sel);
                    }
                    this.release(selector);
                    this.release(resolver);
                    return result;
                }
                Object var10_8 = null;
                if (sel == null) break block7;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                if (sel != null) {
                    selector.release(sel);
                }
                this.release(selector);
                this.release(resolver);
                throw throwable;
            }
            selector.release((Object)sel);
        }
        this.release(selector);
        this.release(resolver);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Map act(String type, String source, Parameters parameters) throws Exception {
        Map result;
        org.apache.excalibur.source.SourceResolver resolver;
        ServiceSelector selector;
        block7: {
            this.redirector.reset();
            selector = null;
            Action action = null;
            resolver = null;
            result = null;
            try {
                try {
                    selector = (ServiceSelector)this.lookup(Action.ROLE + "Selector");
                    Assert.assertNotNull((String)"Test lookup of action selector", (Object)selector);
                    resolver = (org.apache.excalibur.source.SourceResolver)this.lookup(org.apache.excalibur.source.SourceResolver.ROLE);
                    Assert.assertNotNull((String)"Test lookup of source resolver", (Object)resolver);
                    Assert.assertNotNull((String)"Test if action name is not null", (Object)type);
                    action = (Action)selector.select((Object)type);
                    Assert.assertNotNull((String)"Test lookup of action", (Object)action);
                    result = action.act((Redirector)this.redirector, (SourceResolver)new SourceResolverAdapter(resolver), this.objectmodel, source, parameters);
                }
                catch (ServiceException ce) {
                    this.getLogger().error("Could not retrieve action", (Throwable)ce);
                    Assert.fail((String)("Could not retrieve action: " + ce.toString()));
                    Object var10_9 = null;
                    if (action != null) {
                        selector.release(action);
                    }
                    this.release(selector);
                    this.release(resolver);
                    return result;
                }
                Object var10_8 = null;
                if (action == null) break block7;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                if (action != null) {
                    selector.release(action);
                }
                this.release(selector);
                this.release(resolver);
                throw throwable;
            }
            selector.release((Object)action);
        }
        this.release(selector);
        this.release(resolver);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Document generate(String type, String source, Parameters parameters) throws IOException, SAXException, ProcessingException {
        Document document;
        SAXParser parser;
        org.apache.excalibur.source.SourceResolver resolver;
        ServiceSelector selector;
        block7: {
            selector = null;
            Generator generator = null;
            resolver = null;
            parser = null;
            document = null;
            try {
                try {
                    selector = (ServiceSelector)this.lookup(Generator.ROLE + "Selector");
                    Assert.assertNotNull((String)"Test lookup of generator selector", (Object)selector);
                    resolver = (org.apache.excalibur.source.SourceResolver)this.lookup(org.apache.excalibur.source.SourceResolver.ROLE);
                    Assert.assertNotNull((String)"Test lookup of source resolver", (Object)resolver);
                    parser = (SAXParser)this.lookup(SAXParser.ROLE);
                    Assert.assertNotNull((String)"Test lookup of parser", (Object)parser);
                    Assert.assertNotNull((String)"Test if generator name is not null", (Object)type);
                    generator = (Generator)selector.select((Object)type);
                    Assert.assertNotNull((String)"Test lookup of generator", (Object)generator);
                    generator.setup((SourceResolver)new SourceResolverAdapter(resolver), this.objectmodel, source, parameters);
                    DOMBuilder builder = new DOMBuilder();
                    generator.setConsumer((XMLConsumer)new WhitespaceFilter((ContentHandler)builder));
                    generator.generate();
                    document = builder.getDocument();
                    Assert.assertNotNull((String)"Test for generator document", (Object)document);
                }
                catch (ServiceException ce) {
                    this.getLogger().error("Could not retrieve generator", (Throwable)ce);
                    Assert.fail((String)("Could not retrieve generator: " + ce.toString()));
                    Object var11_12 = null;
                    if (generator != null) {
                        selector.release(generator);
                    }
                    this.release(selector);
                    this.release(resolver);
                    this.release(parser);
                    return document;
                }
                Object var11_11 = null;
                if (generator == null) break block7;
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                if (generator != null) {
                    selector.release(generator);
                }
                this.release(selector);
                this.release(resolver);
                this.release(parser);
                throw throwable;
            }
            selector.release((Object)generator);
        }
        this.release(selector);
        this.release(resolver);
        this.release(parser);
        return document;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Document transform(String type, String source, Parameters parameters, Document input) throws SAXException, ProcessingException, IOException {
        Document document;
        Source inputsource;
        SAXParser parser;
        org.apache.excalibur.source.SourceResolver resolver;
        ServiceSelector selector;
        block16: {
            selector = null;
            Transformer transformer = null;
            resolver = null;
            parser = null;
            inputsource = null;
            Assert.assertNotNull((String)"Test for component manager", (Object)this.getManager());
            document = null;
            try {
                try {
                    selector = (ServiceSelector)this.lookup(Transformer.ROLE + "Selector");
                    Assert.assertNotNull((String)"Test lookup of transformer selector", (Object)selector);
                    resolver = (org.apache.excalibur.source.SourceResolver)this.lookup(org.apache.excalibur.source.SourceResolver.ROLE);
                    Assert.assertNotNull((String)"Test lookup of source resolver", (Object)resolver);
                    parser = (SAXParser)this.lookup(SAXParser.ROLE);
                    Assert.assertNotNull((String)"Test lookup of parser", (Object)parser);
                    Assert.assertNotNull((String)"Test if transformer name is not null", (Object)type);
                    transformer = (Transformer)selector.select((Object)type);
                    Assert.assertNotNull((String)"Test lookup of transformer", (Object)transformer);
                    transformer.setup((SourceResolver)new SourceResolverAdapter(resolver), this.objectmodel, source, parameters);
                    DOMBuilder builder = new DOMBuilder();
                    transformer.setConsumer((XMLConsumer)new WhitespaceFilter((ContentHandler)builder));
                    Assert.assertNotNull((String)"Test if input document is not null", (Object)input);
                    DOMStreamer streamer = new DOMStreamer((XMLConsumer)transformer);
                    streamer.stream((Node)input);
                    document = builder.getDocument();
                    Assert.assertNotNull((String)"Test for transformer document", (Object)document);
                }
                catch (ServiceException ce) {
                    this.getLogger().error("Could not retrieve transformer", (Throwable)ce);
                    ce.printStackTrace();
                    Assert.fail((String)("Could not retrieve transformer:" + ce.toString()));
                    Object var14_15 = null;
                    if (transformer != null) {
                        selector.release(transformer);
                    }
                    if (selector != null) {
                        this.release(selector);
                    }
                    if (inputsource != null) {
                        resolver.release(inputsource);
                    }
                    if (resolver != null) {
                        this.release(resolver);
                    }
                    if (parser == null) return document;
                    this.release(parser);
                    return document;
                }
                Object var14_14 = null;
                if (transformer == null) break block16;
            }
            catch (Throwable throwable) {
                Object var14_16 = null;
                if (transformer != null) {
                    selector.release(transformer);
                }
                if (selector != null) {
                    this.release(selector);
                }
                if (inputsource != null) {
                    resolver.release(inputsource);
                }
                if (resolver != null) {
                    this.release(resolver);
                }
                if (parser == null) throw throwable;
                this.release(parser);
                throw throwable;
            }
            selector.release((Object)transformer);
        }
        if (selector != null) {
            this.release(selector);
        }
        if (inputsource != null) {
            resolver.release(inputsource);
        }
        if (resolver != null) {
            this.release(resolver);
        }
        if (parser == null) return document;
        this.release(parser);
        return document;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final byte[] serialize(String type, Parameters parameters, Document input) throws SAXException, IOException {
        ByteArrayOutputStream document;
        Source inputsource;
        org.apache.excalibur.source.SourceResolver resolver;
        ServiceSelector selector;
        block13: {
            selector = null;
            Serializer serializer = null;
            resolver = null;
            inputsource = null;
            Assert.assertNotNull((String)"Test for component manager", (Object)this.getManager());
            document = null;
            try {
                try {
                    selector = (ServiceSelector)this.lookup(Serializer.ROLE + "Selector");
                    Assert.assertNotNull((String)"Test lookup of serializer selector", (Object)selector);
                    resolver = (org.apache.excalibur.source.SourceResolver)this.lookup(org.apache.excalibur.source.SourceResolver.ROLE);
                    Assert.assertNotNull((String)"Test lookup of source resolver", (Object)resolver);
                    Assert.assertNotNull((String)"Test if serializer name is not null", (Object)type);
                    serializer = (Serializer)selector.select((Object)type);
                    Assert.assertNotNull((String)"Test lookup of serializer", (Object)serializer);
                    document = new ByteArrayOutputStream();
                    serializer.setOutputStream((OutputStream)document);
                    Assert.assertNotNull((String)"Test if input document is not null", (Object)input);
                    DOMStreamer streamer = new DOMStreamer((XMLConsumer)serializer);
                    streamer.stream((Node)input);
                }
                catch (ServiceException ce) {
                    this.getLogger().error("Could not retrieve serializer", (Throwable)ce);
                    Assert.fail((String)("Could not retrieve serializer:" + ce.toString()));
                    Object var11_12 = null;
                    if (serializer != null) {
                        selector.release(serializer);
                    }
                    if (selector != null) {
                        this.release(selector);
                    }
                    if (inputsource != null) {
                        resolver.release(inputsource);
                    }
                    if (resolver == null) return document.toByteArray();
                    this.release(resolver);
                    return document.toByteArray();
                }
                Object var11_11 = null;
                if (serializer == null) break block13;
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                if (serializer != null) {
                    selector.release(serializer);
                }
                if (selector != null) {
                    this.release(selector);
                }
                if (inputsource != null) {
                    resolver.release(inputsource);
                }
                if (resolver == null) throw throwable;
                this.release(resolver);
                throw throwable;
            }
            selector.release((Object)serializer);
        }
        if (selector != null) {
            this.release(selector);
        }
        if (inputsource != null) {
            resolver.release(inputsource);
        }
        if (resolver == null) return document.toByteArray();
        this.release(resolver);
        return document.toByteArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String callFunction(String type, String source, String function, Map params) throws Exception {
        org.apache.excalibur.source.SourceResolver resolver;
        ServiceSelector selector;
        block10: {
            this.redirector.reset();
            selector = null;
            Interpreter interpreter = null;
            resolver = null;
            try {
                try {
                    selector = (ServiceSelector)this.lookup(Interpreter.ROLE);
                    Assert.assertNotNull((String)"Test lookup of interpreter selector", (Object)selector);
                    resolver = (org.apache.excalibur.source.SourceResolver)this.lookup(org.apache.excalibur.source.SourceResolver.ROLE);
                    Assert.assertNotNull((String)"Test lookup of source resolver", (Object)resolver);
                    Assert.assertNotNull((String)"Test if interpreter name is not null", (Object)type);
                    interpreter = (Interpreter)selector.select((Object)type);
                    Assert.assertNotNull((String)"Test lookup of interpreter", (Object)interpreter);
                    ((AbstractInterpreter)interpreter).register(source);
                    ArrayList<Interpreter.Argument> parameters = new ArrayList<Interpreter.Argument>();
                    Iterator i = params.keySet().iterator();
                    while (true) {
                        if (!i.hasNext()) {
                            interpreter.callFunction(function, parameters, (Redirector)this.getRedirector());
                            break;
                        }
                        String name = (String)i.next();
                        String value = (String)params.get(name);
                        parameters.add(new Interpreter.Argument(name, value));
                    }
                }
                catch (ServiceException ce) {
                    this.getLogger().error("Could not retrieve interpeter", (Throwable)ce);
                    Assert.fail((String)("Could not retrieve interpreter: " + ce.toString()));
                    Object var13_14 = null;
                    if (interpreter != null) {
                        selector.release((Object)interpreter);
                    }
                    this.release(selector);
                    this.release(resolver);
                    return FlowHelper.getWebContinuation((Map)this.getObjectModel()).getId();
                }
                Object var13_13 = null;
                if (interpreter == null) break block10;
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                if (interpreter != null) {
                    selector.release(interpreter);
                }
                this.release(selector);
                this.release(resolver);
                throw throwable;
            }
            selector.release((Object)interpreter);
        }
        this.release(selector);
        this.release(resolver);
        return FlowHelper.getWebContinuation((Map)this.getObjectModel()).getId();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String callContinuation(String type, String source, String id, Map params) throws Exception {
        org.apache.excalibur.source.SourceResolver resolver;
        ServiceSelector selector;
        block10: {
            this.redirector.reset();
            selector = null;
            Interpreter interpreter = null;
            resolver = null;
            try {
                try {
                    selector = (ServiceSelector)this.lookup(Interpreter.ROLE);
                    Assert.assertNotNull((String)"Test lookup of interpreter selector", (Object)selector);
                    resolver = (org.apache.excalibur.source.SourceResolver)this.lookup(org.apache.excalibur.source.SourceResolver.ROLE);
                    Assert.assertNotNull((String)"Test lookup of source resolver", (Object)resolver);
                    Assert.assertNotNull((String)"Test if interpreter name is not null", (Object)type);
                    interpreter = (Interpreter)selector.select((Object)type);
                    Assert.assertNotNull((String)"Test lookup of interpreter", (Object)interpreter);
                    ((AbstractInterpreter)interpreter).register(source);
                    ArrayList<Interpreter.Argument> parameters = new ArrayList<Interpreter.Argument>();
                    Iterator i = params.keySet().iterator();
                    while (true) {
                        if (!i.hasNext()) {
                            interpreter.handleContinuation(id, parameters, (Redirector)this.getRedirector());
                            break;
                        }
                        String name = (String)i.next();
                        String value = (String)params.get(name);
                        parameters.add(new Interpreter.Argument(name, value));
                    }
                }
                catch (ServiceException ce) {
                    this.getLogger().error("Could not retrieve interpreter", (Throwable)ce);
                    Assert.fail((String)("Could not retrieve interpreter: " + ce.toString()));
                    Object var13_14 = null;
                    if (interpreter != null) {
                        selector.release((Object)interpreter);
                    }
                    this.release(selector);
                    this.release(resolver);
                    return FlowHelper.getWebContinuation((Map)this.getObjectModel()).getId();
                }
                Object var13_13 = null;
                if (interpreter == null) break block10;
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                if (interpreter != null) {
                    selector.release(interpreter);
                }
                this.release(selector);
                this.release(resolver);
                throw throwable;
            }
            selector.release((Object)interpreter);
        }
        this.release(selector);
        this.release(resolver);
        return FlowHelper.getWebContinuation((Map)this.getObjectModel()).getId();
    }

    public Object getFlowContextObject() {
        return FlowHelper.getContextObject((Map)this.getObjectModel());
    }

    public final void print(Document document) {
        TransformerFactory factory = TransformerFactory.newInstance();
        try {
            javax.xml.transform.Transformer serializer = factory.newTransformer();
            serializer.transform(new DOMSource(document), new StreamResult(System.out));
            System.out.println();
        }
        catch (TransformerException te) {
            te.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Document load(String source) {
        Document assertiondocument;
        SAXParser parser;
        org.apache.excalibur.source.SourceResolver resolver;
        block9: {
            resolver = null;
            parser = null;
            Source assertionsource = null;
            Assert.assertNotNull((String)"Test for component manager", (Object)this.getManager());
            assertiondocument = null;
            try {
                try {
                    resolver = (org.apache.excalibur.source.SourceResolver)this.lookup(org.apache.excalibur.source.SourceResolver.ROLE);
                    Assert.assertNotNull((String)"Test lookup of source resolver", (Object)resolver);
                    parser = (SAXParser)this.lookup(SAXParser.ROLE);
                    Assert.assertNotNull((String)"Test lookup of parser", (Object)parser);
                    Assert.assertNotNull((String)"Test if assertion document is not null", (Object)source);
                    assertionsource = resolver.resolveURI(source);
                    Assert.assertNotNull((String)"Test lookup of assertion source", (Object)assertionsource);
                    Assert.assertTrue((String)"Test if source exist", (boolean)assertionsource.exists());
                    DOMBuilder builder = new DOMBuilder();
                    Assert.assertNotNull((String)"Test if inputstream of the assertion source is not null", (Object)assertionsource.getInputStream());
                    parser.parse(new InputSource(assertionsource.getInputStream()), (ContentHandler)((Object)new WhitespaceFilter((ContentHandler)builder)), (LexicalHandler)builder);
                    assertiondocument = builder.getDocument();
                    Assert.assertNotNull((String)"Test if assertion document exists", (Object)assertiondocument);
                }
                catch (ServiceException ce) {
                    this.getLogger().error("Could not retrieve generator", (Throwable)ce);
                    Assert.fail((String)("Could not retrieve generator: " + ce.toString()));
                    Object var9_9 = null;
                    if (resolver != null) {
                        resolver.release(assertionsource);
                    }
                    this.release(resolver);
                    this.release(parser);
                    return assertiondocument;
                }
                catch (Exception e) {
                    this.getLogger().error("Could not execute test", (Throwable)e);
                    Assert.fail((String)("Could not execute test: " + e));
                    Object var9_10 = null;
                    if (resolver != null) {
                        resolver.release(assertionsource);
                    }
                    this.release(resolver);
                    this.release(parser);
                    return assertiondocument;
                }
                Object var9_8 = null;
                if (resolver == null) break block9;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                if (resolver != null) {
                    resolver.release(assertionsource);
                }
                this.release(resolver);
                this.release(parser);
                throw throwable;
            }
            resolver.release(assertionsource);
        }
        this.release(resolver);
        this.release(parser);
        return assertiondocument;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final byte[] loadByteArray(String source) {
        byte[] assertiondocument;
        SAXParser parser;
        org.apache.excalibur.source.SourceResolver resolver;
        block10: {
            resolver = null;
            parser = null;
            Source assertionsource = null;
            Assert.assertNotNull((String)"Test for component manager", (Object)this.getManager());
            assertiondocument = null;
            try {
                try {
                    int c;
                    resolver = (org.apache.excalibur.source.SourceResolver)this.lookup(org.apache.excalibur.source.SourceResolver.ROLE);
                    Assert.assertNotNull((String)"Test lookup of source resolver", (Object)resolver);
                    parser = (SAXParser)this.lookup(SAXParser.ROLE);
                    Assert.assertNotNull((String)"Test lookup of parser", (Object)parser);
                    Assert.assertNotNull((String)"Test if assertion document is not null", (Object)source);
                    assertionsource = resolver.resolveURI(source);
                    Assert.assertNotNull((String)"Test lookup of assertion source", (Object)assertionsource);
                    Assert.assertTrue((String)"Test if source exist", (boolean)assertionsource.exists());
                    Assert.assertNotNull((String)"Test if inputstream of the assertion source is not null", (Object)assertionsource.getInputStream());
                    InputStream input = assertionsource.getInputStream();
                    long size = assertionsource.getContentLength();
                    assertiondocument = new byte[(int)size];
                    int i = 0;
                    while ((c = input.read()) != -1) {
                        void var10_11;
                        assertiondocument[i] = (byte)var10_11;
                        ++i;
                    }
                }
                catch (ServiceException ce) {
                    this.getLogger().error("Could not retrieve generator", (Throwable)ce);
                    Assert.fail((String)("Could not retrieve generator: " + ce.toString()));
                    Object var12_13 = null;
                    if (resolver != null) {
                        resolver.release(assertionsource);
                    }
                    this.release(resolver);
                    this.release(parser);
                    return assertiondocument;
                }
                catch (Exception e) {
                    this.getLogger().error("Could not execute test", (Throwable)e);
                    Assert.fail((String)("Could not execute test: " + e));
                    Object var12_14 = null;
                    if (resolver != null) {
                        resolver.release(assertionsource);
                    }
                    this.release(resolver);
                    this.release(parser);
                    return assertiondocument;
                }
                Object var12_12 = null;
                if (resolver == null) break block10;
            }
            catch (Throwable throwable) {
                Object var12_15 = null;
                if (resolver != null) {
                    resolver.release(assertionsource);
                }
                this.release(resolver);
                this.release(parser);
                throw throwable;
            }
            resolver.release(assertionsource);
        }
        this.release(resolver);
        this.release(parser);
        return assertiondocument;
    }

    public final Diff compareXML(Document control, Document test) {
        return new Diff(control, test);
    }

    public final void assertEqual(String msg, Document expected, Document actual) {
        expected.getDocumentElement().normalize();
        actual.getDocumentElement().normalize();
        Diff diff = this.compareXML(expected, actual);
        Assert.assertEquals((String)(msg + ", " + diff.toString()), (boolean)true, (boolean)diff.similar());
    }

    public final void assertEqual(Document expected, Document actual) {
        expected.getDocumentElement().normalize();
        actual.getDocumentElement().normalize();
        Diff diff = this.compareXML(expected, actual);
        Assert.assertEquals((String)("Test if the assertion document is equal, " + diff.toString()), (boolean)true, (boolean)diff.similar());
    }

    public final void assertIdentical(String msg, Document expected, Document actual) {
        expected.getDocumentElement().normalize();
        actual.getDocumentElement().normalize();
        Diff diff = this.compareXML(expected, actual);
        Assert.assertEquals((String)(msg + ", " + diff.toString()), (boolean)true, (boolean)diff.identical());
    }

    public final void assertIdentical(Document expected, Document actual) {
        expected.getDocumentElement().normalize();
        actual.getDocumentElement().normalize();
        Diff diff = this.compareXML(expected, actual);
        Assert.assertEquals((String)("Test if the assertion document is equal, " + diff.toString()), (boolean)true, (boolean)diff.identical());
    }

    public final void assertIdentical(byte[] expected, byte[] actual) {
        Assert.assertEquals((String)"Byte arrays of differing sizes, ", (int)expected.length, (int)actual.length);
        if (expected.length > 0) {
            int i = 0;
            while (i < expected.length) {
                Assert.assertEquals((String)("Byte array differs at index " + i), (byte)expected[i], (byte)actual[i]);
                ++i;
            }
        }
    }
}

