/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.environment.mock;

import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import junit.framework.AssertionFailedError;
import org.apache.cocoon.environment.Cookie;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Session;
import org.apache.cocoon.environment.mock.MockSession;

public class MockRequest
implements Request {
    private Hashtable attributes = new Hashtable();
    private String scheme;
    private String protocol = "HTTP/1.1";
    private String requestURI;
    private String contextPath = "";
    private String servletPath;
    private String pathInfo;
    private String queryString;
    private String method = "GET";
    private String contentType;
    private Locale locale;
    private Principal principal;
    private String remoteAddr;
    private String remoteHost;
    private String remoteUser;
    private String userRole;
    private String reqSessionId;
    private String authType;
    private String charEncoding;
    private String serverName;
    private int port = 80;
    private Hashtable parameters = new Hashtable();
    private Hashtable headers = new Hashtable();
    private HashMap cookies = new HashMap();
    private MockSession session;

    public Object get(String name) {
        return this.getAttribute(name);
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        return this.attributes.keys();
    }

    public void setAttribute(String name, Object o) {
        if (o == null) {
            this.attributes.remove(name);
        } else {
            this.attributes.put(name, o);
        }
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public String getAuthType() {
        return this.authType;
    }

    public String getCharacterEncoding() {
        return this.charEncoding;
    }

    public void setCharacterEncoding(String enc) throws UnsupportedEncodingException {
        this.charEncoding = enc;
    }

    public int getContentLength() {
        return -1;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getParameter(String name) {
        return (String)this.parameters.get(name);
    }

    public Enumeration getParameterNames() {
        return this.parameters.keys();
    }

    public String[] getParameterValues(String name) {
        Object param = this.parameters.get(name);
        if (null == param) {
            return null;
        }
        if (param.getClass().isArray()) {
            return (String[])param;
        }
        return new String[]{(String)param};
    }

    public void addParameter(String name, String value) {
        this.parameters.put(name, value);
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getServerName() {
        return this.serverName;
    }

    public int getServerPort() {
        return this.port;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Enumeration getLocales() {
        return Collections.enumeration(Collections.singleton(this.getLocale()));
    }

    public boolean isSecure() {
        if (this.scheme == null) {
            return false;
        }
        return this.scheme.equalsIgnoreCase("HTTPS");
    }

    public Cookie[] getCookies() {
        if (this.cookies.isEmpty()) {
            return null;
        }
        Cookie[] cookieArray = new Cookie[this.cookies.size()];
        return this.cookies.values().toArray(cookieArray);
    }

    public Map getCookieMap() {
        return this.cookies;
    }

    public long getDateHeader(String name) {
        String s1 = this.getHeader(name);
        if (s1 == null) {
            return -1L;
        }
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat();
            return dateFormat.parse(s1).getTime();
        }
        catch (ParseException exception) {
            throw new IllegalArgumentException("Cannot parse date: " + s1);
        }
    }

    public String getHeader(String name) {
        return (String)this.headers.get(name);
    }

    public Enumeration getHeaders(String name) {
        throw new AssertionFailedError("Not implemented");
    }

    public Enumeration getHeaderNames() {
        return this.headers.keys();
    }

    public String getMethod() {
        return this.method;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getPathTranslated() {
        throw new AssertionFailedError("Not implemented");
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String path) {
        this.contextPath = path;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String string) {
        this.queryString = string;
    }

    public String getRemoteUser() {
        return this.remoteUser;
    }

    public Principal getUserPrincipal() {
        return this.principal;
    }

    public boolean isUserInRole(String role) {
        return this.userRole.equals(role);
    }

    public String getRequestedSessionId() {
        return this.reqSessionId;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public void setRequestURI(String uri) {
        this.requestURI = uri;
    }

    public String getSitemapURI() {
        return this.requestURI;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public Session getSession(boolean create) {
        if (this.session == null && create) {
            this.session = new MockSession();
        } else if (this.session != null && !this.session.isValid() && create) {
            this.session = new MockSession();
        }
        if (this.session != null && this.session.isValid()) {
            return this.session;
        }
        return null;
    }

    public Session getSession() {
        return this.getSession(true);
    }

    public boolean isRequestedSessionIdValid() {
        if (this.session != null) {
            try {
                this.session.getId();
                return true;
            }
            catch (IllegalStateException e) {
                return false;
            }
        }
        return false;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return true;
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    public void reset() {
        this.attributes.clear();
        this.scheme = null;
        this.protocol = "HTTP/1.1";
        this.requestURI = null;
        this.contextPath = null;
        this.servletPath = null;
        this.pathInfo = null;
        this.queryString = null;
        this.method = "GET";
        this.contentType = null;
        this.locale = null;
        this.principal = null;
        this.remoteAddr = null;
        this.remoteHost = null;
        this.remoteUser = null;
        this.userRole = null;
        this.reqSessionId = null;
        this.authType = null;
        this.charEncoding = null;
        this.serverName = null;
        this.port = 80;
        this.parameters.clear();
        this.headers.clear();
    }

    public void setHeader(String key, String value) {
        this.headers.put(key, value);
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void clearSession() {
        this.session = null;
    }
}

