/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.environment.mock;

import java.util.Enumeration;
import java.util.Hashtable;
import junit.framework.AssertionFailedError;
import org.apache.cocoon.environment.Session;

public class MockSession
implements Session {
    private long creationtime = System.currentTimeMillis();
    private String id = "MockSession";
    private long lastaccessedtime = System.currentTimeMillis();
    private int maxinactiveinterval = -1;
    private Hashtable attributes = new Hashtable();
    private boolean valid = true;

    public long getCreationTime() {
        this.checkValid();
        return this.creationtime;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        this.checkValid();
        return this.id;
    }

    public long getLastAccessedTime() {
        this.checkValid();
        return this.lastaccessedtime;
    }

    public void setMaxInactiveInterval(int interval) {
        this.checkValid();
        this.maxinactiveinterval = interval;
    }

    public int getMaxInactiveInterval() {
        this.checkValid();
        return this.maxinactiveinterval;
    }

    public Object getAttribute(String name) {
        this.checkValid();
        return this.attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        this.checkValid();
        return this.attributes.keys();
    }

    public void setAttribute(String name, Object value) {
        this.checkValid();
        this.attributes.put(name, value);
    }

    public void removeAttribute(String name) {
        this.checkValid();
        this.attributes.remove(name);
    }

    public void invalidate() {
        this.checkValid();
        this.valid = false;
    }

    public boolean isNew() {
        this.checkValid();
        return false;
    }

    private void checkValid() throws IllegalStateException {
        if (!this.valid) {
            throw new AssertionFailedError("session has been invalidated!");
        }
    }

    public boolean isValid() {
        return this.valid;
    }
}

