/*
 * Decompiled with CFR 0.152.
 */
package no.skatteetaten.fastsetting.formueinntekt.felles.documentsql.oracle;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import javax.sql.DataSource;
import no.skatteetaten.fastsetting.formueinntekt.felles.documentsql.api.AuditMonitor;

public class OracleAuditMonitor
implements AuditMonitor {
    private final DataSource dataSource;
    private final Calendar utc = Calendar.getInstance(TimeZone.getTimeZone("UTC"));

    public OracleAuditMonitor(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Map<String, Long> summary(OffsetDateTime from, OffsetDateTime to) {
        try (Connection conn = this.dataSource.getConnection();){
            HashMap<String, Long> hashMap;
            block22: {
                PreparedStatement ps = conn.prepareStatement("SELECT USERNAME, COUNT(*) COUNT FROM USER_AUDIT_TRAIL WHERE USERNAME != USER AND TIMESTAMP BETWEEN ? AND ? GROUP BY USERNAME");
                try {
                    ps.setTimestamp(1, Timestamp.valueOf(from.atZoneSameInstant(ZoneOffset.UTC).toLocalDateTime()), this.utc);
                    ps.setTimestamp(2, Timestamp.valueOf(to.atZoneSameInstant(ZoneOffset.UTC).toLocalDateTime()), this.utc);
                    HashMap<String, Long> results = new HashMap<String, Long>();
                    try (ResultSet rs = ps.executeQuery();){
                        while (rs.next()) {
                            results.put(rs.getString("USERNAME"), rs.getLong("COUNT"));
                        }
                    }
                    hashMap = results;
                    if (ps == null) break block22;
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ps.close();
            }
            return hashMap;
        }
        catch (SQLException e) {
            throw new IllegalStateException("Failed to read audit summary", e);
        }
    }
}

