/*
 * Decompiled with CFR 0.152.
 */
package no.skatteetaten.fastsetting.formueinntekt.felles.documentsql.oracle;

import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.sql.DataSource;
import no.skatteetaten.fastsetting.formueinntekt.felles.documentsql.api.JdbcDispatcher;
import no.skatteetaten.fastsetting.formueinntekt.felles.documentsql.api.RevisionedId;
import no.skatteetaten.fastsetting.formueinntekt.felles.documentsql.api.TableResolver;

class OracleDispatcher<T>
implements JdbcDispatcher<T> {
    private final List<String> create;
    private final List<String> drop;
    private final List<String> grant;
    private final Map<String, String> overrides;
    private final String insert;
    private final String truncate;
    private final TableResolver<T> resolver;

    OracleDispatcher(List<String> create, List<String> drop, List<String> grant, Map<String, String> overrides, String insert, String truncate, TableResolver<T> resolver) {
        this.create = create;
        this.drop = drop;
        this.grant = grant;
        this.overrides = overrides;
        this.insert = insert;
        this.truncate = truncate;
        this.resolver = resolver;
    }

    private static String asExecutableStatement(String sql) {
        return sql + (sql.endsWith(";") ? "" : ";");
    }

    public void printTo(Consumer<List<String>> consumer) {
        consumer.accept(Stream.of(Stream.of("-- creation"), this.create.stream().map(OracleDispatcher::asExecutableStatement), Stream.of("-- grant"), this.grant.stream().map(statement -> OracleDispatcher.asExecutableStatement(String.format(statement, "[users]"))), Stream.of("-- insert"), Stream.of(OracleDispatcher.asExecutableStatement(this.insert)), Stream.of("-- truncate"), Stream.of(OracleDispatcher.asExecutableStatement(this.truncate)), Stream.of("-- drop"), this.drop.stream().map(OracleDispatcher::asExecutableStatement)).flatMap(Function.identity()).collect(Collectors.toList()));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void create(DataSource dataSource, Collection<String> users, Consumer<String> callback) throws SQLException {
        try (Connection conn = dataSource.getConnection();
             Statement stmt = conn.createStatement();){
            ArrayList<Object> delayed = new ArrayList<Object>(this.overrides.size());
            for (String string : this.create) {
                void var8_12;
                if (!users.isEmpty() && this.overrides.containsKey(string)) {
                    if (!string.startsWith("CREATE")) {
                        throw new IllegalStateException("Override does not create object: " + string);
                    }
                    if (!string.startsWith("CREATE OR REPLACE")) {
                        delayed.add("CREATE OR REPLACE" + string.substring("CREATE".length()));
                    } else {
                        delayed.add(string);
                    }
                    String string2 = this.overrides.get(string);
                }
                callback.accept((String)var8_12);
                try {
                    stmt.execute((String)var8_12);
                }
                catch (SQLException e) {
                    throw new SQLException("Failed to execute: " + (String)var8_12, e.getSQLState(), e.getErrorCode(), e);
                }
            }
            if (!users.isEmpty()) {
                String listOfUsers = users.stream().map(String::toUpperCase).distinct().sorted().collect(Collectors.joining(", "));
                for (String statement : this.grant) {
                    String sql = String.format(statement, listOfUsers);
                    callback.accept(sql);
                    try {
                        stmt.execute(sql);
                    }
                    catch (SQLException e) {
                        throw new SQLException("Failed to execute: " + sql, e.getSQLState(), e.getErrorCode(), e);
                    }
                }
            }
            for (String string : delayed) {
                callback.accept(string);
                try {
                    stmt.execute(string);
                }
                catch (SQLException e) {
                    throw new SQLException("Failed to execute: " + string, e.getSQLState(), e.getErrorCode(), e);
                    return;
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void drop(DataSource dataSource, Consumer<String> callback, Predicate<SQLException> check) throws SQLException {
        try (Connection conn = dataSource.getConnection();
             Statement stmt = conn.createStatement();){
            for (String sql : this.drop) {
                callback.accept(sql);
                try {
                    stmt.execute(sql);
                }
                catch (SQLException e) {
                    if (check.test(e)) continue;
                    throw new SQLException("Failed to execute: " + sql, e.getSQLState(), e.getErrorCode(), e);
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(Connection conn, Map<RevisionedId, T> payloads) throws SQLException {
        if (payloads.isEmpty()) {
            return;
        }
        ArrayList<Clob> clobs = new ArrayList<Clob>(payloads.size());
        try (PreparedStatement ps = conn.prepareStatement(this.insert);){
            for (Map.Entry<RevisionedId, T> payload : payloads.entrySet()) {
                ps.setString(1, payload.getKey().getId());
                ps.setLong(2, payload.getKey().getRevision());
                ps.setBoolean(3, payload.getKey().isDeleted());
                String value = this.resolver.toPayload(payload.getValue());
                if (value == null) {
                    ps.setNull(4, 2005);
                } else {
                    Clob clob = conn.createClob();
                    clobs.add(clob);
                    clob.setString(1L, value);
                    ps.setClob(4, clob);
                }
                this.resolver.registerAdditionalValues(5, ps, payload.getValue());
                ps.addBatch();
            }
            ps.executeBatch();
        }
        finally {
            for (Clob clob : clobs) {
                clob.free();
            }
        }
    }

    public void truncate(DataSource dataSource) throws SQLException {
        try (Connection conn = dataSource.getConnection();
             Statement stmt = conn.createStatement();){
            stmt.execute(this.truncate);
        }
    }
}

