/*
 * Decompiled with CFR 0.152.
 */
package no.skatteetaten.fastsetting.formueinntekt.felles.documentsql.oracle;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import no.skatteetaten.fastsetting.formueinntekt.felles.documentsql.api.JdbcDispatcher;
import no.skatteetaten.fastsetting.formueinntekt.felles.documentsql.api.JdbcDispatcherFactory;
import no.skatteetaten.fastsetting.formueinntekt.felles.documentsql.api.NameResolver;
import no.skatteetaten.fastsetting.formueinntekt.felles.documentsql.api.PathElement;
import no.skatteetaten.fastsetting.formueinntekt.felles.documentsql.api.SyntheticNamespacePrefixResolver;
import no.skatteetaten.fastsetting.formueinntekt.felles.documentsql.api.TableResolver;
import no.skatteetaten.fastsetting.formueinntekt.felles.documentsql.oracle.OracleDispatcher;
import no.skatteetaten.fastsetting.formueinntekt.felles.documentsql.oracle.OracleSqlEmitter;
import no.skatteetaten.fastsetting.formueinntekt.felles.documentsql.oracle.OracleTypeResolver;

public class OracleDispatcherFactory
implements JdbcDispatcherFactory {
    private static final int MAX_COLUMNS_VIEW = 200;
    private static final int VIEW_OR_TABLE_EXISTS = 955;
    private static final int MATERIALIZED_VIEW_EXISTS = 12006;
    private static final int PARAMETER_EXISTS = 44740;
    private static final int VIEW_OR_TABLE_NOT_EXISTS = 942;
    private static final int MATERIALIZED_VIEW_NOT_EXISTS = 12003;
    private static final int PUBLIC_SYNONYM_NOT_EXISTS = 1432;
    private final OracleSqlEmitter emitter;
    private final Function<Class<?>, String> typeResolver;
    private final Function<Set<String>, Map<String, String>> namespacePrefixResolver;
    private final boolean audit;
    private final boolean meta;
    private final boolean synonym;
    private final boolean grantViewOnDummy;
    private final Function<String, List<String>> onCreation;
    private final Function<String, List<String>> onDrop;

    private OracleDispatcherFactory(OracleSqlEmitter emitter, Function<Set<String>, Map<String, String>> namespacePrefixResolver, Function<Class<?>, String> typeResolver, boolean audit, boolean meta, boolean synonym, boolean grantViewOnDummy, Function<String, List<String>> onCreation, Function<String, List<String>> onDrop) {
        this.emitter = emitter;
        this.namespacePrefixResolver = namespacePrefixResolver;
        this.typeResolver = typeResolver;
        this.onCreation = onCreation;
        this.onDrop = onDrop;
        this.audit = audit;
        this.meta = meta;
        this.synonym = synonym;
        this.grantViewOnDummy = grantViewOnDummy;
    }

    public static OracleDispatcherFactory ofXml() {
        return OracleDispatcherFactory.of(OracleSqlEmitter.XML, (Function<Set<String>, Map<String, String>>)new SyntheticNamespacePrefixResolver());
    }

    public static OracleDispatcherFactory ofXml(Function<Set<String>, Map<String, String>> namespacePrefixResolver) {
        return OracleDispatcherFactory.of(OracleSqlEmitter.XML, namespacePrefixResolver);
    }

    public static OracleDispatcherFactory ofJson() {
        return OracleDispatcherFactory.of(OracleSqlEmitter.JSON, namespace -> {
            throw new IllegalStateException("Unexpected resolution of namespace " + namespace + " during JSON processing");
        });
    }

    private static OracleDispatcherFactory of(OracleSqlEmitter emitter, Function<Set<String>, Map<String, String>> namespacePrefixResolver) {
        return new OracleDispatcherFactory(emitter, namespacePrefixResolver, new OracleTypeResolver(true), false, true, false, false, base -> Collections.emptyList(), base -> Collections.emptyList());
    }

    public OracleDispatcherFactory withTypeResolver(Function<Class<?>, String> typeResolver) {
        return new OracleDispatcherFactory(this.emitter, this.namespacePrefixResolver, typeResolver, this.audit, this.meta, this.synonym, this.grantViewOnDummy, this.onCreation, this.onDrop);
    }

    public OracleDispatcherFactory withAudit(boolean audit) {
        return new OracleDispatcherFactory(this.emitter, this.namespacePrefixResolver, this.typeResolver, audit, this.meta, this.synonym, this.grantViewOnDummy, this.onCreation, this.onDrop);
    }

    public OracleDispatcherFactory withMeta(boolean meta) {
        return new OracleDispatcherFactory(this.emitter, this.namespacePrefixResolver, this.typeResolver, this.audit, meta, this.synonym, this.grantViewOnDummy, this.onCreation, this.onDrop);
    }

    public OracleDispatcherFactory withSynonym(boolean synonym) {
        return new OracleDispatcherFactory(this.emitter, this.namespacePrefixResolver, this.typeResolver, this.audit, this.meta, synonym, this.grantViewOnDummy, this.onCreation, this.onDrop);
    }

    public OracleDispatcherFactory withGrantViewOnDummy(boolean grantViewOnDummy) {
        return new OracleDispatcherFactory(this.emitter, this.namespacePrefixResolver, this.typeResolver, this.audit, this.meta, this.synonym, grantViewOnDummy, this.onCreation, this.onDrop);
    }

    public OracleDispatcherFactory withOnCreation(Function<String, Collection<String>> onCreation) {
        return new OracleDispatcherFactory(this.emitter, this.namespacePrefixResolver, this.typeResolver, this.audit, this.meta, this.synonym, this.grantViewOnDummy, base -> Stream.concat(this.onCreation.apply((String)base).stream(), ((Collection)onCreation.apply((String)base)).stream()).collect(Collectors.toList()), this.onDrop);
    }

    public OracleDispatcherFactory withOnDrop(Function<String, Collection<String>> onDrop) {
        return new OracleDispatcherFactory(this.emitter, this.namespacePrefixResolver, this.typeResolver, this.audit, this.meta, this.synonym, this.grantViewOnDummy, this.onCreation, base -> Stream.concat(this.onDrop.apply((String)base).stream(), ((Collection)onDrop.apply((String)base)).stream()).collect(Collectors.toList()));
    }

    public <T> JdbcDispatcher<T> create(String name, Map<List<List<PathElement>>, Map<List<PathElement>, Class<?>>> views, NameResolver nameResolver, TableResolver<T> tableResolver) {
        String base = nameResolver.resolve(Collections.singletonList(name));
        LinkedHashMap<CallSite, String> objects = new LinkedHashMap<CallSite, String>();
        HashMap<CallSite, Integer> viewIndices = new HashMap<CallSite, Integer>();
        ArrayList<String> ddl = new ArrayList<String>();
        ddl.add("CREATE TABLE " + base + "_RAW (ID VARCHAR2(250) NOT NULL, REVISION NUMBER(19) NOT NULL, DELETED NUMBER(1) NOT NULL, PAYLOAD " + this.emitter.getPayloadType() + ", " + tableResolver.getAdditionalColumns().entrySet().stream().map(entry -> (String)entry.getKey() + " " + (String)entry.getValue() + ", ").collect(Collectors.joining()) + "CONSTRAINT " + base + "_PK PRIMARY KEY (ID, REVISION))");
        objects.put((CallSite)((Object)(base + "_RAW")), "TABLE");
        ddl.addAll(this.emitter.afterCreateTable(base));
        HashSet<CallSite> indices = new HashSet<CallSite>(Collections.singleton(base + "_IDX"));
        for (String column : tableResolver.getAdditionalColumns().keySet()) {
            String index = nameResolver.resolve(Arrays.asList(base, column), indices::contains);
            if (!indices.add((CallSite)((Object)index))) {
                throw new IllegalStateException("Index name already in use: " + index);
            }
            ddl.add("CREATE INDEX " + index + "_IDX ON " + base + "_RAW (" + column + ")");
        }
        for (String suffix : Arrays.asList("MIN", "MAX")) {
            viewIndices.put((CallSite)((Object)(base + "_" + suffix)), ddl.size());
            ddl.add("CREATE VIEW " + base + "_" + suffix + " AS SELECT ID, " + suffix + "(REVISION) REVISION FROM " + base + "_RAW GROUP BY ID");
            objects.put((CallSite)((Object)(base + "_" + suffix)), "VIEW");
        }
        viewIndices.put((CallSite)((Object)(base + "_NOW")), ddl.size());
        ddl.add("CREATE VIEW " + base + "_NOW AS SELECT ID, MAX(REVISION) REVISION FROM " + base + "_RAW GROUP BY ID INTERSECT SELECT ID, REVISION FROM " + base + "_RAW WHERE DELETED = 0");
        objects.put((CallSite)((Object)(base + "_NOW")), "VIEW");
        List directColumns = Stream.concat(Stream.of("ID", "REVISION", "DELETED", "PAYLOAD"), tableResolver.getAdditionalColumns().keySet().stream()).collect(Collectors.toList());
        LinkedHashMap viewMeta = new LinkedHashMap();
        views.forEach((paths, properties) -> {
            String view = nameResolver.resolve(Stream.concat(Stream.of(base), paths.stream().flatMap(path -> PathElement.dense((List)path).stream()).skip(this.emitter.getRoots())).collect(Collectors.toList()), objects.keySet()::contains);
            if (objects.containsKey(view)) {
                throw new IllegalStateException("View name already in use: " + view);
            }
            HashSet reserved = new HashSet(directColumns);
            Map<List<PathElement>, String> columns = properties.keySet().stream().collect(Collectors.toMap(Function.identity(), path -> {
                String column = nameResolver.resolve(PathElement.dense((List)path), reserved::contains);
                if (!reserved.add(column)) {
                    throw new IllegalStateException("Column name " + column + " already assigned for " + view);
                }
                return column;
            }));
            if (columns.size() > 200) {
                Iterator iterator = properties.entrySet().stream().sorted(Comparator.comparing(entry -> (String)columns.get(entry.getKey()))).iterator();
                HashMap current = new HashMap();
                int partition = 0;
                while (iterator.hasNext()) {
                    String alias;
                    Map.Entry entry2 = (Map.Entry)iterator.next();
                    current.put((List)entry2.getKey(), (Class)entry2.getValue());
                    if (current.size() != 200 && iterator.hasNext()) continue;
                    while (objects.containsKey(alias = view + "_" + partition++)) {
                    }
                    this.emitter.makeView(base, alias, (List<List<PathElement>>)paths, directColumns, current, columns, (List<String>)ddl, (Map<String, Integer>)viewIndices, viewMeta, (Map<String, String>)objects, this.namespacePrefixResolver, this.typeResolver);
                    current.clear();
                }
            } else {
                this.emitter.makeView(base, view, (List<List<PathElement>>)paths, directColumns, (Map<List<PathElement>, Class<?>>)properties, columns, (List<String>)ddl, (Map<String, Integer>)viewIndices, viewMeta, (Map<String, String>)objects, this.namespacePrefixResolver, this.typeResolver);
            }
        });
        if (this.audit) {
            ddl.add("AUDIT SELECT ON " + base + "_RAW BY ACCESS");
            objects.entrySet().stream().filter(entry -> ((String)entry.getValue()).equals("MATERIALIZED VIEW")).forEach(entry -> ddl.add("AUDIT SELECT ON " + (String)entry.getKey() + " BY ACCESS"));
        }
        if (this.meta) {
            ddl.add("CREATE VIEW " + base + "_MTA AS " + Stream.concat(Stream.of("SELECT NULL AS PATH, NULL AS OBJECT, NULL AS NAME FROM DUAL WHERE 0 = 1"), viewMeta.entrySet().stream().flatMap(entry -> ((Map)entry.getValue()).entrySet().stream().map(location -> "SELECT '" + (String)location.getKey() + "' AS PATH, '" + (String)entry.getKey() + "' AS OBJECT, '" + (String)location.getValue() + "' AS NAME FROM DUAL"))).collect(Collectors.joining(" UNION ALL ")));
            objects.put((CallSite)((Object)(base + "_MTA")), "VIEW");
        }
        if (this.synonym) {
            objects.keySet().forEach(object -> ddl.add("CREATE PUBLIC SYNONYM " + object + " FOR " + object));
        }
        ddl.addAll((Collection)this.onCreation.apply(base + "_RAW"));
        return new OracleDispatcher<T>(ddl, Stream.of(objects.entrySet().stream().map(entry -> "DROP " + (String)entry.getValue() + " " + (String)entry.getKey()), this.synonym ? objects.keySet().stream().map(object -> "DROP PUBLIC SYNONYM " + object) : Stream.empty(), this.onDrop.apply(base + "_RAW").stream()).flatMap(Function.identity()).collect(Collectors.toList()), objects.keySet().stream().map(object -> "GRANT SELECT ON " + object + " TO %s").collect(Collectors.toList()), this.grantViewOnDummy ? viewIndices.entrySet().stream().collect(Collectors.toMap(entry -> (String)ddl.get((Integer)entry.getValue()), entry -> "CREATE VIEW " + (String)entry.getKey() + " AS SELECT DUMMY FROM DUAL")) : Collections.emptyMap(), "INSERT INTO " + base + "_RAW (" + Stream.concat(Stream.of("ID", "REVISION", "DELETED", "PAYLOAD"), tableResolver.getAdditionalColumns().keySet().stream()).collect(Collectors.joining(", ")) + ") VALUES (" + Stream.concat(Stream.of("?", "?", "?", this.emitter.getValueVariable()), Collections.nCopies(tableResolver.getAdditionalColumns().size(), "?").stream()).collect(Collectors.joining(", ")) + ")", "TRUNCATE TABLE " + base + "_RAW", tableResolver);
    }

    public Optional<String> getBaseTable() {
        return Optional.of("DUAL");
    }

    public boolean checkError(boolean exists, int code) {
        if (exists) {
            return code == 955 || code == 12006 || code == 44740;
        }
        return code == 942 || code == 12003 || code == 1432;
    }
}

