/*
 * Decompiled with CFR 0.152.
 */
package no.skatteetaten.fastsetting.formueinntekt.felles.documentsql.oracle;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

class OracleJsonStrictSyntaxTransformer
implements Function<String, String> {
    private final Map<String, String> escape = new LinkedHashMap<String, String>();
    private final Set<String> quote = new HashSet<String>();

    OracleJsonStrictSyntaxTransformer() {
        this.escape.put("\\", "\\\\");
        this.escape.put("\t", "\\t");
        this.escape.put("\r", "\\r");
        this.escape.put("\b", "\\b");
        this.escape.put("\f", "\\f");
        this.escape.put("\n", "\\n");
        this.escape.put("\"", "\\\"");
        this.escape.put("/", "\\/");
        this.quote.add(".");
        this.quote.add("$");
        this.quote.add("@");
    }

    @Override
    public String apply(String element) {
        block4: {
            block3: {
                if (this.escape.keySet().stream().anyMatch(element::contains)) break block3;
                if (!this.quote.stream().anyMatch(element::contains)) break block4;
            }
            for (Map.Entry<String, String> entry : this.escape.entrySet()) {
                element = element.replace(entry.getKey(), entry.getValue());
            }
            return "\"" + element + "\"";
        }
        return element;
    }
}

