/*
 * Decompiled with CFR 0.152.
 */
package no.skatteetaten.fastsetting.formueinntekt.felles.documentsql.oracle;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import no.skatteetaten.fastsetting.formueinntekt.felles.documentsql.api.PathElement;
import no.skatteetaten.fastsetting.formueinntekt.felles.documentsql.oracle.OracleJsonStrictSyntaxTransformer;

enum OracleSqlEmitter {
    XML("XMLTYPE NOT NULL", "XMLTYPE(?)", 1){
        private static final int MAX_STRING_LENGTH = 32766;

        @Override
        List<String> afterCreateTable(String base) {
            return Collections.singletonList("CREATE INDEX " + base + "_IDX ON " + base + "_RAW (PAYLOAD) INDEXTYPE IS XDB.XMLINDEX PARAMETERS ('PATH TABLE " + base + "_PTL')");
        }

        @Override
        void makeView(String base, String name, List<List<PathElement>> paths, List<String> directColumns, Map<List<PathElement>, Class<?>> properties, Map<List<PathElement>, String> columns, List<String> ddl, Map<String, Integer> viewIndices, Map<String, Map<String, String>> viewMeta, Map<String, String> objects, Function<Set<String>, Map<String, String>> namespacePrefixResolver, Function<Class<?>, String> typeResolver) {
            Map<String, String> namespaces = namespacePrefixResolver.apply(Stream.concat(paths.stream(), properties.keySet().stream()).flatMap(Collection::stream).flatMap(element -> element.getNamespace().stream()).collect(Collectors.toCollection(LinkedHashSet::new)));
            String root = "/" + PathElement.full((String)"/", Function.identity(), paths.stream().flatMap(Collection::stream).collect(Collectors.toList()), namespaces::get);
            String sqlColumns = Stream.concat(directColumns.stream(), properties.keySet().stream().map(columns::get)).collect(Collectors.joining(", "));
            String xmlColumns = properties.entrySet().stream().map(entry -> (String)columns.get(entry.getKey()) + " " + (String)typeResolver.apply((Class)entry.getValue()) + " PATH '" + PathElement.full((String)".", (String)"/", Function.identity(), (List)((List)entry.getKey()), namespaces::get) + "'").collect(Collectors.joining(", "));
            String namespace = namespaces.isEmpty() ? "" : namespaces.entrySet().stream().sorted(Map.Entry.comparingByValue()).map(entry -> {
                if (((String)entry.getValue()).isEmpty()) {
                    return "DEFAULT '" + (String)entry.getKey() + "'";
                }
                return "'" + (String)entry.getKey() + "' AS \"" + (String)entry.getValue() + "\"";
            }).collect(Collectors.joining(", ", "XMLNAMESPACES(", "), "));
            viewIndices.put(name, ddl.size());
            ddl.add("CREATE VIEW " + name + " AS SELECT " + sqlColumns + " FROM " + base + "_RAW, XMLTABLE(" + namespace + "'" + root + "' PASSING PAYLOAD COLUMNS " + xmlColumns + ")");
            ddl.add(this.safeParameterRegistration(name + "_IDP", "ADD_GROUP GROUP " + name + "_GRP XMLTABLE " + name + "_GPI " + namespace.replace("'", "''") + "''" + root + "'' COLUMNS " + xmlColumns.replace("'", "''")));
            ddl.add("ALTER INDEX " + base + "_IDX PARAMETERS ('PARAM " + name + "_IDP')");
            ddl.add("BEGIN DBMS_XMLINDEX.DROPPARAMETER('" + name + "_IDP'); END;");
            int index = 0;
            for (String column : properties.keySet().stream().map(columns::get).sorted().collect(Collectors.toList())) {
                ddl.add("CREATE INDEX " + name + "_IDX" + index++ + " ON " + name + "_GPI (" + column + ")");
            }
            objects.put(name, "VIEW");
            viewMeta.put(name, properties.keySet().stream().collect(Collectors.toMap(path -> PathElement.full((String)"/", (String)"/", Function.identity(), Stream.concat(paths.stream().flatMap(Collection::stream), path.stream()).collect(Collectors.toList()), namespaces::get), columns::get)));
        }

        private String safeParameterRegistration(String name, String value) {
            Object registration;
            String declaration;
            if (value.length() > 32766) {
                declaration = "DECLARE INDEX_PARAM CLOB; ";
                registration = IntStream.rangeClosed(0, value.length() / 32766).mapToObj(index -> value.substring(index * 32766, Math.min(value.length(), (index + 1) * 32766))).map(segment -> {
                    int post;
                    int pre;
                    for (pre = 0; pre < ((String)segment).length() && ((String)segment).charAt(pre) == '\''; ++pre) {
                    }
                    if (pre % 2 == 1) {
                        segment = ((String)segment).substring(1);
                    }
                    for (post = 0; post < ((String)segment).length() && ((String)segment).charAt(((String)segment).length() - post - 1) == '\''; ++post) {
                    }
                    if (post % 2 == 1) {
                        segment = (String)segment + "'";
                    }
                    return segment;
                }).filter(segment -> !segment.isEmpty()).map(segment -> "INDEX_PARAM := INDEX_PARAM || '" + segment + "'; ").collect(Collectors.joining("", "INDEX_PARAM := NULL; ", "DBMS_XMLINDEX.REGISTERPARAMETER('" + name + "', INDEX_PARAM); "));
            } else {
                declaration = "";
                registration = "DBMS_XMLINDEX.REGISTERPARAMETER('" + name + "', '" + value + "'); ";
            }
            return declaration + "BEGIN " + (String)registration + "EXCEPTION WHEN OTHERS THEN DBMS_XMLINDEX.DROPPARAMETER('" + name + "'); " + (String)registration + "END;";
        }
    }
    ,
    JSON("CLOB NOT NULL CHECK (PAYLOAD IS JSON)", "?", 0){

        @Override
        List<String> afterCreateTable(String base) {
            return Collections.singletonList("CREATE MATERIALIZED VIEW LOG ON " + base + "_RAW WITH PRIMARY KEY");
        }

        @Override
        void makeView(String base, String name, List<List<PathElement>> paths, List<String> directColumns, Map<List<PathElement>, Class<?>> properties, Map<List<PathElement>, String> columns, List<String> ddl, Map<String, Integer> viewIndices, Map<String, Map<String, String>> viewMeta, Map<String, String> objects, Function<Set<String>, Map<String, String>> namespacePrefixResolver, Function<Class<?>, String> typeResolver) {
            String root = "$" + (String)(paths.isEmpty() ? "" : "." + paths.stream().map(path -> PathElement.full((String)".", (Function)new OracleJsonStrictSyntaxTransformer(), (List)path, namespace -> "") + "[*]").collect(Collectors.joining(".")));
            String allColumns = Stream.concat(directColumns.stream(), properties.keySet().stream().map(columns::get)).collect(Collectors.joining(", "));
            Map<List, String> types = properties.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (String)typeResolver.apply((Class)entry.getValue())));
            String jsonColumns = properties.keySet().stream().map(path -> (String)columns.get(path) + " " + (String)types.get(path) + " PATH '" + PathElement.full((String)"$", (String)".", (Function)new OracleJsonStrictSyntaxTransformer(), (List)path, namespace -> "") + "' NULL ON EMPTY ERROR ON ERROR").collect(Collectors.joining(", "));
            ddl.add("CREATE MATERIALIZED VIEW " + name + " BUILD IMMEDIATE REFRESH FAST ON STATEMENT WITH PRIMARY KEY AS SELECT " + allColumns + " FROM " + base + "_RAW, JSON_TABLE(PAYLOAD, '" + root + "' COLUMNS (" + jsonColumns + "))");
            int index = 0;
            Stream[] streamArray = new Stream[3];
            streamArray[0] = Stream.of("ID, REVISION");
            streamArray[1] = directColumns.stream().filter(column -> Stream.of("ID", "REVISION", "DELETED", "PAYLOAD").noneMatch(column::equals));
            streamArray[2] = properties.keySet().stream().map(columns::get).sorted();
            for (String column2 : Stream.of(streamArray).flatMap(Function.identity()).collect(Collectors.toList())) {
                ddl.add("CREATE INDEX " + name + "_IDX" + index++ + " ON " + name + " (" + column2 + ")");
            }
            objects.put(name, "MATERIALIZED VIEW");
            viewMeta.put(name, properties.keySet().stream().collect(Collectors.toMap(path -> PathElement.full((String)"$", (String)".", (Function)new OracleJsonStrictSyntaxTransformer(), Stream.concat(paths.stream().flatMap(Collection::stream), path.stream()).collect(Collectors.toList()), namespace -> ""), columns::get)));
        }
    };

    private final String payloadType;
    private final String valueVariable;
    private final int roots;

    private OracleSqlEmitter(String payloadType, String valueVariable, int roots) {
        this.payloadType = payloadType;
        this.valueVariable = valueVariable;
        this.roots = roots;
    }

    String getPayloadType() {
        return this.payloadType;
    }

    String getValueVariable() {
        return this.valueVariable;
    }

    int getRoots() {
        return this.roots;
    }

    abstract List<String> afterCreateTable(String var1);

    abstract void makeView(String var1, String var2, List<List<PathElement>> var3, List<String> var4, Map<List<PathElement>, Class<?>> var5, Map<List<PathElement>, String> var6, List<String> var7, Map<String, Integer> var8, Map<String, Map<String, String>> var9, Map<String, String> var10, Function<Set<String>, Map<String, String>> var11, Function<Class<?>, String> var12);
}

