/*
 * Decompiled with CFR 0.152.
 */
package no.skatteetaten.fastsetting.formueinntekt.felles.feed.reader;

import java.util.Map;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import no.skatteetaten.fastsetting.formueinntekt.felles.feed.api.FeedConsumer;
import no.skatteetaten.fastsetting.formueinntekt.felles.feed.api.FeedEndpoint;
import no.skatteetaten.fastsetting.formueinntekt.felles.feed.api.FeedEntry;
import no.skatteetaten.fastsetting.formueinntekt.felles.feed.api.FeedPage;
import no.skatteetaten.fastsetting.formueinntekt.felles.feed.api.FeedRepository;
import no.skatteetaten.fastsetting.formueinntekt.felles.feed.reader.FeedReader;

public enum FeedContinuation {
    REPEATING{

        @Override
        <LOCATION, ENTRY extends FeedEntry<LOCATION>, PAGE extends FeedPage<LOCATION, ENTRY>, POINTER, TRANSACTION> Optional<LOCATION> resume(FeedEndpoint<LOCATION, ENTRY, PAGE> endpoint, FeedRepository<LOCATION, POINTER, TRANSACTION> repository, POINTER pointer, FeedConsumer<? super LOCATION, ? super ENTRY, ? extends TRANSACTION> consumer, BooleanSupplier isAlive) throws InterruptedException {
            Map locations = repository.read(pointer);
            if (locations.isEmpty()) {
                return Optional.empty();
            }
            if (locations.containsKey(FeedRepository.Category.UPPER)) {
                return FeedReader.doReadBackward(endpoint, repository, locations.get(FeedRepository.Category.LOWER), locations.get(FeedRepository.Category.CURRENT), locations.get(FeedRepository.Category.UPPER), pointer, consumer, isAlive, locations);
            }
            return Optional.of(locations.get(FeedRepository.Category.CURRENT));
        }
    }
    ,
    RESUMING{

        @Override
        <LOCATION, ENTRY extends FeedEntry<LOCATION>, PAGE extends FeedPage<LOCATION, ENTRY>, POINTER, TRANSACTION> Optional<LOCATION> resume(FeedEndpoint<LOCATION, ENTRY, PAGE> endpoint, FeedRepository<LOCATION, POINTER, TRANSACTION> repository, POINTER pointer, FeedConsumer<? super LOCATION, ? super ENTRY, ? extends TRANSACTION> consumer, BooleanSupplier isAlive) throws InterruptedException {
            Map locations = repository.read(pointer);
            if (locations.isEmpty()) {
                return Optional.empty();
            }
            if (locations.containsKey(FeedRepository.Category.UPPER)) {
                FeedReader.doReadBackward(endpoint, repository, locations.get(FeedRepository.Category.LOWER), null, locations.get(FeedRepository.Category.CURRENT), pointer, consumer, isAlive, locations);
                return Optional.of(locations.get(FeedRepository.Category.UPPER));
            }
            return Optional.of(locations.get(FeedRepository.Category.CURRENT));
        }
    }
    ,
    FAILING{

        @Override
        <LOCATION, ENTRY extends FeedEntry<LOCATION>, PAGE extends FeedPage<LOCATION, ENTRY>, POINTER, TRANSACTION> Optional<LOCATION> resume(FeedEndpoint<LOCATION, ENTRY, PAGE> endpoint, FeedRepository<LOCATION, POINTER, TRANSACTION> repository, POINTER pointer, FeedConsumer<? super LOCATION, ? super ENTRY, ? extends TRANSACTION> consumer, BooleanSupplier isAlive) {
            Map locations = repository.read(pointer);
            if (locations.isEmpty()) {
                return Optional.empty();
            }
            if (locations.size() == 1 && locations.containsKey(FeedRepository.Category.CURRENT)) {
                return Optional.of(locations.get(FeedRepository.Category.CURRENT));
            }
            throw new IllegalStateException("Cannot resume feed for " + pointer + " in reverse direction");
        }
    };


    abstract <LOCATION, ENTRY extends FeedEntry<LOCATION>, PAGE extends FeedPage<LOCATION, ENTRY>, POINTER, TRANSACTION> Optional<LOCATION> resume(FeedEndpoint<LOCATION, ENTRY, PAGE> var1, FeedRepository<LOCATION, POINTER, TRANSACTION> var2, POINTER var3, FeedConsumer<? super LOCATION, ? super ENTRY, ? extends TRANSACTION> var4, BooleanSupplier var5) throws InterruptedException;
}

