/*
 * Decompiled with CFR 0.152.
 */
package no.skatteetaten.fastsetting.formueinntekt.felles.feed.reader;

import java.util.Optional;
import java.util.function.BooleanSupplier;
import no.skatteetaten.fastsetting.formueinntekt.felles.feed.api.FeedEndpoint;
import no.skatteetaten.fastsetting.formueinntekt.felles.feed.api.FeedEntry;
import no.skatteetaten.fastsetting.formueinntekt.felles.feed.api.FeedPage;

enum FeedIterator {
    FORWARD(FeedEndpoint::getFirstPage, FeedEndpoint::getFirstPage, FeedPage::getNextLocation, PageFinalizer::forward),
    BACKWARD(FeedEndpoint::getLastPage, FeedEndpoint::getLastPage, FeedPage::getPreviousLocation, PageFinalizer::backward);

    private final PageBoundInitializer boundInitializer;
    private final PageOpenInitializer openInitializer;
    private final PageForwarder forwarder;
    private final PageFinalizer finalizer;

    private FeedIterator(PageBoundInitializer boundInitializer, PageOpenInitializer openInitializer, PageForwarder forwarder, PageFinalizer finalizer) {
        this.boundInitializer = boundInitializer;
        this.openInitializer = openInitializer;
        this.forwarder = forwarder;
        this.finalizer = finalizer;
    }

    <LOCATION, ENTRY extends FeedEntry<LOCATION>, PAGE extends FeedPage<LOCATION, ENTRY>> Optional<LOCATION> read(FeedEndpoint<LOCATION, ENTRY, PAGE> endpoint, LOCATION from, LOCATION to, PageCallback<? super LOCATION, ? super ENTRY, ? super PAGE> callback, BooleanSupplier isAlive) throws InterruptedException {
        Optional<PAGE> current;
        if (from != null) {
            Optional<Object> optional = current = to == null ? endpoint.getPage(from) : endpoint.getPage(from, to);
            if (current.isEmpty()) {
                return Optional.of(from);
            }
        } else if (to != null) {
            current = this.boundInitializer.apply(endpoint, to);
            if (current.isEmpty()) {
                return Optional.of(to);
            }
        } else {
            current = this.openInitializer.apply(endpoint);
        }
        Optional<Object> next = current;
        Optional<Object> origin = current.map(FeedPage::getLocation);
        while (next.isPresent()) {
            if (!isAlive.getAsBoolean()) {
                throw new InterruptedException();
            }
            current = next;
            next = current.filter(page -> callback.accept(page, origin.orElse(null))).flatMap(this.forwarder::apply).filter(location -> !location.equals(to)).flatMap(arg_0 -> endpoint.getPage(arg_0));
        }
        return this.finalizer.apply(origin.orElse(null), current.map(page -> this.forwarder.apply(page).orElse(page.getLocation())).orElse(null));
    }

    @FunctionalInterface
    private static interface PageBoundInitializer {
        public <LOCATION, ENTRY extends FeedEntry<LOCATION>, PAGE extends FeedPage<LOCATION, ENTRY>> Optional<PAGE> apply(FeedEndpoint<LOCATION, ENTRY, PAGE> var1, LOCATION var2);
    }

    @FunctionalInterface
    private static interface PageOpenInitializer {
        public <LOCATION, ENTRY extends FeedEntry<LOCATION>, PAGE extends FeedPage<LOCATION, ENTRY>> Optional<PAGE> apply(FeedEndpoint<LOCATION, ENTRY, PAGE> var1);
    }

    @FunctionalInterface
    private static interface PageForwarder {
        public <LOCATION, PAGE extends FeedPage<LOCATION, ?>> Optional<LOCATION> apply(PAGE var1);
    }

    @FunctionalInterface
    private static interface PageFinalizer {
        public <LOCATION> Optional<LOCATION> apply(LOCATION var1, LOCATION var2);

        public static <LOCATION> Optional<LOCATION> forward(LOCATION origin, LOCATION last) {
            return Optional.ofNullable(last);
        }

        public static <LOCATION> Optional<LOCATION> backward(LOCATION origin, LOCATION last) {
            return Optional.ofNullable(origin);
        }
    }

    @FunctionalInterface
    static interface PageCallback<LOCATION, ENTRY extends FeedEntry<LOCATION>, PAGE extends FeedPage<LOCATION, ENTRY>> {
        public boolean accept(PAGE var1, LOCATION var2);
    }
}

