/*
 * Decompiled with CFR 0.152.
 */
package no.skatteetaten.fastsetting.formueinntekt.felles.feed.reader;

import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import no.skatteetaten.fastsetting.formueinntekt.felles.feed.api.FeedConsumer;
import no.skatteetaten.fastsetting.formueinntekt.felles.feed.api.FeedEndpoint;
import no.skatteetaten.fastsetting.formueinntekt.felles.feed.api.FeedEntry;
import no.skatteetaten.fastsetting.formueinntekt.felles.feed.api.FeedPage;
import no.skatteetaten.fastsetting.formueinntekt.felles.feed.api.FeedProcessor;
import no.skatteetaten.fastsetting.formueinntekt.felles.feed.api.FeedRepository;
import no.skatteetaten.fastsetting.formueinntekt.felles.feed.reader.FeedContinuation;
import no.skatteetaten.fastsetting.formueinntekt.felles.feed.reader.FeedReader;

public class FeedManager<LOCATION, ENTRY extends FeedEntry<LOCATION>, PAGE extends FeedPage<LOCATION, ENTRY>, POINTER, TRANSACTION>
extends FeedProcessor.Simple<POINTER> {
    private final FeedEndpoint<LOCATION, ENTRY, PAGE> endpoint;
    private final FeedReader reader;
    private final FeedContinuation continuation;
    private final Predicate<Throwable> onError;
    private final long pause;
    private final TimeUnit timeUnit;
    private final FeedRepository<LOCATION, POINTER, TRANSACTION> repository;
    private final FeedConsumer<? super LOCATION, ? super ENTRY, TRANSACTION> consumer;

    public FeedManager(POINTER pointer, Executor executor, FeedEndpoint<LOCATION, ENTRY, PAGE> endpoint, FeedReader reader, FeedContinuation continuation, Predicate<Throwable> onError, long pause, TimeUnit timeUnit, FeedRepository<LOCATION, POINTER, TRANSACTION> repository, FeedConsumer<? super LOCATION, ? super ENTRY, TRANSACTION> consumer) {
        super(pointer, executor);
        this.endpoint = endpoint;
        this.reader = reader;
        this.continuation = continuation;
        this.onError = onError;
        this.pause = pause;
        this.timeUnit = timeUnit;
        this.repository = repository;
        this.consumer = consumer;
    }

    protected void doStart(BooleanSupplier isAlive) {
        this.reader.run(this.endpoint, this.repository, this.continuation, this.pointer, this.pause, this.timeUnit, this.consumer, () -> {
            this.lastError = null;
        }, throwable -> {
            this.lastError = throwable;
            return this.onError.test((Throwable)throwable);
        }, isAlive);
    }

    protected void onReset() {
        this.repository.delete(this.pointer, arg_0 -> this.consumer.onReset(arg_0));
    }

    protected void onComplete() {
        Optional location = this.endpoint.getLastLocation();
        if (location.isPresent()) {
            this.repository.updateCurrent(this.pointer, location.get(), transaction -> this.consumer.onComplete(transaction, location.get()));
        } else {
            this.repository.delete(this.pointer, transaction -> this.consumer.onComplete(transaction, null));
        }
    }
}

