/*
 * Decompiled with CFR 0.152.
 */
package no.skatteetaten.fastsetting.formueinntekt.felles.feed.reader;

import java.lang.invoke.LambdaMetafactory;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import no.skatteetaten.fastsetting.formueinntekt.felles.feed.api.FeedConsumer;
import no.skatteetaten.fastsetting.formueinntekt.felles.feed.api.FeedDirection;
import no.skatteetaten.fastsetting.formueinntekt.felles.feed.api.FeedEndpoint;
import no.skatteetaten.fastsetting.formueinntekt.felles.feed.api.FeedEntry;
import no.skatteetaten.fastsetting.formueinntekt.felles.feed.api.FeedPage;
import no.skatteetaten.fastsetting.formueinntekt.felles.feed.api.FeedRepository;
import no.skatteetaten.fastsetting.formueinntekt.felles.feed.reader.FeedContinuation;
import no.skatteetaten.fastsetting.formueinntekt.felles.feed.reader.FeedIterator;

public enum FeedReader {
    FORWARD{

        @Override
        <LOCATION, ENTRY extends FeedEntry<LOCATION>, PAGE extends FeedPage<LOCATION, ENTRY>, POINTER, TRANSACTION> Optional<LOCATION> apply(FeedEndpoint<LOCATION, ENTRY, PAGE> endpoint, FeedRepository<LOCATION, POINTER, TRANSACTION> repository, POINTER pointer, LOCATION location, FeedConsumer<? super LOCATION, ? super ENTRY, ? extends TRANSACTION> consumer, BooleanSupplier isAlive) throws InterruptedException {
            return FeedReader.doReadForward(endpoint, repository, location, pointer, consumer, isAlive);
        }
    }
    ,
    BACKWARD{

        @Override
        <LOCATION, ENTRY extends FeedEntry<LOCATION>, PAGE extends FeedPage<LOCATION, ENTRY>, POINTER, TRANSACTION> Optional<LOCATION> apply(FeedEndpoint<LOCATION, ENTRY, PAGE> endpoint, FeedRepository<LOCATION, POINTER, TRANSACTION> repository, POINTER pointer, LOCATION location, FeedConsumer<? super LOCATION, ? super ENTRY, ? extends TRANSACTION> consumer, BooleanSupplier isAlive) throws InterruptedException {
            LOCATION previous;
            Optional<LOCATION> current;
            while ((location = (current = FeedReader.doReadBackward(endpoint, repository, location, null, null, pointer, consumer, isAlive, location == null ? Map.of() : Map.of(FeedRepository.Category.CURRENT, location))).filter(arg_0 -> 2.lambda$apply$0(previous = location, arg_0)).orElse(null)) != null) {
            }
            return current;
        }

        private static /* synthetic */ boolean lambda$apply$0(Object previous, Object limit) {
            return previous == null || !previous.equals(limit);
        }
    }
    ,
    BACKWARD_INITIAL_ONLY{

        @Override
        <LOCATION, ENTRY extends FeedEntry<LOCATION>, PAGE extends FeedPage<LOCATION, ENTRY>, POINTER, TRANSACTION> Optional<LOCATION> apply(FeedEndpoint<LOCATION, ENTRY, PAGE> endpoint, FeedRepository<LOCATION, POINTER, TRANSACTION> repository, POINTER pointer, LOCATION location, FeedConsumer<? super LOCATION, ? super ENTRY, ? extends TRANSACTION> consumer, BooleanSupplier isAlive) throws InterruptedException {
            if (location == null) {
                location = FeedReader.doReadBackward(endpoint, repository, null, null, null, pointer, consumer, isAlive, Map.of()).orElse(null);
            }
            if (location != null) {
                return FeedReader.doReadForward(endpoint, repository, location, pointer, consumer, isAlive);
            }
            return Optional.empty();
        }
    }
    ,
    BACKWARD_ONCE_ONLY{

        @Override
        <LOCATION, ENTRY extends FeedEntry<LOCATION>, PAGE extends FeedPage<LOCATION, ENTRY>, POINTER, TRANSACTION> Optional<LOCATION> apply(FeedEndpoint<LOCATION, ENTRY, PAGE> endpoint, FeedRepository<LOCATION, POINTER, TRANSACTION> repository, POINTER pointer, LOCATION location, FeedConsumer<? super LOCATION, ? super ENTRY, ? extends TRANSACTION> consumer, BooleanSupplier isAlive) throws InterruptedException {
            if (location == null) {
                return FeedReader.doReadBackward(endpoint, repository, null, null, null, pointer, consumer, isAlive, Map.of());
            }
            return Optional.of(location);
        }
    };


    abstract <LOCATION, ENTRY extends FeedEntry<LOCATION>, PAGE extends FeedPage<LOCATION, ENTRY>, POINTER, TRANSACTION> Optional<LOCATION> apply(FeedEndpoint<LOCATION, ENTRY, PAGE> var1, FeedRepository<LOCATION, POINTER, TRANSACTION> var2, POINTER var3, LOCATION var4, FeedConsumer<? super LOCATION, ? super ENTRY, ? extends TRANSACTION> var5, BooleanSupplier var6) throws InterruptedException;

    <LOCATION, ENTRY extends FeedEntry<LOCATION>, PAGE extends FeedPage<LOCATION, ENTRY>, POINTER, TRANSACTION> void run(FeedEndpoint<LOCATION, ENTRY, PAGE> endpoint, FeedRepository<LOCATION, POINTER, TRANSACTION> repository, FeedContinuation continuation, POINTER pointer, long pause, TimeUnit timeUnit, FeedConsumer<? super LOCATION, ? super ENTRY, TRANSACTION> consumer, Runnable onStarted, Predicate<Throwable> onError, BooleanSupplier isAlive) {
        while (isAlive.getAsBoolean()) {
            try {
                consumer.onStart();
                onStarted.run();
                consumer.onSuccess(this.apply(endpoint, repository, pointer, continuation.resume(endpoint, repository, pointer, consumer, isAlive).orElse(null), consumer, isAlive).orElse(null));
                timeUnit.sleep(pause);
            }
            catch (InterruptedException ignored) {
                break;
            }
            catch (Throwable throwable) {
                try {
                    consumer.onError(throwable);
                }
                catch (Throwable chained) {
                    throwable.addSuppressed(chained);
                }
                try {
                    if (onError.test(throwable)) {
                        try {
                            timeUnit.sleep(pause);
                            continue;
                        }
                        catch (InterruptedException ignored) {
                            break;
                        }
                    }
                    consumer.onFailure(throwable);
                }
                catch (Throwable ignored) {}
                break;
            }
        }
    }

    static <LOCATION, ENTRY extends FeedEntry<LOCATION>, PAGE extends FeedPage<LOCATION, ENTRY>, POINTER, TRANSACTION> Optional<LOCATION> doReadForward(FeedEndpoint<LOCATION, ENTRY, PAGE> endpoint, FeedRepository<LOCATION, POINTER, TRANSACTION> repository, LOCATION location, POINTER pointer, FeedConsumer<? super LOCATION, ? super ENTRY, ? extends TRANSACTION> consumer, BooleanSupplier isAlive) throws InterruptedException {
        class State {
            private LOCATION previous;
            final /* synthetic */ Object val$location;

            State(Object object) {
                this.val$location = object;
                this.previous = this.val$location;
            }
        }
        State state = new State(location);
        consumer.onSeries(location, FeedDirection.FORWARD);
        return FeedIterator.FORWARD.read(endpoint, location, null, (page, origin) -> {
            consumer.onPage(transaction -> {
                Object previous = state.previous;
                repository.transitCurrent(transaction, pointer, previous, page.getNextLocation().orElseGet(() -> ((FeedPage)page).getLocation()));
            }, page.getLocation(), FeedDirection.FORWARD, !page.hasNextLocation(), FeedReader.safeDownCast(location != null && page.hasLocation(location) ? page.getEntriesAfter(location) : page.getEntries()));
            state.previous = page.getNextLocation().orElseGet(() -> ((FeedPage)page).getLocation());
            return true;
        }, isAlive);
    }

    static <LOCATION, ENTRY extends FeedEntry<LOCATION>, PAGE extends FeedPage<LOCATION, ENTRY>, POINTER, TRANSACTION> Optional<LOCATION> doReadBackward(FeedEndpoint<LOCATION, ENTRY, PAGE> endpoint, FeedRepository<LOCATION, POINTER, TRANSACTION> repository, LOCATION lower, final LOCATION continuation, LOCATION upper, POINTER pointer, FeedConsumer<? super LOCATION, ? super ENTRY, ? extends TRANSACTION> consumer, BooleanSupplier isAlive, final Map<FeedRepository.Category, LOCATION> locations) throws InterruptedException {
        class State {
            private boolean recovery;
            private Map<FeedRepository.Category, LOCATION> previous;

            State() {
                this.recovery = continuation != null;
                this.previous = locations;
            }
        }
        State state = new State();
        consumer.onSeries(upper, state.recovery ? FeedDirection.RECOVERY : FeedDirection.BACKWARD);
        return FeedIterator.BACKWARD.read(endpoint, upper, lower, (arg_0, arg_1) -> FeedReader.lambda$doReadBackward$4(continuation, state, consumer, upper, lower, repository, pointer, arg_0, arg_1), isAlive).map(location -> upper == null ? location : upper);
    }

    private static <ENTRY> List<ENTRY> safeDownCast(List<? extends ENTRY> entries) {
        return entries;
    }

    /*
     * Unable to fully structure code
     */
    private static /* synthetic */ boolean lambda$doReadBackward$4(Object continuation, 2State state, FeedConsumer consumer, Object upper, Object lower, FeedRepository repository, Object pointer, FeedPage page, Object origin) {
        if (continuation == null) ** GOTO lbl-1000
        if (page.getPageLocation().map((Function<Object, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, equals(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Boolean;)((Object)continuation)).orElse(false).booleanValue()) {
            state.recovery = false;
            appliedUpper = null;
            consumer.onSeries(upper, FeedDirection.BACKWARD);
        } else if (continuation != null && page.hasLocation(continuation)) {
            consumer.onPage((Consumer<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$doReadBackward$2(java.lang.Object ), (Ljava/lang/Object;)V)(), page.getLocation(), FeedDirection.RECOVERY, false, FeedReader.safeDownCast(upper != null && page.hasLocation(upper) != false ? page.getEntriesBetween(continuation, upper) : page.getEntriesAfter(continuation)));
            state.recovery = false;
            appliedUpper = continuation;
            consumer.onSeries(upper, FeedDirection.BACKWARD);
        } else {
            appliedUpper = upper != null && page.hasLocation(upper) != false ? upper : null;
        }
        if (lower == null) ** GOTO lbl-1000
        if (page.getPageLocation().map((Function<Object, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, equals(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Boolean;)((Object)lower)).orElse(false).booleanValue()) {
            completed = true;
            entries = page.getEntries();
        } else if (lower != null && page.hasLocation(lower)) {
            completed = true;
            entries = appliedUpper == null ? page.getEntriesAfter(lower) : page.getEntriesBetween(lower, appliedUpper);
        } else {
            completed = lower == null ? !page.hasPreviousLocation() : page.getPreviousLocation().map((Function<Object, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, equals(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Boolean;)((Object)lower)).orElse(true);
            entries = appliedUpper == null ? page.getEntries() : page.getEntriesUntil(appliedUpper);
        }
        recovery = state.recovery;
        previous = state.previous;
        consumer.onPage((Consumer<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$doReadBackward$3(boolean no.skatteetaten.fastsetting.formueinntekt.felles.feed.api.FeedRepository java.lang.Object java.util.Map java.lang.Object java.lang.Object boolean java.lang.Object no.skatteetaten.fastsetting.formueinntekt.felles.feed.api.FeedPage java.lang.Object ), (Ljava/lang/Object;)V)((boolean)completed, (FeedRepository)repository, (Object)pointer, previous, (Object)upper, (Object)origin, (boolean)recovery, (Object)lower, (FeedPage)page), page.getLocation(), recovery != false ? FeedDirection.RECOVERY : FeedDirection.BACKWARD, completed, FeedReader.safeDownCast(entries));
        if (completed) {
            return false;
        }
        state.previous = new EnumMap<FeedRepository.Category, Object>(Collections.singletonMap(FeedRepository.Category.CURRENT, page.getPreviousLocation().orElse(lower)));
        if (lower != null) {
            state.previous.put(FeedRepository.Category.LOWER, lower);
        }
        if (upper != null || origin != null) {
            state.previous.put(FeedRepository.Category.UPPER, upper == null ? origin : upper);
        }
        return true;
    }

    private static /* synthetic */ void lambda$doReadBackward$3(boolean completed, FeedRepository repository, Object pointer, Map previous, Object upper, Object origin, boolean recovery, Object lower, FeedPage page, Object transaction) {
        if (completed) {
            repository.transit(transaction, pointer, previous, Map.of(FeedRepository.Category.CURRENT, upper == null ? origin : upper));
        } else if (!recovery) {
            repository.transitAll(transaction, pointer, previous.get(FeedRepository.Category.LOWER), previous.get(FeedRepository.Category.CURRENT), previous.get(FeedRepository.Category.UPPER), lower, page.getPreviousLocation().orElse(lower), upper == null ? origin : upper);
        }
    }

    private static /* synthetic */ void lambda$doReadBackward$2(Object transaction) {
    }
}

