/*
 * Decompiled with CFR 0.152.
 */
package no.skatteetaten.fastsetting.formueinntekt.felles.task.processor.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.sql.DataSource;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.processor.TaskProcessor;

public class JdbcPersistentTaskProcessor
implements TaskProcessor {
    public static final String CHANGE_LOG = "liquibase/taskAccessChangeLog.xml";
    private final TaskProcessor delegate;
    protected final DataSource dataSource;

    public JdbcPersistentTaskProcessor(TaskProcessor delegate, DataSource dataSource) {
        this.delegate = delegate;
        this.dataSource = dataSource;
    }

    public synchronized boolean start(long timeout, TimeUnit timeUnit) throws TimeoutException, InterruptedException {
        if (this.delegate.start(timeout, timeUnit)) {
            this.write(TaskProcessor.Activation.ACTIVE);
            return true;
        }
        return false;
    }

    public synchronized boolean stop(long timeout, TimeUnit timeUnit) throws TimeoutException, InterruptedException {
        if (this.delegate.stop(timeout, timeUnit)) {
            this.write(TaskProcessor.Activation.INACTIVE);
            return true;
        }
        return false;
    }

    public boolean resume() {
        return this.delegate.resume();
    }

    public boolean isActive() {
        return this.delegate.isActive();
    }

    public String getTopic() {
        return this.delegate.getTopic();
    }

    /*
     * Exception decompiling
     */
    public Optional<TaskProcessor.Activation> findActivation() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean initialize(long timeout, TimeUnit timeUnit) throws TimeoutException, InterruptedException {
        Optional<TaskProcessor.Activation> activation = this.findActivation();
        if (activation.isPresent()) {
            if (activation.get() == TaskProcessor.Activation.ACTIVE) {
                return this.delegate.initialize(timeout, timeUnit);
            }
            return true;
        }
        return false;
    }

    public boolean shutdown(long timeout, TimeUnit timeUnit) throws TimeoutException, InterruptedException {
        return this.delegate.shutdown(timeout, timeUnit);
    }

    protected void write(TaskProcessor.Activation activation) {
        String topic = this.getTopic();
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement ps = conn.prepareStatement("MERGE INTO TASK_ACTIVATION USING (VALUES ?) AS TARGET (TOPIC) ON TASK_ACTIVATION.TOPIC = TARGET.TOPIC WHEN MATCHED THEN UPDATE SET ACTIVE = ? WHEN NOT MATCHED THEN INSERT (TOPIC, ACTIVE) VALUES (?, ?)");){
            ps.setString(1, topic);
            ps.setBoolean(2, activation == TaskProcessor.Activation.ACTIVE);
            ps.setString(3, topic);
            ps.setBoolean(4, activation == TaskProcessor.Activation.ACTIVE);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }
}

