/*
 * Decompiled with CFR 0.152.
 */
package no.skatteetaten.fastsetting.formueinntekt.felles.task.processor.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.function.BiConsumer;
import javax.sql.DataSource;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.api.TaskState;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.processor.ProcessorNotifier;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.processor.TaskProcessor;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.processor.jdbc.TaskChangeEvent;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.datasource.OracleDataSource;
import oracle.jdbc.dcn.DatabaseChangeRegistration;
import oracle.jdbc.dcn.TableChangeDescription;

public class OracleProcessorNotifier
implements ProcessorNotifier {
    private final DataSource dataSource;
    private final Collection<? extends TaskProcessor> processors;
    private final BiConsumer<TaskProcessor, TaskChangeEvent> callback;
    private final String host;
    private final int port;
    private List<DatabaseChangeRegistration> registrations;

    public OracleProcessorNotifier(DataSource dataSource, Collection<? extends TaskProcessor> processors, BiConsumer<TaskProcessor, TaskChangeEvent> callback) {
        this.dataSource = OracleProcessorNotifier.checked(dataSource);
        this.processors = processors;
        this.callback = callback;
        this.host = null;
        this.port = 0;
    }

    public OracleProcessorNotifier(DataSource dataSource, Collection<? extends TaskProcessor> processors, BiConsumer<TaskProcessor, TaskChangeEvent> callback, String host, int port) {
        this.dataSource = OracleProcessorNotifier.checked(dataSource);
        this.processors = processors;
        this.callback = callback;
        this.host = host;
        this.port = port;
    }

    private static DataSource checked(DataSource dataSource) {
        try {
            if (!dataSource.isWrapperFor(OracleDataSource.class)) {
                throw new IllegalArgumentException("Not a Oracle datasource: " + dataSource);
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
        return dataSource;
    }

    public synchronized boolean isActive() {
        return this.registrations != null;
    }

    public synchronized boolean start() {
        if (this.registrations != null) {
            return false;
        }
        Properties properties = new Properties();
        properties.setProperty("DCN_IGNORE_INSERTOP", "false");
        properties.setProperty("DCN_IGNORE_UPDATEOP", "false");
        properties.setProperty("DCN_IGNORE_DELETEOP", "true");
        properties.setProperty("DCN_QUERY_CHANGE_NOTIFICATION", "true");
        if (this.host != null) {
            properties.setProperty("NTF_LOCAL_HOST", this.host);
        }
        if (this.port > 0) {
            properties.setProperty("NTF_LOCAL_TCP_PORT", Integer.toString(this.port));
        }
        ArrayList<DatabaseChangeRegistration> registrations = new ArrayList<DatabaseChangeRegistration>();
        try (Connection conn = this.dataSource.getConnection();){
            for (TaskProcessor taskProcessor : this.processors) {
                DatabaseChangeRegistration registration = conn.unwrap(OracleConnection.class).registerDatabaseChangeNotification(properties);
                registrations.add(registration);
                registration.addListener(event -> {
                    boolean task = false;
                    boolean activation = false;
                    block8: for (TableChangeDescription description : event.getTableChangeDescription()) {
                        switch (description.getTableName()) {
                            case "TASK": {
                                task = true;
                                continue block8;
                            }
                            case "TASK_ACTIVATION": {
                                activation = true;
                            }
                        }
                    }
                    if (task) {
                        this.callback.accept(processor, TaskChangeEvent.WORK);
                    }
                    if (activation) {
                        this.callback.accept(processor, TaskChangeEvent.ACTIVATION);
                    }
                });
                try (OraclePreparedStatement ps = conn.prepareStatement("SELECT SEQUENCE FROM TASK WHERE TOPIC = ? AND STATE = ?").unwrap(OraclePreparedStatement.class);){
                    ps.setDatabaseChangeRegistration(registration);
                    ps.setString(1, taskProcessor.getTopic());
                    ps.setInt(2, TaskState.ACTIVE.ordinal());
                    ps.executeQuery().close();
                }
                ps = conn.prepareStatement("SELECT ACTIVE FROM TASK_ACTIVATION WHERE TOPIC = ?").unwrap(OraclePreparedStatement.class);
                try {
                    ps.setDatabaseChangeRegistration(registration);
                    ps.setString(1, taskProcessor.getTopic());
                    ps.executeQuery().close();
                }
                finally {
                    if (ps == null) continue;
                    ps.close();
                }
            }
        }
        catch (Exception e) {
            try {
                this.doStop(registrations);
            }
            catch (Exception suppressed) {
                e.addSuppressed(suppressed);
            }
            throw new IllegalStateException(e);
        }
        this.registrations = registrations;
        return true;
    }

    private void doStop(List<DatabaseChangeRegistration> registrations) {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        try (OracleConnection conn = this.dataSource.getConnection().unwrap(OracleConnection.class);){
            for (DatabaseChangeRegistration registration : registrations) {
                try {
                    conn.unregisterDatabaseChangeNotification(registration);
                }
                catch (Exception e) {
                    exceptions.add(e);
                }
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
        if (!exceptions.isEmpty()) {
            RuntimeException exception = new RuntimeException("Failed to unregister change notifications");
            exceptions.forEach(exception::addSuppressed);
            throw exception;
        }
    }

    public synchronized boolean stop() {
        if (this.registrations == null) {
            return false;
        }
        this.doStop(this.registrations);
        this.registrations = null;
        return true;
    }
}

