/*
 * Decompiled with CFR 0.152.
 */
package no.skatteetaten.fastsetting.formueinntekt.felles.task.processor.jdbc;

import com.impossibl.postgres.api.jdbc.PGConnection;
import com.impossibl.postgres.api.jdbc.PGNotificationListener;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.processor.ProcessorNotifier;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.processor.TaskProcessor;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.processor.jdbc.TaskChangeEvent;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.processor.jdbc.UnpooledConnectionSource;

public class PostgresNgProcessorNotifier
implements ProcessorNotifier,
PGNotificationListener {
    private final UnpooledConnectionSource<PGConnection> connectionSource;
    private final Runnable onDisconnect;
    private final Consumer<String> callback;
    private Connection connection;

    public PostgresNgProcessorNotifier(UnpooledConnectionSource<PGConnection> connectionSource, Runnable onDisconnect, Collection<? extends TaskProcessor> processors, BiConsumer<TaskProcessor, TaskChangeEvent> callback) {
        this.connectionSource = connectionSource;
        this.onDisconnect = onDisconnect;
        this.callback = TaskChangeEvent.postgres(processors, callback);
    }

    public synchronized boolean isActive() {
        try {
            return this.connection != null && !this.connection.isClosed();
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    public synchronized boolean start() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                return false;
            }
            PGConnection conn = this.connectionSource.get();
            try (Statement stmt = conn.createStatement();){
                stmt.execute("LISTEN task_notification");
            }
            conn.addNotificationListener(this.toString(), "task_notification", (PGNotificationListener)this);
            this.connection = conn;
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
        return true;
    }

    public synchronized boolean stop() {
        try {
            if (this.connection == null || this.connection.isClosed()) {
                return false;
            }
            this.connection.close();
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
        return true;
    }

    public void notification(int process, String channel, String payload) {
        this.callback.accept(payload);
    }

    public void closed() {
        this.onDisconnect.run();
    }
}

