/*
 * Decompiled with CFR 0.152.
 */
package no.skatteetaten.fastsetting.formueinntekt.felles.task.processor.jdbc;

import java.io.EOFException;
import java.net.SocketException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.processor.ProcessorNotifier;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.processor.TaskProcessor;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.processor.jdbc.TaskChangeEvent;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.processor.jdbc.UnpooledConnectionSource;
import org.postgresql.PGNotification;
import org.postgresql.jdbc.PgConnection;
import org.postgresql.util.PSQLException;

public class PostgresProcessorNotifier
implements ProcessorNotifier {
    private final UnpooledConnectionSource<PgConnection> connectionSource;
    private final Runnable onDisconnected;
    private final Executor executor;
    private final Consumer<String> callback;
    private PgConnection connection;

    public PostgresProcessorNotifier(UnpooledConnectionSource<PgConnection> connectionSource, Runnable onDisconnected, Executor executor, Collection<? extends TaskProcessor> processors, BiConsumer<TaskProcessor, TaskChangeEvent> callback) {
        this.connectionSource = connectionSource;
        this.onDisconnected = onDisconnected;
        this.executor = executor;
        this.callback = TaskChangeEvent.postgres(processors, callback);
    }

    public synchronized boolean isActive() {
        try {
            return this.connection != null && !this.connection.isClosed();
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    public synchronized boolean start() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                return false;
            }
            PgConnection conn = this.connectionSource.get();
            try (Statement stmt = conn.createStatement();){
                stmt.execute("LISTEN task_notification");
            }
            catch (Throwable t) {
                try {
                    conn.close();
                }
                catch (Throwable suppressed) {
                    t.addSuppressed(suppressed);
                }
                throw t;
            }
            this.connection = conn;
            this.executor.execute(() -> {
                block22: {
                    while (!Thread.interrupted() && !conn.isClosed()) {
                        PGNotification[] notifications = conn.getNotifications(0);
                        if (notifications == null) continue;
                        for (PGNotification notification : notifications) {
                            this.callback.accept(notification.getParameter());
                        }
                    }
                    try {
                        conn.close();
                    }
                    catch (Throwable notifications) {
                    }
                    finally {
                        this.onDisconnected.run();
                    }
                    catch (PSQLException e2222222222) {
                        block21: {
                            if (e2222222222.getCause() instanceof EOFException || e2222222222.getCause() instanceof SocketException) break block21;
                            throw new IllegalStateException(e2222222222);
                        }
                        try {
                            conn.close();
                        }
                        catch (Throwable e2222222222) {
                            break block22;
                        }
                        finally {
                            this.onDisconnected.run();
                        }
                    }
                    catch (SQLException e) {
                        throw new IllegalStateException(e);
                        {
                            catch (Throwable throwable) {
                                try {
                                    conn.close();
                                }
                                catch (Throwable throwable2) {
                                }
                                finally {
                                    this.onDisconnected.run();
                                }
                                throw throwable;
                            }
                        }
                    }
                }
            });
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
        return true;
    }

    public synchronized boolean stop() {
        try {
            if (this.connection == null || this.connection.isClosed()) {
                return false;
            }
            this.connection.close();
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
        return true;
    }
}

