/*
 * Decompiled with CFR 0.152.
 */
package no.skatteetaten.fastsetting.formueinntekt.felles.task.processor.jdbc;

import io.vertx.pgclient.pubsub.PgChannel;
import io.vertx.pgclient.pubsub.PgSubscriber;
import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.processor.ProcessorNotifier;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.processor.TaskProcessor;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.processor.jdbc.TaskChangeEvent;

public class PostgresVertxProcessorNotifier
implements ProcessorNotifier {
    private final PgSubscriber subscriber;
    private PgChannel channel;
    private final Runnable onDisconnect;
    private final Consumer<String> callback;
    private boolean paused = true;

    public PostgresVertxProcessorNotifier(PgSubscriber subscriber, Runnable onDisconnect, Collection<? extends TaskProcessor> processors, BiConsumer<TaskProcessor, TaskChangeEvent> callback) {
        this.subscriber = subscriber;
        this.onDisconnect = onDisconnect;
        this.callback = TaskChangeEvent.postgres(processors, callback);
    }

    public synchronized boolean isActive() {
        return !this.paused;
    }

    public synchronized boolean start() {
        if (!this.paused) {
            return false;
        }
        this.channel = this.subscriber.channel("task_notification").handler(this.callback::accept).endHandler(ignored -> {
            PostgresVertxProcessorNotifier postgresVertxProcessorNotifier = this;
            synchronized (postgresVertxProcessorNotifier) {
                this.paused = true;
            }
            this.onDisconnect.run();
        });
        this.paused = false;
        return true;
    }

    public synchronized boolean stop() {
        if (this.paused) {
            return false;
        }
        this.channel.pause();
        this.paused = true;
        return true;
    }
}

