/*
 * Decompiled with CFR 0.152.
 */
package com.loy.e.core.advice;

import com.loy.e.common.Constants;
import com.loy.e.common.annotation.Author;
import com.loy.e.common.properties.Settings;
import com.loy.e.common.vo.ErrorResponseData;
import com.loy.e.core.api.LogService;
import com.loy.e.core.api.SystemKeyService;
import com.loy.e.core.api.vo.ExceptionRecord;
import com.loy.e.core.exception.LoyException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.JDBCException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Author(author="Loy Fu", website="http://www.17jee.com", contact="qq\u7fa4 540553957")
@ControllerAdvice
public class ExceptionHandlerAdvice {
    protected final Log logger = LogFactory.getLog(ExceptionHandlerAdvice.class);
    @Autowired
    private MessageSource messageSource;
    @Autowired(required=false)
    private LogService logService;
    @Autowired(required=false)
    SystemKeyService systemKeyService;
    @Autowired
    Settings settings;

    @ResponseStatus(value=HttpStatus.OK)
    @ExceptionHandler(value={LoyException.class})
    @ResponseBody
    ErrorResponseData handleBadRequest(HttpServletRequest req, LoyException ex) {
        ErrorResponseData data = new ErrorResponseData();
        data.setErrorCode(ex.getErrorKey());
        String errorKey = ex.getErrorKey();
        String msg = this.messageSource.getMessage(errorKey, ex.getParams(), LocaleContextHolder.getLocale());
        data.setMsg(msg);
        return data;
    }

    @ResponseStatus(value=HttpStatus.OK)
    @ExceptionHandler(value={Throwable.class})
    @ResponseBody
    ErrorResponseData handleBadRequest(HttpServletRequest req, Throwable ex) {
        String exceptionName = ex.getClass().getName();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        String stackTraceMsg = sw.toString();
        ExceptionRecord exceptionRecord = new ExceptionRecord();
        exceptionRecord.setExceptionName(exceptionName);
        exceptionRecord.setStackTraceMsg(stackTraceMsg);
        exceptionRecord.setSystemCode(this.systemKeyService.getSystemCode());
        try {
            this.logService.exception(exceptionRecord);
        }
        catch (Throwable e) {
            this.logger.error((Object)"", e);
        }
        this.logger.error((Object)"", ex);
        ErrorResponseData data = new ErrorResponseData();
        String msg = null;
        Throwable cause = ex.getCause();
        String i18nSqlkey = null;
        if (cause != null && cause instanceof JDBCException) {
            List sqlErrorCodes;
            JDBCException jdbcException = (JDBCException)cause;
            int errorCode = jdbcException.getErrorCode();
            String code = String.valueOf(errorCode);
            if (ArrayUtils.contains((Object[])Constants.SQL_ERROR, (Object)code)) {
                i18nSqlkey = "sql.error." + code;
            } else if (this.settings != null && (sqlErrorCodes = this.settings.getSqlErrorCodes()) != null && sqlErrorCodes.contains(code)) {
                i18nSqlkey = "sql.error." + code;
            }
        }
        if (StringUtils.isEmpty(i18nSqlkey)) {
            i18nSqlkey = "system_error";
        }
        msg = this.messageSource.getMessage(i18nSqlkey, null, LocaleContextHolder.getLocale());
        data.setMsg(msg);
        return data;
    }
}

