/*
 * Decompiled with CFR 0.152.
 */
package com.loy.e.core.advice;

import com.loy.e.common.annotation.Author;
import com.loy.e.common.properties.Settings;
import com.loy.e.common.vo.ErrorResponseData;
import com.loy.e.common.vo.Response;
import com.loy.e.common.vo.SuccessResponse;
import com.loy.e.common.vo.SuccessResponseData;
import com.loy.e.core.converter.Converter;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.util.PatternMatchUtils;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@Author(author="Loy Fu", website="http://www.17jee.com", contact="qq\u7fa4 540553957")
@ControllerAdvice
public class JsonResponseBodyAdvice
implements ResponseBodyAdvice<Object> {
    protected final Log logger = LogFactory.getLog(JsonResponseBodyAdvice.class);
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private Settings settings;

    public Object beforeBodyWrite(Object object, MethodParameter methodParameter, MediaType mediaType, Class clazz, ServerHttpRequest request, ServerHttpResponse response) {
        String uri = request.getURI().toString();
        if (this.simpleMatch(this.settings.getIgnoreJsonResponseUrls(), uri)) {
            return object;
        }
        if (object instanceof Response) {
            return object;
        }
        if (object == null) {
            return SuccessResponse.newInstance();
        }
        com.loy.e.core.annotation.Converter converterAnnotation = (com.loy.e.core.annotation.Converter)methodParameter.getMethodAnnotation(com.loy.e.core.annotation.Converter.class);
        if (converterAnnotation != null) {
            Converter newInstance = null;
            Class<? extends Converter> converter = converterAnnotation.value();
            try {
                newInstance = converter.newInstance();
                object = newInstance.converter(object);
            }
            catch (IllegalAccessException | InstantiationException e) {
                this.logger.error((Object)"Data conversion errors", (Throwable)e);
                ErrorResponseData rrrorResponse = new ErrorResponseData();
                this.messageSource.getMessage("data_converter_error", null, LocaleContextHolder.getLocale());
                return rrrorResponse;
            }
        }
        SuccessResponseData data = new SuccessResponseData(object);
        return data;
    }

    public boolean supports(MethodParameter methodParameter, Class clazz) {
        return clazz.isAssignableFrom(MappingJackson2HttpMessageConverter.class);
    }

    private boolean simpleMatch(List<String> patterns, String str) {
        if (patterns != null) {
            for (String pattern : patterns) {
                if (!PatternMatchUtils.simpleMatch((String)("*" + pattern), (String)str)) continue;
                return true;
            }
        }
        return false;
    }
}

