/*
 * Decompiled with CFR 0.152.
 */
package com.loy.e.core.conf;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.loy.e.common.annotation.Author;
import com.loy.e.common.properties.Settings;
import com.loy.e.core.aop.LoyAspect;
import com.loy.e.core.web.dispatch.DefaultDispatchServlet;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.servlet.i18n.SessionLocaleResolver;

@Author(author="Loy Fu", website="http://www.17jee.com", contact="qq\u7fa4 540553957")
@Configuration
public class WebConfig
extends WebMvcConfigurerAdapter {
    protected final Log LOGGER = LogFactory.getLog(WebConfig.class);
    @Value(value="${spring.jackson.date-format}")
    private String dateFormat;
    @Autowired
    private Settings settings;

    public void extendMessageConverters(List<HttpMessageConverter<?>> converters) {
        for (HttpMessageConverter<?> c : converters) {
            if (!(c instanceof MappingJackson2HttpMessageConverter)) continue;
            MappingJackson2HttpMessageConverter mappingJackson2HttpMessageConverter = (MappingJackson2HttpMessageConverter)c;
            ObjectMapper objectMapper = mappingJackson2HttpMessageConverter.getObjectMapper();
            objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
            if (this.dateFormat == null) continue;
            SimpleDateFormat myDateFormat = new SimpleDateFormat(this.dateFormat);
            objectMapper.setDateFormat((DateFormat)myDateFormat);
        }
    }

    @Bean
    public SessionLocaleResolver localeResolver() {
        SessionLocaleResolver localeResolver = new SessionLocaleResolver();
        return localeResolver;
    }

    @Bean
    public MessageSource messageSource() {
        ReloadableResourceBundleMessageSource messageSource = new ReloadableResourceBundleMessageSource();
        HashSet<String> basenamesList = new HashSet<String>();
        String[] fileNames = new String[]{"classpath*:/i18n/*.properties", "classpath*:/i18n/**/*.properties"};
        PathMatchingResourcePatternResolver resourceLoader = new PathMatchingResourcePatternResolver();
        for (String file : fileNames) {
            try {
                Resource[] resources = resourceLoader.getResources(file);
                if (resources == null) continue;
                for (Resource resource : resources) {
                    String filename = resource.getURI().toString();
                    int begin = filename.indexOf("i18n");
                    filename = filename.substring(begin, filename.length());
                    filename = filename.replaceFirst(".properties", "");
                    filename = "classpath:" + filename.split("_")[0];
                    basenamesList.add(filename);
                }
            }
            catch (IOException e) {
                this.LOGGER.error((Object)"i18n resource error", (Throwable)e);
            }
        }
        String[] basenames = new String[basenamesList.size()];
        basenamesList.toArray(basenames);
        messageSource.setResourceLoader((ResourceLoader)resourceLoader);
        messageSource.setBasenames(basenames);
        messageSource.setCacheSeconds(5);
        messageSource.setDefaultEncoding("UTF-8");
        return messageSource;
    }

    @Bean
    public DefaultDispatchServlet dispatcherServlet() {
        DefaultDispatchServlet dispatchServlet = new DefaultDispatchServlet();
        return dispatchServlet;
    }

    @Bean
    public LoyAspect logAspect() {
        return new LoyAspect();
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        Map mappings = this.settings.getStaticMappings();
        if (mappings != null) {
            for (Map.Entry e : mappings.entrySet()) {
                List list = (List)e.getValue();
                if (list == null || list.isEmpty()) continue;
                String[] temp = new String[list.size()];
                list.toArray(temp);
                registry.addResourceHandler(new String[]{(String)e.getKey()}).addResourceLocations(temp);
            }
        }
    }
}

