/*
 * Decompiled with CFR 0.152.
 */
package com.loy.e.core.repository.impl;

import com.loy.e.common.annotation.Author;
import com.loy.e.common.properties.Settings;
import com.loy.e.core.entity.BaseEntity;
import com.loy.e.core.entity.Entity;
import com.loy.e.core.repository.GenericRepository;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.data.jpa.repository.support.CrudMethodMetadata;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Author(author="Loy Fu", website="http://www.17jee.com", contact="qq\u7fa4 540553957")
@Transactional(readOnly=true)
public class GenericRepositoryImpl<T extends Entity<ID>, ID extends Serializable>
implements GenericRepository<T, ID> {
    protected final Log logger = LogFactory.getLog(GenericRepositoryImpl.class);
    private EntityManager em = null;
    private JpaEntityInformation<T, ?> entityInformation = null;
    private Class<T> entityClass = null;
    private CrudMethodMetadata crudMethodMetadata = null;
    NamedParameterJdbcTemplate jdbcTemplate;

    public void setEntityManager(EntityManager entityManager) {
        this.em = entityManager;
    }

    public GenericRepositoryImpl(JpaEntityInformation<T, ?> entityInformation, EntityManager entityManager, NamedParameterJdbcTemplate jdbcTemplate, Settings settings) {
        this.entityInformation = entityInformation;
        this.entityClass = this.entityInformation.getJavaType();
        this.em = entityManager;
        this.jdbcTemplate = jdbcTemplate;
    }

    public void setRepositoryMethodMetadata(CrudMethodMetadata crudMethodMetadata) {
        this.crudMethodMetadata = crudMethodMetadata;
    }

    @Override
    @Transactional
    public T save(T entity) {
        if (entity.isNew() || this.entityInformation.isNew(entity)) {
            this.em.persist(entity);
            return entity;
        }
        if (entity instanceof BaseEntity) {
            BaseEntity baseEntity = (BaseEntity)entity;
            baseEntity.setModifiedTime(new Date());
        }
        return (T)((Entity)this.em.merge(entity));
    }

    @Override
    public T get(ID id) {
        Class<T> domainType = this.entityClass;
        if (this.crudMethodMetadata == null) {
            return (T)((Entity)this.em.find(domainType, id));
        }
        LockModeType type = this.crudMethodMetadata.getLockModeType();
        Map hints = this.crudMethodMetadata.getQueryHints();
        return (T)(type == null ? (Entity)this.em.find(domainType, id, hints) : (Entity)this.em.find(domainType, id, type, hints));
    }

    @Override
    public List<T> findAll() {
        return this.getQuery(null, null).getResultList();
    }

    @Override
    @Transactional
    public void delete(ID id) {
        T entity = this.get(id);
        if (entity != null) {
            this.delete(entity);
        }
    }

    @Override
    @Transactional
    public void delete(T entity) {
        this.em.remove(this.em.contains(entity) ? entity : this.em.merge(entity));
    }

    @Override
    @Transactional
    public void delete(List<ID> ids) {
        for (Serializable id : ids) {
            this.delete((T)id);
        }
    }

    protected TypedQuery<T> getQuery(Specification<T> spec, Sort sort) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(this.entityClass);
        Root<T> root = this.applySpecificationToCriteria(spec, query);
        query.select(root);
        if (sort != null) {
            query.orderBy(QueryUtils.toOrders((Sort)sort, root, (CriteriaBuilder)builder));
        }
        return this.applyRepositoryMethodMetadata(this.em.createQuery(query));
    }

    private <S> Root<T> applySpecificationToCriteria(Specification<T> spec, CriteriaQuery<S> query) {
        Assert.notNull(query);
        Root root = query.from(this.entityClass);
        if (spec == null) {
            return root;
        }
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        Predicate predicate = spec.toPredicate(root, query, builder);
        if (predicate != null) {
            query.where((Expression)predicate);
        }
        return root;
    }

    private TypedQuery<T> applyRepositoryMethodMetadata(TypedQuery<T> query) {
        if (this.crudMethodMetadata == null) {
            return query;
        }
        LockModeType type = this.crudMethodMetadata.getLockModeType();
        TypedQuery toReturn = type == null ? query : query.setLockMode(type);
        for (Map.Entry hint : this.crudMethodMetadata.getQueryHints().entrySet()) {
            query.setHint((String)hint.getKey(), hint.getValue());
        }
        return toReturn;
    }
}

