/*
 * Decompiled with CFR 0.152.
 */
package com.loy.e.core.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.loy.e.common.annotation.Author;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Author(author="Loy Fu", website="http://www.17jee.com", contact="qq\u7fa4 540553957")
public class JsonUtil {
    protected static final Log logger = LogFactory.getLog(JsonUtil.class);
    private static String SPACE = "   ";

    public static String json(Object source) {
        ObjectMapper objectMapper = new ObjectMapper();
        StringWriter sw = new StringWriter();
        try {
            objectMapper.writeValue((Writer)sw, source);
        }
        catch (Throwable e) {
            logger.error((Object)e);
        }
        return sw.toString();
    }

    public static String formatJson(String json) {
        StringBuffer result = new StringBuffer();
        int length = json.length();
        int number = 0;
        char key = '\u0000';
        for (int i = 0; i < length; ++i) {
            key = json.charAt(i);
            if (key == '[' || key == '{') {
                if (i - 1 > 0 && json.charAt(i - 1) == ':') {
                    result.append('\n');
                    result.append(JsonUtil.indent(number));
                }
                result.append(key);
                result.append('\n');
                result.append(JsonUtil.indent(++number));
                continue;
            }
            if (key == ']' || key == '}') {
                result.append('\n');
                result.append(JsonUtil.indent(--number));
                result.append(key);
                if (i + 1 >= length || json.charAt(i + 1) == ',') continue;
                result.append('\n');
                continue;
            }
            if (key == ',') {
                result.append(key);
                result.append('\n');
                result.append(JsonUtil.indent(number));
                continue;
            }
            result.append(key);
        }
        return result.toString();
    }

    private static String indent(int number) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < number; ++i) {
            result.append(SPACE);
        }
        return result.toString();
    }
}

