/*
 * Decompiled with CFR 0.152.
 */
package com.loy.e.core.util;

import com.loy.e.common.annotation.Author;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

@Author(author="Loy Fu", website="http://www.17jee.com", contact="qq\u7fa4 540553957")
public class TableToExcelUtil {
    public static void createExcelFormTable(String sheetName, String html, int headNum, OutputStream os) throws FileNotFoundException {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet(sheetName);
        CellStyle headStyle = TableToExcelUtil.createHeadStyle((Workbook)wb);
        CellStyle bodyStyle = TableToExcelUtil.createBodyStyle((Workbook)wb);
        SAXBuilder sb = new SAXBuilder();
        html = "<!DOCTYPE table[<!ENTITY nbsp \"\">]>" + html;
        ByteArrayInputStream is = new ByteArrayInputStream(html.getBytes());
        InputStreamReader isr = null;
        try {
            isr = new InputStreamReader((InputStream)is, "UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        try {
            Document document = sb.build((Reader)isr);
            Element root = document.getRootElement();
            List trList = root.getChildren("tr");
            int[][] area = TableToExcelUtil.getCellArea(trList);
            for (int i = 0; i < trList.size(); ++i) {
                HSSFRow row = sheet.createRow(i);
                List tdList = ((Element)trList.get(i)).getChildren("td");
                int tdIndex = 0;
                for (int ii = 0; ii < area[i].length; ++ii) {
                    row.createCell(ii);
                    HSSFCell cell = row.getCell(ii);
                    if (i < headNum) {
                        cell.setCellStyle(headStyle);
                    } else {
                        cell.setCellStyle(bodyStyle);
                    }
                    if (area[i][ii] == 1) {
                        sheet.addMergedRegion(new CellRangeAddress(i, i, ii - 1, ii));
                        continue;
                    }
                    if (area[i][ii] == 2) {
                        sheet.addMergedRegion(new CellRangeAddress(i - 1, i, ii, ii));
                        continue;
                    }
                    cell.setCellValue(TableToExcelUtil.getInnerText((Element)tdList.get(tdIndex)));
                    ++tdIndex;
                }
            }
            wb.write(os);
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static int[][] getCellArea(List<Element> trList) {
        Element headtr = trList.get(0);
        List headTdList = headtr.getChildren("td");
        int cols = 0;
        for (Element e : headTdList) {
            int colspan = Integer.valueOf(null == e.getAttributeValue("colspan") ? "0" : e.getAttributeValue("colspan"));
            if (colspan == 0) {
                colspan = 1;
            }
            cols += colspan;
        }
        int[][] area = new int[trList.size()][cols];
        for (int i = 0; i < trList.size(); ++i) {
            Element tr = trList.get(i);
            List tdList = tr.getChildren("td");
            int rowColspan = 0;
            for (int ii = 0; ii < tdList.size(); ++ii) {
                int oldIndex = ii + rowColspan;
                Element td = (Element)tdList.get(ii);
                int colspan = Integer.valueOf(null == td.getAttributeValue("colspan") ? "0" : td.getAttributeValue("colspan"));
                colspan = colspan > 1 ? colspan : 1;
                rowColspan += colspan - 1;
                for (int m = 1; m < colspan; ++m) {
                    area[i][oldIndex + m] = 1;
                }
                int rowspan = Integer.valueOf(null == td.getAttributeValue("rowspan") ? "0" : td.getAttributeValue("rowspan"));
                rowspan = rowspan > 1 ? rowspan : 1;
                for (int m = 1; m < rowspan; ++m) {
                    area[m + i][oldIndex] = 2;
                }
            }
        }
        return area;
    }

    private static CellStyle createHeadStyle(Workbook wb) {
        CellStyle style = wb.createCellStyle();
        Font headerFont = wb.createFont();
        headerFont.setBoldweight((short)700);
        style.setAlignment((short)2);
        style.setFillForegroundColor(IndexedColors.LIGHT_CORNFLOWER_BLUE.getIndex());
        style.setFillPattern((short)1);
        style.setFont(headerFont);
        style.setBorderRight((short)1);
        style.setRightBorderColor(IndexedColors.BLACK.getIndex());
        style.setBorderBottom((short)1);
        style.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        style.setBorderLeft((short)1);
        style.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        style.setBorderTop((short)1);
        style.setTopBorderColor(IndexedColors.BLACK.getIndex());
        return style;
    }

    private static CellStyle createBodyStyle(Workbook wb) {
        CellStyle style = wb.createCellStyle();
        Font headerFont = wb.createFont();
        headerFont.setBoldweight((short)400);
        style.setAlignment((short)2);
        style.setFillForegroundColor(IndexedColors.LIGHT_GREEN.getIndex());
        style.setFillPattern((short)1);
        style.setFont(headerFont);
        style.setBorderRight((short)1);
        style.setRightBorderColor(IndexedColors.BLACK.getIndex());
        style.setBorderBottom((short)1);
        style.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        style.setBorderLeft((short)1);
        style.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        style.setBorderTop((short)1);
        style.setTopBorderColor(IndexedColors.BLACK.getIndex());
        return style;
    }

    private static String getInnerText(Element td) {
        String txt = "";
        if (td.getText() == null || td.getText().equals("")) {
            if (null != td.getChildren()) {
                for (int i = 0; i < td.getChildren().size(); ++i) {
                    Element e = (Element)td.getChildren().get(i);
                    txt = txt + TableToExcelUtil.getInnerText(e);
                }
            }
        } else {
            txt = td.getText();
        }
        return txt;
    }
}

