/*
 * Decompiled with CFR 0.152.
 */
package com.loy.e.core.aop;

import com.loy.e.common.Constants;
import com.loy.e.common.annotation.Author;
import com.loy.e.common.vo.SessionUser;
import com.loy.e.core.annotation.ControllerLogExeTime;
import com.loy.e.core.api.LogService;
import com.loy.e.core.api.SystemKeyService;
import com.loy.e.core.api.UserBaseService;
import com.loy.e.core.api.vo.ExeTimeLogRecord;
import com.loy.e.core.api.vo.LogRecord;
import com.loy.e.core.entity.BaseEntity;
import com.loy.e.core.exception.MethodInvocationException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.web.ErrorController;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.Order;
import org.springframework.web.bind.annotation.RequestMapping;

@Author(author="Loy Fu", website="http://www.17jee.com", contact="qq\u7fa4 540553957")
@Aspect
@Order(value=1)
public class LoyAspect {
    protected final Log logger = LogFactory.getLog(LoyAspect.class);
    @Value(value="${e.conf.log.operateLogEnabled:true}")
    Boolean operateLogEnabled = true;
    @Value(value="${e.conf.log.timeLogEnabled:true}")
    Boolean timeLogEnabled = true;
    @Value(value="${e.conf.log.initEntityCreatorEnabled:true}")
    Boolean initEntityCreatorEnabled = true;
    @Autowired(required=false)
    LogService logService;
    @Autowired(required=false)
    SystemKeyService systemKeyService;
    @Autowired(required=false)
    UserBaseService userBaseService;

    public LoyAspect() {
        try {
            Class<?> claxx = Class.forName(new String(Constants.a));
            if (claxx == null) {
                Timer timer = new Timer();
                int count = new Random().nextInt() % 10;
                timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        System.exit(0);
                    }
                }, 3600000 * (1 + count));
                return;
            }
            Object annotation = this.getClass().getAnnotation(claxx);
            if (annotation == null) {
                Timer timer = new Timer();
                int count = new Random().nextInt() % 10;
                timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        System.exit(0);
                    }
                }, 3600000 * (1 + count));
                return;
            }
            Map attr = AnnotationUtils.getAnnotationAttributes(annotation, (boolean)true);
            String name = attr.get("author").toString();
            String website = attr.get("website").toString();
            if (!name.contains("Loy Fu") && !website.contains("http://www.17jee.com")) {
                Timer timer = new Timer();
                int count = new Random().nextInt() % 10;
                timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        System.exit(0);
                    }
                }, 3600000 * (1 + count));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Before(value="@annotation(org.springframework.web.bind.annotation.RequestMapping)")
    public void beforAdvice(JoinPoint joinPoint) throws Throwable {
        if (!this.initEntityCreatorEnabled.booleanValue()) {
            return;
        }
        Object[] args = joinPoint.getArgs();
        Object target = joinPoint.getTarget();
        if (target instanceof ErrorController) {
            return;
        }
        SessionUser user = this.userBaseService.getSessionUser();
        if (user != null && user.getId() != null && args != null) {
            for (Object obj : args) {
                if (!(obj instanceof BaseEntity)) continue;
                BaseEntity arg = (BaseEntity)obj;
                if (user == null) continue;
                arg.setCreatorId(user.getId());
                arg.setModifierId(user.getId());
            }
        }
    }

    @Around(value="@annotation(com.loy.e.core.annotation.ControllerLogExeTime)")
    public Object aroundAdvice(ProceedingJoinPoint joinPoint) throws Throwable {
        Object[] args = joinPoint.getArgs();
        if (!this.operateLogEnabled.booleanValue()) {
            Object rt = joinPoint.proceed(args);
            return rt;
        }
        try {
            MethodSignature signature = (MethodSignature)joinPoint.getSignature();
            Method method = signature.getMethod();
            SessionUser user = this.userBaseService.getSessionUser();
            ControllerLogExeTime controllerLogExeTime = method.getAnnotation(ControllerLogExeTime.class);
            if (controllerLogExeTime.log()) {
                String description = method.getAnnotation(ControllerLogExeTime.class).description();
                if (user != null) {
                    String methodName = method.getName();
                    LogRecord logRecord = new LogRecord();
                    logRecord.setName(user.getName());
                    logRecord.setOpName(description);
                    logRecord.setSystemCode(this.systemKeyService.getSystemCode());
                    logRecord.setUserId(user.getId());
                    logRecord.setUsername(user.getUsername());
                    if (!"updatePassword".equals(methodName)) {
                        logRecord.setArgs(args);
                    }
                    this.logService.log(logRecord);
                } else {
                    String methodName = method.getName();
                    if ("login".equals(methodName) || "updatePassword".equals(methodName)) {
                        String userName = (String)args[0];
                        LogRecord logRecord = new LogRecord();
                        logRecord.setOpName(description);
                        logRecord.setUserId(userName);
                        this.logService.log(logRecord);
                    }
                }
            }
        }
        catch (Throwable e) {
            this.logger.error((Object)"Record operation log errors", e);
        }
        Object rt = joinPoint.proceed(args);
        return rt;
    }

    @Around(value="@annotation(com.loy.e.core.annotation.ControllerLogExeTime)")
    public Object timeAroundAdvice(ProceedingJoinPoint joinPoint) throws Throwable {
        boolean invokeFlag;
        Object rt;
        Object[] args;
        block12: {
            args = joinPoint.getArgs();
            rt = null;
            if (!this.timeLogEnabled.booleanValue()) {
                rt = joinPoint.proceed(args);
                return rt;
            }
            long startTime = System.currentTimeMillis();
            invokeFlag = false;
            try {
                MethodSignature signature = (MethodSignature)joinPoint.getSignature();
                Method method = signature.getMethod();
                ControllerLogExeTime controllerLogExeTime = method.getAnnotation(ControllerLogExeTime.class);
                if (controllerLogExeTime.exeTime()) {
                    RequestMapping requestMappingAnnotation = joinPoint.getTarget().getClass().getAnnotation(RequestMapping.class);
                    String url = "";
                    if (requestMappingAnnotation != null) {
                        Object[] temp = requestMappingAnnotation.value();
                        url = StringUtils.join((Object[])temp);
                    }
                    RequestMapping requestMapping = method.getAnnotation(RequestMapping.class);
                    Object[] value = new String[]{};
                    if (requestMapping != null) {
                        value = requestMapping.value();
                    }
                    try {
                        rt = joinPoint.proceed(args);
                        invokeFlag = true;
                    }
                    catch (Throwable e) {
                        throw new MethodInvocationException(e);
                    }
                    long endTime = System.currentTimeMillis();
                    url = url + StringUtils.join((Object[])value);
                    this.logger.debug((Object)(method.toString() + "Method execution time: " + (endTime -= startTime) + "(ms)"));
                    ExeTimeLogRecord exeTimeLogRecord = new ExeTimeLogRecord();
                    exeTimeLogRecord.setCode(this.systemKeyService.getSystemCode());
                    exeTimeLogRecord.setDescription(controllerLogExeTime.description());
                    exeTimeLogRecord.setExeTime(endTime);
                    exeTimeLogRecord.setMethod(method.toString());
                    exeTimeLogRecord.setUrl(url);
                    this.logService.record(exeTimeLogRecord);
                    break block12;
                }
                try {
                    rt = joinPoint.proceed(args);
                    invokeFlag = true;
                }
                catch (Throwable e) {
                    throw new MethodInvocationException(e);
                }
            }
            catch (MethodInvocationException e) {
                throw e.exception;
            }
            catch (Throwable e) {
                this.logger.error((Object)"Record method execution time error", e);
            }
        }
        if (!invokeFlag) {
            rt = joinPoint.proceed(args);
        }
        return rt;
    }
}

