/*
 * Decompiled with CFR 0.152.
 */
package com.loy.e.core.converter;

import com.loy.e.common.annotation.Author;
import com.loy.e.common.util.Assert;
import com.loy.e.core.converter.AbsPageConverter;
import com.loy.e.core.entity.Entity;
import java.beans.PropertyDescriptor;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Author(author="Loy Fu", website="http://www.17jee.com", contact="qq\u7fa4 540553957")
public class DefaultPageConverter
extends AbsPageConverter {
    protected final Log logger = LogFactory.getLog(DefaultPageConverter.class);

    public Map convert(Object source) {
        if (source == null) {
            return null;
        }
        HashMap<String, Object> target = new HashMap<String, Object>();
        try {
            PropertyUtilsBean propertyUtilsBean = new PropertyUtilsBean();
            PropertyDescriptor[] descriptors = propertyUtilsBean.getPropertyDescriptors(source);
            for (int i = 0; i < descriptors.length; ++i) {
                String name = descriptors[i].getName();
                if ("class".equals(name)) continue;
                Object childern = propertyUtilsBean.getNestedProperty(source, name);
                if (childern instanceof Entity) {
                    PropertyDescriptor[] childernDescriptors = propertyUtilsBean.getPropertyDescriptors(childern);
                    for (int j = 0; j < childernDescriptors.length; ++j) {
                        String chilrenName = childernDescriptors[j].getName();
                        if ("class".equals(chilrenName)) continue;
                        target.put(name + "_" + chilrenName, propertyUtilsBean.getNestedProperty(childern, chilrenName));
                    }
                    continue;
                }
                target.put(name, propertyUtilsBean.getNestedProperty(source, name));
            }
        }
        catch (Throwable e) {
            this.logger.error((Object)e);
            Assert.throwException();
        }
        return target;
    }
}

