/*
 * Decompiled with CFR 0.152.
 */
package com.loy.e.core.repository.impl;

import com.loy.e.common.properties.Settings;
import com.loy.e.core.entity.Entity;
import com.loy.e.core.repository.GenericRepository;
import com.loy.e.core.repository.impl.GenericRepositoryImpl;
import java.io.Serializable;
import javax.persistence.EntityManager;
import org.springframework.data.jpa.provider.PersistenceProvider;
import org.springframework.data.jpa.provider.QueryExtractor;
import org.springframework.data.jpa.repository.query.EJpaQueryLookupStrategy;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.JpaRepositoryFactory;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.EvaluationContextProvider;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;

class DefaultRepositoryFactory<M extends Entity<ID>, ID extends Serializable>
extends JpaRepositoryFactory {
    private EntityManager entityManager;
    private NamedParameterJdbcTemplate jdbcTemplate;
    private Settings settings;

    public DefaultRepositoryFactory(EntityManager entityManager, NamedParameterJdbcTemplate jdbcTemplate, Settings settings) {
        super(entityManager);
        this.entityManager = entityManager;
        this.jdbcTemplate = jdbcTemplate;
        this.settings = settings;
    }

    protected Object getTargetRepository(RepositoryInformation metadata) {
        Class repositoryInterface = metadata.getRepositoryInterface();
        if (this.isBaseRepository(repositoryInterface)) {
            JpaEntityInformation entityInformation = this.getEntityInformation(metadata.getDomainType());
            GenericRepositoryImpl repository = new GenericRepositoryImpl(entityInformation, this.entityManager, this.jdbcTemplate, this.settings);
            return repository;
        }
        return super.getTargetRepository(metadata);
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
        if (this.isBaseRepository(metadata.getRepositoryInterface())) {
            return GenericRepository.class;
        }
        return super.getRepositoryBaseClass(metadata);
    }

    private boolean isBaseRepository(Class<?> repositoryInterface) {
        return GenericRepository.class.isAssignableFrom(repositoryInterface);
    }

    protected QueryLookupStrategy getQueryLookupStrategy(QueryLookupStrategy.Key key, EvaluationContextProvider evaluationContextProvider) {
        QueryLookupStrategy queryLookupStrategy = EJpaQueryLookupStrategy.create((EntityManager)this.entityManager, (QueryLookupStrategy.Key)key, (QueryExtractor)PersistenceProvider.fromEntityManager((EntityManager)this.entityManager), (EvaluationContextProvider)evaluationContextProvider);
        return queryLookupStrategy;
    }
}

