/*
 * Decompiled with CFR 0.152.
 */
package com.loy.e.core.web.dispatch;

import com.loy.e.common.annotation.Author;
import com.loy.e.common.properties.Settings;
import com.loy.e.common.vo.ErrorResponseData;
import com.loy.e.core.util.JsonUtil;
import com.loy.e.core.util.RequestUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContext;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.ModelAndView;

@Author(author="Loy Fu", website="http://www.17jee.com", contact="qq\u7fa4 540553957")
public class DefaultDispatchServlet
extends DispatcherServlet {
    Map<String, Locale> locales = new HashMap<String, Locale>();
    @Autowired
    private Settings settings;

    public DefaultDispatchServlet() {
        Locale[] lcl = Locale.getAvailableLocales();
        if (lcl != null) {
            for (Locale locale : lcl) {
                String language = locale.getLanguage();
                String country = locale.getCountry();
                String lang = language + "_" + country;
                this.locales.put(lang, locale);
            }
        }
    }

    protected ModelAndView processHandlerException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        if (RequestUtil.isJson(request) && ex instanceof ServletException) {
            ErrorResponseData error = new ErrorResponseData();
            error.setMsg(ex.getMessage());
            String errorJson = JsonUtil.json(error);
            response.getWriter().print(errorJson);
            return null;
        }
        return super.processHandlerException(request, response, handler, ex);
    }

    protected LocaleContext buildLocaleContext(final HttpServletRequest request) {
        return new LocaleContext(){

            public Locale getLocale() {
                Locale locale = null;
                Cookie[] cookies = request.getCookies();
                if (cookies != null) {
                    for (Cookie cookie : cookies) {
                        List supportLocales;
                        String value;
                        String name = cookie.getName();
                        if (!"LANG".equals(name) || !StringUtils.isNotEmpty((String)(value = cookie.getValue())) || !(supportLocales = DefaultDispatchServlet.this.settings.getSupportLocales()).contains(value)) continue;
                        locale = DefaultDispatchServlet.this.locales.get(value);
                        break;
                    }
                }
                if (locale != null) {
                    return locale;
                }
                String defaultLocale = DefaultDispatchServlet.this.settings.getDefaultLocale();
                if (StringUtils.isNotEmpty((String)defaultLocale)) {
                    locale = DefaultDispatchServlet.this.locales.get(defaultLocale);
                }
                if (locale == null) {
                    locale = Locale.getDefault();
                }
                return locale;
            }
        };
    }
}

