/*
 * Decompiled with CFR 0.152.
 */
package com.zoi7.component.mybatis.base;

import com.zoi7.component.core.base.BaseClass;
import com.zoi7.component.core.util.page.Pagination;
import com.zoi7.component.mybatis.base.BaseMapper;
import com.zoi7.component.mybatis.base.BaseService;
import com.zoi7.component.mybatis.dto.OrderBy;
import com.zoi7.component.mybatis.runner.DbConfig;
import com.zoi7.mysql.util.FieldUtils;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Sort;

public class BaseServiceImpl<T extends Serializable, L extends Serializable>
extends BaseClass
implements BaseService<T, L> {
    private static final Logger log = LoggerFactory.getLogger(BaseServiceImpl.class);
    private BaseMapper<T, L> mapper;
    private Class<T> persistentClass;

    public BaseServiceImpl() {
        ParameterizedType parameterizedType = (ParameterizedType)this.getClass().getGenericSuperclass();
        this.persistentClass = (Class)parameterizedType.getActualTypeArguments()[0];
    }

    public void setMapper(BaseMapper<T, L> mapper) {
        this.mapper = mapper;
    }

    protected BaseMapper<T, L> getMapper() {
        return this.mapper;
    }

    @Override
    public T save(T entity) {
        this.getMapper().save(entity);
        return entity;
    }

    @Override
    public T update(T entity) {
        this.getMapper().update(entity);
        return entity;
    }

    @Override
    public boolean delete(L id) {
        return this.getMapper().delete(id);
    }

    @Override
    public T findById(L id) {
        return this.getMapper().findById(id);
    }

    @Override
    public List<T> findList(T t, Sort.Order ... orders) {
        String orderStatement = null;
        try {
            orderStatement = this.getOrderStatement(t.getClass(), orders);
        }
        catch (NoSuchFieldException e) {
            log.error("ORDER BY CONDITION HAS SOME ERROR", (Throwable)e);
        }
        return this.getMapper().findList(t, orderStatement);
    }

    @Override
    public List<T> findList(T t, OrderBy ... orders) {
        return this.findList(t, this.transform(orders));
    }

    @Override
    public List<T> findAll(Sort.Order ... orders) {
        String orderStatement = null;
        try {
            orderStatement = this.getOrderStatement(this.persistentClass, orders);
        }
        catch (NoSuchFieldException e) {
            log.error("ORDER BY CONDITION HAS SOME ERROR", (Throwable)e);
        }
        return this.getMapper().findAll(orderStatement);
    }

    @Override
    public List<T> findAll(OrderBy ... orders) {
        return this.findAll(this.transform(orders));
    }

    @Override
    public Pagination<T> findPage(int pageNo, int pageSize, Sort.Order ... orders) {
        ArrayList<T> list = new ArrayList<T>();
        int count = this.getMapper().findAllCount();
        if (count > 0) {
            int start = (pageNo - 1) * pageSize;
            String orderStatement = null;
            try {
                orderStatement = this.getOrderStatement(this.persistentClass, orders);
            }
            catch (NoSuchFieldException e) {
                log.error("ORDER BY CONDITION HAS SOME ERROR", (Throwable)e);
            }
            list.addAll(this.getMapper().findAllPage(start, pageSize, orderStatement));
        }
        Pagination pagination = new Pagination(pageNo, pageSize, count);
        pagination.setList(list);
        return pagination;
    }

    @Override
    public Pagination<T> findPage(int pageNo, int pageSize, OrderBy ... orders) {
        return this.findPage(pageNo, pageSize, this.transform(orders));
    }

    @Override
    public Pagination<T> findPage(T entity, int pageNo, int pageSize, Sort.Order ... orders) {
        ArrayList<T> list = new ArrayList<T>();
        int count = this.getMapper().findCount(entity);
        if (count > 0) {
            int start = (pageNo - 1) * pageSize;
            String orderStatement = null;
            try {
                orderStatement = this.getOrderStatement(entity.getClass(), orders);
            }
            catch (NoSuchFieldException e) {
                log.error("ORDER BY CONDITION HAS SOME ERROR", (Throwable)e);
            }
            list.addAll(this.getMapper().findPage(start, pageSize, entity, orderStatement));
        }
        Pagination pagination = new Pagination(pageNo, pageSize, count);
        pagination.setList(list);
        return pagination;
    }

    @Override
    public Pagination<T> findPage(T entity, int pageNo, int pageSize, OrderBy ... orders) {
        return this.findPage(entity, pageNo, pageSize, this.transform(orders));
    }

    @Override
    public Pagination<T> findPageDesc(T entity, int pageNo, int pageSize) {
        ArrayList<T> list = new ArrayList<T>();
        int count = this.getMapper().findCount(entity);
        if (count > 0) {
            int start = (pageNo - 1) * pageSize;
            list.addAll(this.getMapper().findPageDesc(start, pageSize, entity));
        }
        Pagination pagination = new Pagination(pageNo, pageSize, count);
        pagination.setList(list);
        return pagination;
    }

    @Override
    public int findCount(T entity) {
        return this.getMapper().findCount(entity);
    }

    @Override
    public int findAllCount() {
        return this.getMapper().findAllCount();
    }

    protected String getOrderStatement(Class clazz, Sort.Order ... orders) throws NoSuchFieldException {
        String orderStatement = null;
        if (orders != null && orders.length > 0) {
            orderStatement = " ";
            for (int i = 0; i < orders.length; ++i) {
                Sort.Order order = orders[i];
                String column = this.getColumnName(clazz, order.getProperty());
                orderStatement = orderStatement + column + (order.isDescending() ? " DESC " : " ASC ");
                if (i >= orders.length - 1) continue;
                orderStatement = orderStatement + ", ";
            }
        }
        return orderStatement;
    }

    private String getColumnName(Class clazz, String property) throws NoSuchFieldException {
        Field field = clazz.getDeclaredField(property);
        if (field.isAnnotationPresent(com.zoi7.mysql.comment.Field.class)) {
            return FieldUtils.getColumn((Field)field, (boolean)DbConfig.getInstance().isUppercase());
        }
        return FieldUtils.getColumnByField((String)property, (boolean)DbConfig.getInstance().isUppercase());
    }

    private Sort.Order[] transform(OrderBy[] orders) {
        if (orders == null) {
            return null;
        }
        Sort.Order[] os = new Sort.Order[orders.length];
        for (int i = 0; i < orders.length; ++i) {
            OrderBy o = orders[i];
            os[i] = "DESC".equalsIgnoreCase(o.getType()) ? Sort.Order.desc((String)o.getProperty()) : Sort.Order.asc((String)o.getProperty());
        }
        return os;
    }
}

