/*
 * Decompiled with CFR 0.152.
 */
package com.zoi7.component.mybatis.runner;

import com.zoi7.mysql.config.DataConfig;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="spring.datasource")
public class DbConfig
implements ApplicationContextAware {
    private static ApplicationContext context;
    private static volatile DbConfig config;
    private String url;
    private String username;
    private String password;
    private String driver;
    private List<String> packages;
    private String auto = "update";
    private boolean showSql = false;
    private boolean uppercase = false;

    public DataConfig getConfig() {
        String[] packs = this.packages.toArray(new String[0]);
        DataConfig config = new DataConfig(packs, this.url, this.username, this.password, this.auto, this.showSql);
        config.setUppercase(this.uppercase);
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DbConfig getInstance() {
        if (config != null) return config;
        Class<DbConfig> clazz = DbConfig.class;
        synchronized (DbConfig.class) {
            config = (DbConfig)context.getBean(DbConfig.class);
            // ** MonitorExit[var0] (shouldn't be in output)
            return config;
        }
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public List<String> getPackages() {
        return this.packages;
    }

    public boolean isUppercase() {
        return this.uppercase;
    }

    public void setUppercase(boolean uppercase) {
        this.uppercase = uppercase;
    }

    public void setPackages(List<String> packages) {
        this.packages = packages;
    }

    public String getAuto() {
        return this.auto;
    }

    public void setAuto(String auto) {
        this.auto = auto;
    }

    public boolean isShowSql() {
        return this.showSql;
    }

    public void setShowSql(boolean showSql) {
        this.showSql = showSql;
    }

    public String toString() {
        return "DbConfig{url='" + this.url + '\'' + ", username='" + this.username + '\'' + ", password='" + this.password + '\'' + ", driver='" + this.driver + '\'' + ", packages=" + this.packages + ", auto='" + this.auto + '\'' + ", showSql=" + this.showSql + '}';
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        context = applicationContext;
    }
}

