/*
 * Decompiled with CFR 0.152.
 */
package com.zoi7.component.mybatis.util;

import com.zoi7.mysql.comment.Entity;
import com.zoi7.mysql.comment.Id;
import com.zoi7.mysql.util.FieldUtils;
import com.zoi7.mysql.util.mybatis.AbstractMapperUtils;
import com.zoi7.mysql.util.mybatis.MapperConfig;
import java.lang.reflect.Field;
import java.util.Map;

public class MapperUtils
extends AbstractMapperUtils<MapperConfig> {
    public static MapperUtils INSTANCE = new MapperUtils();

    protected String getXmlString(Class<?> clazz, MapperConfig config) {
        Entity entity = clazz.getAnnotation(Entity.class);
        String tableName = entity.tableName();
        String clazzSimpleName = clazz.getSimpleName();
        String clazzPackage = clazz.getPackage().toString();
        Field[] fields = clazz.getDeclaredFields();
        String[] packs = clazzPackage.split("entity");
        String pack = packs.length > 1 ? packs[1] : "";
        String namespace = config.getMapperPackage() + pack + "." + clazzSimpleName + "Mapper";
        Field idField = null;
        StringBuilder xml = new StringBuilder();
        xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?> \n");
        xml.append("<!DOCTYPE mapper PUBLIC \"-//mybatis.org//DTD Mapper 3.0//EN\" \n");
        xml.append("\t\"http://mybatis.org/dtd/mybatis-3-mapper.dtd\">\n\n");
        xml.append("<mapper namespace=\"").append(namespace).append("\">\n\n");
        xml.append("\t<sql id=\"table_name\" > ").append(tableName).append(" </sql> \n\n");
        if (config.isUseCache()) {
            Field[] cacheClass = config.getCacheClass();
            if (cacheClass != null) {
                xml.append("\t<!-- \u542f\u7528\u4e8c\u7ea7\u7f13\u5b58, \u6ce8\u610f: \u6d89\u53ca\u5230\u5173\u8054\u67e5\u8be2\u7684sql\u9700\u8981\u6807\u6ce8 useCache=\"false\" -->\n");
                xml.append("\t<cache type=\"").append((String)cacheClass).append("\" > \n");
                Map pros = config.getCustomCachePros();
                if (pros != null && !pros.isEmpty()) {
                    for (String k : pros.keySet()) {
                        xml.append("\t\t<property name=\"").append(k).append("\" value=\"").append((String)pros.get(k)).append("\" />\n");
                    }
                }
                xml.append("\t</cache>\n\n");
            } else {
                long cacheTime = config.getCacheTime();
                xml.append("\t<!-- \u542f\u7528\u4e8c\u7ea7\u7f13\u5b58, \u6ce8\u610f: \u6d89\u53ca\u5230\u5173\u8054\u67e5\u8be2\u7684sql\u9700\u8981\u6807\u6ce8 useCache=\"false\" -->\n");
                if (cacheTime > 0L) {
                    xml.append("\t<cache flushInterval=\"").append(cacheTime).append("\" /> \n\n");
                }
            }
        }
        xml.append("\t<parameterMap id=\"parameterType\" type=\"").append(clazz.getName()).append("\" />\n\n");
        xml.append("\t<resultMap id=\"resultList\" type=\"").append(clazz.getName()).append("\">\n");
        for (Field field : fields) {
            if (!field.isAnnotationPresent(com.zoi7.mysql.comment.Field.class)) continue;
            if (field.isAnnotationPresent(Id.class)) {
                idField = field;
                xml.append("\t\t<id ");
            } else {
                xml.append("\t\t<result ");
            }
            xml.append("column=\"").append(FieldUtils.getColumn((Field)field, (boolean)config.isUppercase())).append("\" property=\"").append(field.getName()).append("\" jdbcType=\"").append(MapperUtils.getJdbcType((Field)field)).append("\"/>\n");
        }
        xml.append("\t</resultMap>\n\n");
        xml.append("\t<insert id=\"save\" parameterMap=\"parameterType\" ");
        if (idField != null && FieldUtils.isAutoIncrease(idField)) {
            xml.append("useGeneratedKeys=\"true\" keyColumn=\"").append(FieldUtils.getColumn((Field)idField, (boolean)config.isUppercase())).append("\"").append(" keyProperty=\"").append(idField.getName()).append("\" ");
        }
        xml.append(">\n");
        xml.append("\t\tinsert into <include refid=\"table_name\"/>\n");
        xml.append("\t\t\t(");
        boolean first = true;
        for (Field field : fields) {
            if (!field.isAnnotationPresent(com.zoi7.mysql.comment.Field.class) || FieldUtils.isAutoIncrease((Field)field)) continue;
            if (!first) {
                xml.append(", ");
            } else {
                first = false;
            }
            xml.append(FieldUtils.getColumn((Field)field, (boolean)config.isUppercase()));
        }
        xml.append(") \n");
        xml.append("\t\tvalues (\n");
        xml.append("\t\t\t");
        first = true;
        for (Field field : fields) {
            if (!field.isAnnotationPresent(com.zoi7.mysql.comment.Field.class) || FieldUtils.isAutoIncrease((Field)field)) continue;
            if (!first) {
                xml.append(", ");
            } else {
                first = false;
            }
            xml.append("#{").append(field.getName()).append("}");
        }
        xml.append("\n\t\t)\n");
        xml.append("\t</insert>\n\n");
        if (idField != null) {
            xml.append("\t<update id=\"update\" parameterMap=\"parameterType\" >\n");
            xml.append("\t\tupdate\n");
            xml.append("\t\t<include refid=\"table_name\"/>\n");
            xml.append("\t\t<set>");
            first = true;
            for (Field field : fields) {
                if (!field.isAnnotationPresent(com.zoi7.mysql.comment.Field.class) || FieldUtils.isAutoIncrease((Field)field)) continue;
                if (!first) {
                    xml.append(", ");
                } else {
                    first = false;
                }
                xml.append("\n\t\t\t").append(FieldUtils.getColumn((Field)field, (boolean)config.isUppercase()));
                xml.append(" = #{").append(field.getName()).append("}");
            }
            xml.append("\n\t\t</set>\n");
            xml.append("\t\t<where>\n");
            xml.append("\t\t\t").append(FieldUtils.getColumn((Field)idField, (boolean)config.isUppercase())).append(" = #{").append(idField.getName()).append("} \n");
            xml.append("\t\t</where>\n");
            xml.append("\t</update>\n\n");
            xml.append("\t<delete id=\"delete\" parameterType=\"long\" >\n");
            xml.append("\t\tdelete from <include refid=\"table_name\"/> \n ");
            xml.append("\t\t<where>\n");
            xml.append("\t\t\t").append(FieldUtils.getColumn((Field)idField, (boolean)config.isUppercase())).append(" = #{param1}\n");
            xml.append("\t\t</where>\n");
            xml.append("\t</delete>\n\n");
            xml.append("\t<select id=\"findById\" parameterType=\"long\" resultMap=\"resultList\" >\n");
            xml.append("\t\tselect * from <include refid=\"table_name\"/> \n");
            xml.append("\t\t<where>\n");
            xml.append("\t\t\t").append(FieldUtils.getColumn((Field)idField, (boolean)config.isUppercase())).append(" = #{param1}\n");
            xml.append("\t\t</where>\n");
            xml.append("\t</select>\n\n");
        } else {
            System.err.println("idField is not appoint!");
        }
        xml.append("\t<select id=\"findList\" parameterMap=\"parameterType\" resultMap=\"resultList\">\n");
        xml.append("\t\tselect * from <include refid=\"table_name\"/>\n");
        xml.append("\t\t<where>\n");
        xml.append("\t\t\t1=1\n");
        for (Field field : fields) {
            if (!field.isAnnotationPresent(com.zoi7.mysql.comment.Field.class)) continue;
            xml.append("\t\t\t<if test=\"param1.").append(field.getName()).append(" != null\">");
            xml.append(" and ").append(FieldUtils.getColumn((Field)field, (boolean)config.isUppercase())).append(" = #{param1.").append(field.getName()).append("} ");
            xml.append(" </if>\n");
        }
        xml.append("\t\t</where>\n");
        xml.append("\t\t<if test=\"param2 != null\">\n\t\t\tORDER BY ${param2}\n\t\t</if>\n");
        if (config.getMaxLimit() > 0) {
            xml.append("\t\tlimit 0,").append(config.getMaxLimit()).append(" \n");
        }
        xml.append("\t</select>\n\n");
        xml.append("\t<select id=\"findAll\" resultMap=\"resultList\">\n");
        xml.append("\t\tselect * from <include refid=\"table_name\"/>\n");
        xml.append("\t\t<if test=\"param1 != null\">\n\t\t\tORDER BY ${param1}\n\t\t</if>\n");
        if (config.getMaxLimit() > 0) {
            xml.append("\t\tlimit 0,").append(config.getMaxLimit()).append(" \n");
        }
        xml.append("\t</select>\n\n");
        xml.append("\t<select id=\"findAllPage\" resultMap=\"resultList\">\n");
        xml.append("\t\tselect * from <include refid=\"table_name\"/>\n");
        xml.append("\t\t<if test=\"param3 != null\"> \n");
        xml.append("\t\t\t ORDER BY ${param3} \n");
        xml.append("\t\t</if>\n");
        xml.append("\t\tlimit #{param1},#{param2}\n");
        xml.append("\t</select>\n\n");
        xml.append("\t<select id=\"findPage\" resultMap=\"resultList\">\n");
        xml.append("\t\tselect * from <include refid=\"table_name\"/>\n");
        xml.append("\t\t<where>\n");
        xml.append("\t\t\t1=1\n");
        for (Field field : fields) {
            if (!field.isAnnotationPresent(com.zoi7.mysql.comment.Field.class)) continue;
            xml.append("\t\t\t<if test=\"param3.").append(field.getName()).append(" != null\">");
            xml.append(" and ").append(FieldUtils.getColumn((Field)field, (boolean)config.isUppercase())).append(" = #{param3.").append(field.getName()).append("} ");
            xml.append(" </if>\n");
        }
        xml.append("\t\t</where>\n");
        xml.append("\t\t<if test=\"param4 != null\"> \n");
        xml.append("\t\t\t ORDER BY ${param4} \n");
        xml.append("\t\t</if>\n");
        xml.append("\t\tlimit #{param1},#{param2}\n");
        xml.append("\t</select>\n\n");
        if (idField != null) {
            xml.append("\t<select id=\"findPageDesc\" resultMap=\"resultList\">\n");
            xml.append("\t\tselect * from <include refid=\"table_name\"/>\n");
            xml.append("\t\t<where>\n");
            xml.append("\t\t\t1=1\n");
            for (Field field : fields) {
                if (!field.isAnnotationPresent(com.zoi7.mysql.comment.Field.class)) continue;
                xml.append("\t\t\t<if test=\"param3.").append(field.getName()).append(" != null\">");
                xml.append(" and ").append(FieldUtils.getColumn((Field)field, (boolean)config.isUppercase())).append(" = #{param3.").append(field.getName()).append("} ");
                xml.append(" </if>\n");
            }
            xml.append("\t\t</where>\n");
            xml.append("\t\torder by ").append(FieldUtils.getColumn((Field)idField, (boolean)config.isUppercase())).append(" desc\n");
            xml.append("\t\tlimit #{param1},#{param2}\n");
            xml.append("\t</select>\n\n");
            xml.append("\t<select id=\"findCount\" parameterMap=\"parameterType\" resultType=\"int\">\n");
            xml.append("\t\tselect count(").append(FieldUtils.getColumn((Field)idField, (boolean)config.isUppercase())).append(") from <include refid=\"table_name\"/>\n");
            xml.append("\t\t<where>\n");
            xml.append("\t\t\t1=1\n");
            for (Field field : fields) {
                if (!field.isAnnotationPresent(com.zoi7.mysql.comment.Field.class)) continue;
                xml.append("\t\t\t<if test=\"").append(field.getName()).append(" != null\">");
                xml.append(" and ").append(FieldUtils.getColumn((Field)field, (boolean)config.isUppercase())).append(" = #{").append(field.getName()).append("} ");
                xml.append(" </if>\n");
            }
            xml.append("\t\t</where>\n");
            xml.append("\t</select>\n\n");
        } else {
            System.err.println("isField is not appoint!");
        }
        xml.append("\t<select id=\"findAllCount\" resultType=\"int\">\n");
        xml.append("\t\tselect count(*) from <include refid=\"table_name\"/>\n");
        xml.append("\t</select>\n\n");
        xml.append("</mapper>");
        return xml.toString();
    }
}

