/*
 * Decompiled with CFR 0.152.
 */
package com.liuqi.vanasframework.core;

import com.liuqi.vanasframework.core.Vanas;
import com.liuqi.vanasframework.core.conf.VanasCustomerConfig;
import com.liuqi.vanasframework.core.exception.AppBootstrapException;
import com.liuqi.vanasframework.core.interceptor.GetRequestResultTypeInterceptor;
import com.liuqi.vanasframework.core.mvc.view.FreeMarkerConfig;
import java.io.Serializable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.jcache.JCacheCacheManager;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

public abstract class VanasAppWebConfig
implements WebMvcConfigurer,
ApplicationContextAware,
Serializable {
    private static final Logger log = LogManager.getLogger(VanasAppWebConfig.class);
    private static final long serialVersionUID = 3506677069701948993L;
    @Autowired
    protected FreeMarkerConfig freeMarkerConfig;
    @Autowired
    private VanasCustomerConfig vanasCustomerConfig;

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)new GetRequestResultTypeInterceptor());
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        log.info("Vanas Spring Context success set on. {}", (Object)applicationContext);
        Vanas.SpringContext = applicationContext;
        log.info("Vanas Customer Config success set on. {}", (Object)this.vanasCustomerConfig);
        Vanas.customerConfig = this.vanasCustomerConfig;
    }

    @Bean
    private void initCacheManager() {
        log.info("\u7f13\u5b58\u52a0\u8f7d\u521d\u59cb\u5316 ehcache 3.x .");
        log.info("\u7f13\u5b58\u52a0\u8f7d\u521d\u59cb\u5316 >> \u52a0\u8f7d spring \u7f13\u5b58\u7ba1\u7406\u5668.");
        try {
            Vanas.cacheManager = (JCacheCacheManager)Vanas.SpringContext.getBean(JCacheCacheManager.class);
        }
        catch (Exception e) {
            log.error("\u7f13\u5b58\u52a0\u8f7d\u521d\u59cb\u5316 >> Error : ", (Throwable)e);
            throw new AppBootstrapException("\u7f13\u5b58\u52a0\u8f7d\u5931\u8d25", e);
        }
    }
}

