/*
 * Decompiled with CFR 0.152.
 */
package com.liuqi.vanasframework.core.aspect;

import com.liuqi.vanasframework.core.adapter.VanasSaveLogAdapter;
import com.liuqi.vanasframework.core.annotation.SaveLog;
import com.liuqi.vanasframework.core.conf.norm.SaveLogType;
import java.lang.reflect.Method;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Aspect
@Component
public class SaveLogAspect {
    private static final Logger log = LogManager.getLogger(SaveLogAspect.class);
    private VanasSaveLogAdapter adapter = null;

    public SaveLogAspect(VanasSaveLogAdapter adapter) {
        this.adapter = adapter;
    }

    @Pointcut(value="@annotation(com.liuqi.vanasframework.core.annotation.SaveLog)")
    private void logPoint() {
    }

    @AfterReturning(pointcut="logPoint()", returning="object")
    public void saveLog(JoinPoint jp, Object object) {
        Assert.notNull((Object)this.adapter, (String)"\u65e0\u6cd5\u5b8c\u6210\u6570\u636e\u5e93\u65e5\u5fd7\u8bb0\u5f55\uff0c\u5207\u9762\u7f3a\u5931 VanasSaveLogAdapter \u7684\u5b9e\u73b0\u7c7b. \u4f60\u9700\u8981\u5728\u60a8\u7684\u5e94\u7528\u4e2d\u53bb \u5b9e\u73b0 [VanasSaveLogAdapter] \u9002\u914d\u5668\u3002");
        boolean logDebug = log.isDebugEnabled();
        String targetClassName = jp.getTarget().getClass().getName();
        log.info("SaveLogAspect [{}] \u8bb0\u5f55\u65e5\u5fd7.", (Object)targetClassName);
        Class<?> targetClass = null;
        try {
            if (logDebug) {
                log.debug("SaveLogAspect [{}] Class.forName.", (Object)targetClassName);
            }
            targetClass = Class.forName(targetClassName);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            log.debug("SaveLogAspect [{}] Class.forName. Error !!", (Object)targetClassName, (Object)e);
        }
        if (targetClass == null) {
            return;
        }
        String methodName = jp.getSignature().getName();
        Method[] methods = targetClass.getMethods();
        Object[] args = jp.getArgs();
        String operationDesc = "";
        SaveLogType operationType = null;
        for (Method method : methods) {
            Class<?>[] clazzs;
            if (!method.getName().equals(methodName) || (clazzs = method.getParameterTypes()) == null || clazzs.length != args.length || method.getAnnotation(SaveLog.class) == null) continue;
            operationDesc = method.getAnnotation(SaveLog.class).desc();
            operationType = method.getAnnotation(SaveLog.class).type();
            break;
        }
        if (logDebug) {
            log.debug("SaveLogAspect [{}] type:{} , desc : {}", (Object)targetClassName, operationType, (Object)operationDesc);
        }
        this.adapter.saveLog(targetClassName, methodName, operationType, operationDesc, object);
    }
}

