/*
 * Decompiled with CFR 0.152.
 */
package com.liuqi.vanasframework.core.conf;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import javax.validation.constraints.NotEmpty;
import org.apache.commons.lang.StringUtils;

public class VanasSecurityConfig
implements Serializable {
    private static final long serialVersionUID = 2821054520945565401L;
    private Boolean xFrameEnabled = Boolean.FALSE;
    private String xFrameOptions = "SAMEORIGIN";
    private String[] xFrameAllowUri;
    @NotEmpty
    private String[] permitUrl;
    private boolean csrfEnabled = Boolean.TRUE;
    private String[] csrfPermitUrl;
    private String loginUrl = "/login";
    private String loginFormUrl = "/login";
    private String loginSuccessUrl = "/dashboard";
    private String loginFailureUrl = "/login?error";
    private String loginOutSuccessUrl = "/login";
    private boolean cookieEnabled = Boolean.TRUE;
    private Integer cookieValidSeconds = 172800;

    public void setPermitUrl(String permitUrl) {
        this.permitUrl = this.getStringArray(permitUrl);
    }

    public void setCsrfPermitUrl(String csrfPermitUrl) {
        this.csrfPermitUrl = this.getStringArray(csrfPermitUrl);
    }

    public void setxFrameAllowUri(String xFrameAllowUri) {
        this.xFrameAllowUri = this.getStringArray(xFrameAllowUri);
    }

    private String[] getStringArray(String attrVal) {
        if (StringUtils.isEmpty((String)attrVal)) {
            return null;
        }
        String[] attrArray = attrVal.split(",");
        ArrayList<String> finalList = new ArrayList<String>();
        for (String attr : attrArray) {
            if (StringUtils.isEmpty((String)attr)) continue;
            finalList.add(attr.trim());
        }
        return finalList.toArray(new String[0]);
    }

    public Boolean getXFrameEnabled() {
        return this.xFrameEnabled;
    }

    public String getXFrameOptions() {
        return this.xFrameOptions;
    }

    public String[] getXFrameAllowUri() {
        return this.xFrameAllowUri;
    }

    public String[] getPermitUrl() {
        return this.permitUrl;
    }

    public boolean isCsrfEnabled() {
        return this.csrfEnabled;
    }

    public String[] getCsrfPermitUrl() {
        return this.csrfPermitUrl;
    }

    public String getLoginUrl() {
        return this.loginUrl;
    }

    public String getLoginFormUrl() {
        return this.loginFormUrl;
    }

    public String getLoginSuccessUrl() {
        return this.loginSuccessUrl;
    }

    public String getLoginFailureUrl() {
        return this.loginFailureUrl;
    }

    public String getLoginOutSuccessUrl() {
        return this.loginOutSuccessUrl;
    }

    public boolean isCookieEnabled() {
        return this.cookieEnabled;
    }

    public Integer getCookieValidSeconds() {
        return this.cookieValidSeconds;
    }

    public void setXFrameEnabled(Boolean xFrameEnabled) {
        this.xFrameEnabled = xFrameEnabled;
    }

    public void setXFrameOptions(String xFrameOptions) {
        this.xFrameOptions = xFrameOptions;
    }

    public void setCsrfEnabled(boolean csrfEnabled) {
        this.csrfEnabled = csrfEnabled;
    }

    public void setLoginUrl(String loginUrl) {
        this.loginUrl = loginUrl;
    }

    public void setLoginFormUrl(String loginFormUrl) {
        this.loginFormUrl = loginFormUrl;
    }

    public void setLoginSuccessUrl(String loginSuccessUrl) {
        this.loginSuccessUrl = loginSuccessUrl;
    }

    public void setLoginFailureUrl(String loginFailureUrl) {
        this.loginFailureUrl = loginFailureUrl;
    }

    public void setLoginOutSuccessUrl(String loginOutSuccessUrl) {
        this.loginOutSuccessUrl = loginOutSuccessUrl;
    }

    public void setCookieEnabled(boolean cookieEnabled) {
        this.cookieEnabled = cookieEnabled;
    }

    public void setCookieValidSeconds(Integer cookieValidSeconds) {
        this.cookieValidSeconds = cookieValidSeconds;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VanasSecurityConfig)) {
            return false;
        }
        VanasSecurityConfig other = (VanasSecurityConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$xFrameEnabled = this.getXFrameEnabled();
        Boolean other$xFrameEnabled = other.getXFrameEnabled();
        if (this$xFrameEnabled == null ? other$xFrameEnabled != null : !((Object)this$xFrameEnabled).equals(other$xFrameEnabled)) {
            return false;
        }
        String this$xFrameOptions = this.getXFrameOptions();
        String other$xFrameOptions = other.getXFrameOptions();
        if (this$xFrameOptions == null ? other$xFrameOptions != null : !this$xFrameOptions.equals(other$xFrameOptions)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getXFrameAllowUri(), other.getXFrameAllowUri())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getPermitUrl(), other.getPermitUrl())) {
            return false;
        }
        if (this.isCsrfEnabled() != other.isCsrfEnabled()) {
            return false;
        }
        if (!Arrays.deepEquals(this.getCsrfPermitUrl(), other.getCsrfPermitUrl())) {
            return false;
        }
        String this$loginUrl = this.getLoginUrl();
        String other$loginUrl = other.getLoginUrl();
        if (this$loginUrl == null ? other$loginUrl != null : !this$loginUrl.equals(other$loginUrl)) {
            return false;
        }
        String this$loginFormUrl = this.getLoginFormUrl();
        String other$loginFormUrl = other.getLoginFormUrl();
        if (this$loginFormUrl == null ? other$loginFormUrl != null : !this$loginFormUrl.equals(other$loginFormUrl)) {
            return false;
        }
        String this$loginSuccessUrl = this.getLoginSuccessUrl();
        String other$loginSuccessUrl = other.getLoginSuccessUrl();
        if (this$loginSuccessUrl == null ? other$loginSuccessUrl != null : !this$loginSuccessUrl.equals(other$loginSuccessUrl)) {
            return false;
        }
        String this$loginFailureUrl = this.getLoginFailureUrl();
        String other$loginFailureUrl = other.getLoginFailureUrl();
        if (this$loginFailureUrl == null ? other$loginFailureUrl != null : !this$loginFailureUrl.equals(other$loginFailureUrl)) {
            return false;
        }
        String this$loginOutSuccessUrl = this.getLoginOutSuccessUrl();
        String other$loginOutSuccessUrl = other.getLoginOutSuccessUrl();
        if (this$loginOutSuccessUrl == null ? other$loginOutSuccessUrl != null : !this$loginOutSuccessUrl.equals(other$loginOutSuccessUrl)) {
            return false;
        }
        if (this.isCookieEnabled() != other.isCookieEnabled()) {
            return false;
        }
        Integer this$cookieValidSeconds = this.getCookieValidSeconds();
        Integer other$cookieValidSeconds = other.getCookieValidSeconds();
        return !(this$cookieValidSeconds == null ? other$cookieValidSeconds != null : !((Object)this$cookieValidSeconds).equals(other$cookieValidSeconds));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VanasSecurityConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $xFrameEnabled = this.getXFrameEnabled();
        result = result * 59 + ($xFrameEnabled == null ? 43 : ((Object)$xFrameEnabled).hashCode());
        String $xFrameOptions = this.getXFrameOptions();
        result = result * 59 + ($xFrameOptions == null ? 43 : $xFrameOptions.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getXFrameAllowUri());
        result = result * 59 + Arrays.deepHashCode(this.getPermitUrl());
        result = result * 59 + (this.isCsrfEnabled() ? 79 : 97);
        result = result * 59 + Arrays.deepHashCode(this.getCsrfPermitUrl());
        String $loginUrl = this.getLoginUrl();
        result = result * 59 + ($loginUrl == null ? 43 : $loginUrl.hashCode());
        String $loginFormUrl = this.getLoginFormUrl();
        result = result * 59 + ($loginFormUrl == null ? 43 : $loginFormUrl.hashCode());
        String $loginSuccessUrl = this.getLoginSuccessUrl();
        result = result * 59 + ($loginSuccessUrl == null ? 43 : $loginSuccessUrl.hashCode());
        String $loginFailureUrl = this.getLoginFailureUrl();
        result = result * 59 + ($loginFailureUrl == null ? 43 : $loginFailureUrl.hashCode());
        String $loginOutSuccessUrl = this.getLoginOutSuccessUrl();
        result = result * 59 + ($loginOutSuccessUrl == null ? 43 : $loginOutSuccessUrl.hashCode());
        result = result * 59 + (this.isCookieEnabled() ? 79 : 97);
        Integer $cookieValidSeconds = this.getCookieValidSeconds();
        result = result * 59 + ($cookieValidSeconds == null ? 43 : ((Object)$cookieValidSeconds).hashCode());
        return result;
    }

    public String toString() {
        return "VanasSecurityConfig(xFrameEnabled=" + this.getXFrameEnabled() + ", xFrameOptions=" + this.getXFrameOptions() + ", xFrameAllowUri=" + Arrays.deepToString(this.getXFrameAllowUri()) + ", permitUrl=" + Arrays.deepToString(this.getPermitUrl()) + ", csrfEnabled=" + this.isCsrfEnabled() + ", csrfPermitUrl=" + Arrays.deepToString(this.getCsrfPermitUrl()) + ", loginUrl=" + this.getLoginUrl() + ", loginFormUrl=" + this.getLoginFormUrl() + ", loginSuccessUrl=" + this.getLoginSuccessUrl() + ", loginFailureUrl=" + this.getLoginFailureUrl() + ", loginOutSuccessUrl=" + this.getLoginOutSuccessUrl() + ", cookieEnabled=" + this.isCookieEnabled() + ", cookieValidSeconds=" + this.getCookieValidSeconds() + ")";
    }
}

