/*
 * Decompiled with CFR 0.152.
 */
package com.liuqi.vanasframework.core.mvc.base;

import com.liuqi.vanasframework.core.conf.norm.ExceptionErrorCode;
import com.liuqi.vanasframework.core.conf.norm.ResultStatus;
import com.liuqi.vanasframework.core.exception.AppException;
import com.liuqi.vanasframework.core.tuple.ex.RequestMsgResultTuple;
import java.beans.PropertyEditor;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.beans.propertyeditors.CustomNumberEditor;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.support.RedirectAttributesModelMap;

public class AbstractController {
    protected final String RETURN_CLIENT_MSG_KEY_NAME = "msg";
    protected final String RETURN_CLIENT_MSG_TYPE = "msg_type";

    protected RequestMsgResultTuple resultSuccessMsg(String msg) {
        return new RequestMsgResultTuple(ResultStatus.SUCCESS, msg);
    }

    protected RequestMsgResultTuple resultWarningMsg(String msg) {
        return new RequestMsgResultTuple(ResultStatus.WARN, msg);
    }

    protected RequestMsgResultTuple resultErrorMsg(String msg) {
        return new RequestMsgResultTuple(ResultStatus.ERROR, msg);
    }

    protected ModelAndView forward(Object ... params) {
        String errorMsg = "The params type only support [ModelAndView , String , Map, RequestMsgResultTuple]. but [%s] given.";
        ModelAndView modelAndView = null;
        String viewName = "";
        Map dataMap = null;
        RequestMsgResultTuple msgResult = null;
        for (Object obj : params) {
            if (obj instanceof ModelAndView) {
                modelAndView = (ModelAndView)obj;
                continue;
            }
            if (obj instanceof String) {
                viewName = (String)obj;
                continue;
            }
            if (obj instanceof Map) {
                dataMap = (Map)obj;
                continue;
            }
            if (obj instanceof RequestMsgResultTuple) {
                msgResult = (RequestMsgResultTuple)obj;
                continue;
            }
            throw new AppException(ExceptionErrorCode.PARAM_ERROR, String.format(errorMsg, obj.getClass().getName()));
        }
        if (modelAndView == null) {
            modelAndView = new ModelAndView();
        }
        if (StringUtils.isNotEmpty((String)viewName)) {
            modelAndView.setViewName(viewName);
        }
        this.setForwardModelObjectWithMap(modelAndView, dataMap);
        this.setForwardModelObjectMessage(modelAndView, msgResult);
        return modelAndView;
    }

    private ModelAndView forward(ModelAndView modelAndView, String viewName, Map<String, Object> dataMap, RequestMsgResultTuple msgResult) {
        modelAndView.setViewName(viewName);
        this.setForwardModelObjectWithMap(modelAndView, dataMap);
        this.setForwardModelObjectMessage(modelAndView, msgResult);
        return modelAndView;
    }

    private ModelAndView forward(ModelAndView modelAndView, String viewName, RequestMsgResultTuple msgResult) {
        modelAndView.setViewName(viewName);
        this.setForwardModelObjectMessage(modelAndView, msgResult);
        return modelAndView;
    }

    private ModelAndView forward(ModelAndView modelAndView, String viewName, Map<String, Object> dataMap) {
        modelAndView.setViewName(viewName);
        this.setForwardModelObjectWithMap(modelAndView, dataMap);
        return modelAndView;
    }

    private ModelAndView forward(ModelAndView modelAndView, Map<String, Object> dataMap) {
        this.setForwardModelObjectWithMap(modelAndView, dataMap);
        return modelAndView;
    }

    private ModelAndView forward(ModelAndView modelAndView, RequestMsgResultTuple msgResult) {
        this.setForwardModelObjectMessage(modelAndView, msgResult);
        return modelAndView;
    }

    private ModelAndView forward(String viewName, Map<String, Object> dataMap) {
        return this.forward(new ModelAndView(), viewName, dataMap);
    }

    private ModelAndView forward(String viewName, RequestMsgResultTuple msgResult) {
        return this.forward(new ModelAndView(), viewName, msgResult);
    }

    private ModelAndView forward(String viewName) {
        return new ModelAndView(viewName);
    }

    private ModelAndView forward(Map<String, Object> dataMap) {
        return this.forward(new ModelAndView(), dataMap);
    }

    private ModelAndView forward(RequestMsgResultTuple msgResult) {
        return this.forward(new ModelAndView(), msgResult);
    }

    private void setForwardModelObjectMessage(ModelAndView modelAndView, RequestMsgResultTuple msgResult) {
        if (msgResult != null) {
            modelAndView.addObject("msg_type", msgResult.var1);
            modelAndView.addObject("msg", msgResult.var2);
        }
    }

    private void setForwardModelObjectWithMap(ModelAndView modelAndView, Map<String, Object> dataMap) {
        if (dataMap != null) {
            for (String k : dataMap.keySet()) {
                modelAndView.addObject(k, dataMap.get(k));
            }
        }
    }

    protected ModelAndView redirect(Object ... params) {
        String errorMsg = "The params type only support [ModelAndView , RedirectAttributesModelMap , String , Map, RequestMsgResultTuple]. but [%s] given.";
        ModelAndView modelAndView = null;
        RedirectAttributesModelMap redirectModelMap = null;
        String redirectUrl = "";
        Map dataMap = null;
        RequestMsgResultTuple msgResult = null;
        for (Object obj : params) {
            if (obj instanceof ModelAndView) {
                modelAndView = (ModelAndView)obj;
                continue;
            }
            if (obj instanceof RedirectAttributesModelMap) {
                redirectModelMap = (RedirectAttributesModelMap)obj;
                continue;
            }
            if (obj instanceof String) {
                redirectUrl = (String)obj;
                continue;
            }
            if (obj instanceof Map) {
                dataMap = (Map)obj;
                continue;
            }
            if (obj instanceof RequestMsgResultTuple) {
                msgResult = (RequestMsgResultTuple)obj;
                continue;
            }
            throw new AppException(ExceptionErrorCode.PARAM_ERROR, String.format(errorMsg, obj.getClass().getName()));
        }
        if (StringUtils.isEmpty((String)redirectUrl)) {
            throw new AppException(ExceptionErrorCode.NULL_ERROR, "Not found redirect URL.");
        }
        if (modelAndView == null) {
            modelAndView = new ModelAndView();
        }
        this.setRedirectModelObjectMessage(redirectModelMap, msgResult);
        this.setRedirectModelObjectWithMap(redirectModelMap, dataMap);
        modelAndView.setViewName("redirect:" + redirectUrl);
        return modelAndView;
    }

    private void setRedirectModelObjectMessage(RedirectAttributesModelMap redirectModelMap, RequestMsgResultTuple msgResult) {
        if (redirectModelMap != null && msgResult != null) {
            redirectModelMap.addFlashAttribute("msg_type", msgResult.var1);
            redirectModelMap.addFlashAttribute("msg", msgResult.var2);
        }
    }

    private void setRedirectModelObjectWithMap(RedirectAttributesModelMap redirectModelMap, Map<String, Object> dataMap) {
        if (redirectModelMap != null && dataMap != null) {
            for (String k : dataMap.keySet()) {
                redirectModelMap.addFlashAttribute(k, dataMap.get(k));
            }
        }
    }

    @InitBinder
    protected void initBinder(WebDataBinder binder) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        dateFormat.setLenient(false);
        binder.registerCustomEditor(Date.class, (PropertyEditor)new CustomDateEditor((DateFormat)dateFormat, true));
        binder.registerCustomEditor(Integer.class, (PropertyEditor)new CustomNumberEditor(Integer.class, true));
    }
}

