/*
 * Decompiled with CFR 0.152.
 */
package com.liuqi.vanasframework.core.mvc.base;

import com.liuqi.vanasframework.core.conf.norm.ResultStatus;
import com.liuqi.vanasframework.core.mvc.base.AbstractController;
import com.liuqi.vanasframework.core.mvc.handler.ResponseJsonHandler;
import com.liuqi.vanasframework.core.mvc.res.DataResult;
import com.liuqi.vanasframework.core.mvc.res.PageDataResult;
import java.util.HashMap;
import java.util.Map;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.support.RedirectAttributesModelMap;

public class BaseController
extends AbstractController {
    protected Map<String, Object> renderJSONSuccess() {
        return ResponseJsonHandler.getInstance().renderJSON(new DataResult());
    }

    protected Map<String, Object> renderJSONError(String msg) {
        DataResult result = new DataResult();
        result.error(msg);
        return ResponseJsonHandler.getInstance().renderJSON(result);
    }

    protected Map<String, Object> renderJSON(DataResult result) {
        return ResponseJsonHandler.getInstance().renderJSON(result);
    }

    protected Map<String, Object> renderLayuiTableData(PageDataResult res) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("code", res.getStatus() ? 0 : 1);
        ret.put("msg", res.getMsg());
        ret.put("count", res.getTotal() == null ? 0 : res.getTotal());
        ret.put("data", res.getPageData());
        return ret;
    }

    protected String redirectURL(String redirectUrl) {
        return "redirect:" + redirectUrl;
    }

    protected void setRediectMessage(RedirectAttributesModelMap model, ResultStatus msg_type, String msg) {
        if (msg_type == ResultStatus.SUCCESS) {
            this.setRediectSuccessMessage(model, msg);
        } else if (msg_type == ResultStatus.ERROR) {
            this.setRediectErrorMessage(model, msg);
        } else if (msg_type == ResultStatus.WARN) {
            this.setRediectWarnMessage(model, msg);
        }
    }

    protected void setRediectErrorMessage(RedirectAttributesModelMap model, String msg) {
        model.addFlashAttribute("msg", (Object)msg);
        model.addFlashAttribute("msg_type", (Object)ResultStatus.ERROR);
    }

    protected void setRediectSuccessMessage(RedirectAttributesModelMap model, String msg) {
        model.addFlashAttribute("msg", (Object)msg);
        model.addFlashAttribute("msg_type", (Object)ResultStatus.SUCCESS);
    }

    protected void setRediectWarnMessage(RedirectAttributesModelMap model, String msg) {
        model.addFlashAttribute("msg", (Object)msg);
        model.addFlashAttribute("msg_type", (Object)ResultStatus.WARN);
    }

    protected void setForwardSuccessMessage(ModelAndView mav, ResultStatus msg_type, String msg) {
        if (msg_type == ResultStatus.SUCCESS) {
            this.setForwardSuccessMessage(mav, msg);
        } else if (msg_type == ResultStatus.ERROR) {
            this.setForwardErrorMessage(mav, msg);
        } else if (msg_type == ResultStatus.WARN) {
            this.setForwardWarningMessage(mav, msg);
        }
    }

    protected void setForwardSuccessMessage(ModelAndView mav, String msg) {
        mav.addObject("msg", (Object)msg);
        mav.addObject("msg_type", (Object)ResultStatus.SUCCESS);
    }

    protected void setForwardWarningMessage(ModelAndView mav, String msg) {
        mav.addObject("msg", (Object)msg);
        mav.addObject("msg_type", (Object)ResultStatus.WARN);
    }

    protected void setForwardErrorMessage(ModelAndView mav, String msg) {
        mav.addObject("msg", (Object)msg);
        mav.addObject("msg_type", (Object)ResultStatus.ERROR);
    }
}

