/*
 * Decompiled with CFR 0.152.
 */
package com.liuqi.vanasframework.core.mvc.base;

import com.liuqi.vanasframework.core.conf.norm.ExceptionErrorCode;
import com.liuqi.vanasframework.core.exception.AppException;
import com.liuqi.vanasframework.core.mvc.base.BaseDao;
import com.liuqi.vanasframework.core.mvc.base.BaseService;
import com.liuqi.vanasframework.core.mvc.res.PageDataResult;
import java.io.Serializable;
import java.util.List;

public abstract class BaseServiceAdapter<Entity, PK extends Serializable>
implements BaseService<Entity, PK> {
    private BaseDao<Entity, PK> baseDao;

    public void setBaseDao(BaseDao<Entity, PK> baseDao) {
        this.baseDao = baseDao;
    }

    public BaseDao<Entity, PK> getBaseDao() {
        return this.baseDao;
    }

    @Override
    public void add(Entity entity) {
        this.baseDao.insert(entity);
    }

    @Override
    public void delete(PK id) {
        this.baseDao.deleteByPK(id);
    }

    @Override
    public void update(Entity entity) {
        this.baseDao.updateBySelective(entity);
    }

    @Override
    public Entity selectOne(PK id) {
        if (id == null) {
            throw new AppException(ExceptionErrorCode.NULL_ERROR, "\u67e5\u8be2\u6570\u636e ID \u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.baseDao.selectByPK(id);
    }

    @Override
    public PageDataResult selectPageList(Entity entity) {
        PageDataResult res = new PageDataResult();
        res.setPageData(this.baseDao.selectListSelective(entity));
        res.setTotal(this.baseDao.selectCountSelective(entity));
        return res;
    }

    @Override
    public List<Entity> selectList(Entity entity) {
        return this.baseDao.selectListSelective(entity);
    }

    @Override
    public List<Entity> selectAll() {
        return this.baseDao.selectAll();
    }
}

