/*
 * Decompiled with CFR 0.152.
 */
package com.liuqi.vanasframework.core.mvc.handler;

import com.liuqi.vanasframework.core.mvc.entity.ErrorMap;
import com.liuqi.vanasframework.core.mvc.handler.ResponseErrorMapHandler;
import com.liuqi.vanasframework.core.mvc.handler.ResponseJsonHandler;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.boot.autoconfigure.web.ErrorProperties;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.autoconfigure.web.servlet.error.AbstractErrorController;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"${server.error.path:${error.path:/error}}"})
public class AppGlobalErrorHandler
extends AbstractErrorController {
    private final Logger logger = LogManager.getLogger(AppGlobalErrorHandler.class);
    private static final String ERROR_PATH_4XX = "/error/4xx";
    private static final String ERROR_PATH_5XX = "/error/5xx";
    private final ErrorProperties errorProperties;

    public AppGlobalErrorHandler(ErrorAttributes errorAttributes, ServerProperties serverProperties) {
        super(errorAttributes);
        this.errorProperties = serverProperties.getError();
    }

    public String getErrorPath() {
        return this.errorProperties.getPath();
    }

    @RequestMapping(produces={"text/html"})
    public ModelAndView errorHtml(HttpServletRequest request, HttpServletResponse response) {
        HttpStatus code;
        ModelAndView modelAndView = new ModelAndView("error");
        Map springErrorMap = this.getErrorAttributes(request, this.isIncludeStackTrace(request, MediaType.ALL));
        if (springErrorMap != null) {
            ErrorMap errorMap = ResponseErrorMapHandler.createErrorMap(springErrorMap);
            modelAndView.addObject("errorMap", (Object)errorMap);
            this.logHandler(errorMap);
        }
        if ((code = this.getStatus(request)) == HttpStatus.NOT_FOUND) {
            modelAndView.addObject("reason", (Object)"\u8d44\u6e90\u4e0d\u5b58\u5728");
            modelAndView.setViewName(ERROR_PATH_4XX);
        } else if (code == HttpStatus.FORBIDDEN) {
            modelAndView.addObject("reason", (Object)"\u7981\u6b62\u8bbf\u95ee");
            modelAndView.setViewName(ERROR_PATH_4XX);
        } else {
            modelAndView.setViewName(ERROR_PATH_5XX);
        }
        return modelAndView;
    }

    @RequestMapping
    @ResponseBody
    public Map<String, Object> error(HttpServletRequest request) {
        Map springErrorMap = this.getErrorAttributes(request, this.isIncludeStackTrace(request, MediaType.APPLICATION_JSON));
        ErrorMap errorMap = ResponseErrorMapHandler.createErrorMap(springErrorMap);
        this.logHandler(errorMap);
        return ResponseJsonHandler.getInstance().failureRenderMap(errorMap, "\u8bf7\u6c42\u9519\u8bef\uff0c\u8be6\u60c5\u67e5\u770b errorInfo");
    }

    private void logHandler(ErrorMap errorMap) {
        this.logger.error("Request Error >> path:{},errorCode:{},time:{},errorMsg:{}", (Object)errorMap.getPath(), (Object)errorMap.getErrorCode(), (Object)errorMap.getTimestamp(), (Object)errorMap.getErrorMsg());
    }

    private boolean isIncludeStackTrace(HttpServletRequest request, MediaType produces) {
        ErrorProperties.IncludeStacktrace include = this.getErrorProperties().getIncludeStacktrace();
        if (include == ErrorProperties.IncludeStacktrace.ALWAYS) {
            return true;
        }
        if (include == ErrorProperties.IncludeStacktrace.ON_TRACE_PARAM) {
            return this.getTraceParameter(request);
        }
        return false;
    }

    private ErrorProperties getErrorProperties() {
        return this.errorProperties;
    }
}

