/*
 * Decompiled with CFR 0.152.
 */
package com.liuqi.vanasframework.core.mvc.handler;

import com.liuqi.vanasframework.core.conf.norm.ExceptionErrorCode;
import com.liuqi.vanasframework.core.exception.AppException;
import com.liuqi.vanasframework.core.mvc.entity.ErrorMap;
import com.liuqi.vanasframework.core.mvc.handler.ResponseErrorMapHandler;
import com.liuqi.vanasframework.core.mvc.handler.ResponseJsonHandler;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.servlet.ModelAndView;

@ControllerAdvice
public class ControllerExceptionHandler {
    private final Logger logger = LogManager.getLogger(ControllerExceptionHandler.class);
    private final String ERROR_PAGE = "error/5xx";

    @ExceptionHandler(value={Exception.class})
    public ModelAndView exceptionHandler(Exception e, HttpServletRequest request) {
        return this.exceptionHandlerProcess(request, ExceptionErrorCode.BAD_REQUEST, e);
    }

    @ExceptionHandler(value={NullPointerException.class})
    public ModelAndView nullPointerExceptionHandler(NullPointerException e, HttpServletRequest request, Model model) {
        return this.exceptionHandlerProcess(request, ExceptionErrorCode.NULL_ERROR, e);
    }

    @ExceptionHandler(value={AppException.class})
    public ModelAndView customerExceptionHandler(AppException e, HttpServletRequest request) {
        return this.exceptionHandlerProcess(request, e.getExceptionErrorCode(), e);
    }

    private <T extends Exception> ModelAndView exceptionHandlerProcess(HttpServletRequest request, ExceptionErrorCode errorCode, T exception) {
        ModelAndView mv;
        this.logger.error((Object)errorCode, exception);
        ErrorMap errorMap = ResponseErrorMapHandler.createErrorMap(request, exception, errorCode);
        if (this.isView(request)) {
            mv = new ModelAndView("error/5xx");
            mv.addObject("errorMap", (Object)errorMap);
        } else {
            mv = ResponseJsonHandler.getInstance().failureRenderModelView(errorMap, "\u8bf7\u6c42\u9519\u8bef\uff0c\u8be6\u60c5\u67e5\u770b errorInfo");
        }
        return mv;
    }

    private boolean isView(HttpServletRequest request) {
        return (Boolean)request.getAttribute("method_return_is_view");
    }
}

