/*
 * Decompiled with CFR 0.152.
 */
package com.liuqi.vanasframework.core.mvc.handler;

import com.liuqi.vanasframework.core.conf.norm.ExceptionErrorCode;
import com.liuqi.vanasframework.core.exception.AppException;
import com.liuqi.vanasframework.core.mvc.entity.ErrorMap;
import com.liuqi.vanasframework.core.mvc.res.DataResult;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.json.MappingJackson2JsonView;

public class ResponseJsonHandler
implements Serializable {
    private static final long serialVersionUID = -3403931445772288525L;
    private String ATTR_SUCCESS = "success";
    private String ATTR_DATA = "data";
    private String ATTR_ERRORINFO = "errorInfo";
    private String ATTR_MSG = "msg";
    private String DEFAULT_SUCCESS_MSG = "\u64cd\u4f5c\u6210\u529f";
    private boolean success = true;
    private String msg;
    private ErrorMap errorInfo;
    private Object data;

    public static ResponseJsonHandler getInstance() {
        return ResponseJsonHandlerHook.instance;
    }

    public Map<String, Object> successRenderMap(String msg) {
        return this.successRenderMap(null, this.DEFAULT_SUCCESS_MSG);
    }

    public Map<String, Object> successRenderMap(Object data) {
        return this.successRenderMap(data, this.DEFAULT_SUCCESS_MSG);
    }

    public Map<String, Object> successRenderMap(Object data, String msg) {
        this.msg = msg;
        this.data = data;
        this.success = true;
        return this.renderJSON();
    }

    public ModelAndView successRenderModelView(String msg) {
        return this.successRenderModelView(null, msg);
    }

    public ModelAndView successRenderModelView(Object data) {
        return this.successRenderModelView(data, this.DEFAULT_SUCCESS_MSG);
    }

    public ModelAndView successRenderModelView(Object data, String msg) {
        this.msg = msg;
        this.data = data;
        this.success = true;
        return this.renderModelAndViewJSON();
    }

    public Map<String, Object> failureRenderMap(String msg) {
        return this.failureRenderMap(null, msg);
    }

    public Map<String, Object> failureRenderMap(ErrorMap errorInfo) {
        return this.failureRenderMap(errorInfo, errorInfo.getErrorMsg());
    }

    public Map<String, Object> failureRenderMap(ErrorMap errorInfo, String msg) {
        this.success = false;
        this.msg = msg;
        this.errorInfo = errorInfo;
        return this.renderJSON();
    }

    public ModelAndView failureRenderModelView(String msg) {
        return this.failureRenderModelView(null, msg);
    }

    public ModelAndView failureRenderModelView(ErrorMap errorInfo) {
        return this.failureRenderModelView(errorInfo, errorInfo.getErrorMsg());
    }

    public ModelAndView failureRenderModelView(ErrorMap errorInfo, String msg) {
        this.success = false;
        this.msg = msg;
        this.errorInfo = errorInfo;
        return this.renderModelAndViewJSON();
    }

    private ModelAndView renderModelAndViewJSON() {
        ModelAndView modelAndView = new ModelAndView((View)new MappingJackson2JsonView());
        modelAndView.addObject(this.ATTR_SUCCESS, (Object)this.success);
        if (this.success) {
            modelAndView.addObject(this.ATTR_DATA, this.data);
        } else {
            modelAndView.addObject(this.ATTR_ERRORINFO, (Object)this.errorInfo);
        }
        modelAndView.addObject(this.ATTR_MSG, (Object)this.msg);
        return modelAndView;
    }

    private Map<String, Object> renderJSON() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(this.ATTR_SUCCESS, this.success);
        if (this.success) {
            map.put(this.ATTR_DATA, this.data);
        } else {
            map.put(this.ATTR_ERRORINFO, this.errorInfo);
        }
        map.put(this.ATTR_MSG, this.msg);
        return map;
    }

    public Map<String, Object> renderJSON(DataResult result) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(this.ATTR_SUCCESS, result.getStatus());
        if (result.getStatus()) {
            map.put(this.ATTR_DATA, result.getData());
        } else {
            if (StringUtils.isEmpty((String)result.getMsg())) {
                throw new AppException(ExceptionErrorCode.NULL_ERROR, "\u8fd4\u56de json \u5bf9\u8c61\u7684 msg \u4e3a\u7a7a\u3002\u5f53Request \u4e1a\u52a1\u51fa\u73b0 Error\u65f6\uff0c\u8fd4\u56de\u6d88\u606f\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            }
            map.put(this.ATTR_ERRORINFO, result.getMsg());
        }
        map.put(this.ATTR_MSG, result.getMsg());
        return map;
    }

    private static class ResponseJsonHandlerHook {
        private static ResponseJsonHandler instance = new ResponseJsonHandler();

        private ResponseJsonHandlerHook() {
        }
    }
}

