/*
 * Decompiled with CFR 0.152.
 */
package com.liuqi.vanasframework.core.mvc.res;

import com.liuqi.vanasframework.core.conf.norm.ExceptionErrorCode;
import com.liuqi.vanasframework.core.conf.norm.ResultStatus;
import com.liuqi.vanasframework.core.exception.AppException;
import com.liuqi.vanasframework.core.exception.DataResultException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataResult {
    private boolean status = true;
    private String msg = "";
    private ResultStatus msgType = ResultStatus.SUCCESS;
    private Map<String, Object> data = new HashMap<String, Object>();

    public boolean getStatus() {
        return this.status;
    }

    public String getMsg() {
        return this.msg;
    }

    public ResultStatus getMsgType() {
        return this.msgType;
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public String getDataAsString(String key) {
        if (this.data.containsKey(key)) {
            return (String)this.getData().get(key);
        }
        return null;
    }

    public boolean getDataAsBoolean(String key) {
        if (this.data.containsKey(key)) {
            return (Boolean)this.getData().get(key);
        }
        return false;
    }

    public Integer getDataAsInteger(String key) {
        if (this.data.containsKey(key)) {
            return (Integer)this.getData().get(key);
        }
        return null;
    }

    public <T> T getDataAsObject(String key, Class<T> classz) {
        if (!this.data.containsKey(key)) {
            return null;
        }
        Object obj = this.getData().get(key);
        if (classz != null && !classz.isInstance(obj)) {
            throw new AppException(ExceptionErrorCode.NOT_SUPPORT_TYPE, "key=" + key + "\u7684\u5bf9\u8c61\u4e3a\uff1a" + obj.getClass() + " \uff0c \u4e0d\u80fd\u8f6c\u5316\u4e3a\uff1a" + classz);
        }
        return (T)obj;
    }

    public <T> List<T> getDataAsList(String key, Class<T> classz) {
        if (!this.data.containsKey(key)) {
            return null;
        }
        List objList = (List)this.getData().get(key);
        Object obj = objList.get(0);
        if (classz != null && !classz.isInstance(obj)) {
            throw new AppException("key >> " + key + ", get obj >> " + obj.getClass() + " is not " + classz);
        }
        return objList;
    }

    public <K, E> Map<K, E> getDataAsMap(String key) {
        if (!this.data.containsKey(key)) {
            return null;
        }
        return (Map)this.getData().get(key);
    }

    public void setData(String key, Object dataVal) {
        this.data.put(key, dataVal);
    }

    public void success(Object ... params) {
        this.status = true;
        this.msgType = ResultStatus.SUCCESS;
        try {
            this.setParams(params);
        }
        catch (DataResultException e) {
            this.setDefaultParam(e.getMessage());
        }
    }

    public void warning(Object ... params) {
        this.status = true;
        this.msgType = ResultStatus.WARN;
        try {
            this.setParams(params);
        }
        catch (DataResultException e) {
            this.setDefaultParam(e.getMessage());
        }
    }

    public void error(Object ... params) {
        this.status = false;
        this.msgType = ResultStatus.ERROR;
        try {
            this.setParams(params);
        }
        catch (DataResultException e) {
            this.setDefaultParam(e.getMessage());
        }
    }

    private void setDefaultParam(String errorMsg) {
        this.status = false;
        this.msgType = ResultStatus.ERROR;
        this.msg = errorMsg;
    }

    private void setParams(Object[] params) throws DataResultException {
        boolean wantSetParam = false;
        if (params != null && params.length > 0) {
            wantSetParam = true;
        }
        if (wantSetParam) {
            if (!(params[0] instanceof String)) {
                throw new DataResultException("The params message must be String. but " + params[0].getClass() + " given");
            }
            this.msg = (String)params[0];
            Object data_temp = null;
            if (params.length > 1) {
                data_temp = params[1];
            }
            if (data_temp != null && !data_temp.getClass().isArray()) {
                throw new DataResultException("The result data must be array. but " + data_temp.getClass() + " given");
            }
            if (data_temp != null) {
                Object[] dataArray = (Object[])data_temp;
                if (dataArray.length % 2 != 0) {
                    throw new DataResultException("unknown your data params . The data must be key & data array. like new Object[]{key, data ,...}. ");
                }
                for (int i = 0; i < dataArray.length; ++i) {
                    Object key = dataArray[i];
                    if ((i + 1) % 2 != 1) continue;
                    if (!(key instanceof String)) {
                        throw new DataResultException("The result data key must be String. but " + key.getClass() + " given.");
                    }
                    this.setData((String)key, dataArray[i + 1]);
                }
            }
        }
    }
}

