/*
 * Decompiled with CFR 0.152.
 */
package com.liuqi.vanasframework.core.mvc.view;

import cn.org.rapid_framework.freemarker.directive.BlockDirective;
import cn.org.rapid_framework.freemarker.directive.ExtendsDirective;
import cn.org.rapid_framework.freemarker.directive.OverrideDirective;
import cn.org.rapid_framework.freemarker.directive.SuperDirective;
import com.liuqi.vanasframework.core.mvc.view.FreeMarkerStaticModels;
import freemarker.template.Configuration;
import freemarker.template.TemplateModel;
import java.io.Serializable;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.view.freemarker.FreeMarkerViewResolver;

@Component
public class FreeMarkerConfig
implements Serializable {
    private static final Logger log = LogManager.getLogger(FreeMarkerConfig.class);
    private static final long serialVersionUID = 7225569316034483810L;
    private Configuration configuration;
    private FreeMarkerViewResolver freeMarkerViewResolver;

    public FreeMarkerConfig(Configuration configuration, FreeMarkerViewResolver freeMarkerViewResolver) {
        this.configuration = configuration;
        this.freeMarkerViewResolver = freeMarkerViewResolver;
    }

    public void setFreeMarkConf(Map<String, String> staticClass) {
        log.info("\u52a0\u8f7d Freemarker \u914d\u7f6e.");
        log.info("\u52a0\u8f7d Freemarker \u914d\u7f6e >>> Freemarker set Tag [Extends , Override , Super , Block]");
        this.setSharedVar();
        log.info("\u52a0\u8f7d Freemarker \u914d\u7f6e >>> Freemarker set templates used Java static class and enum.");
        this.setStaticModels(staticClass);
    }

    private void setSharedVar() {
        this.configuration.setSharedVariable("block", (TemplateModel)new BlockDirective());
        this.configuration.setSharedVariable("override", (TemplateModel)new OverrideDirective());
        this.configuration.setSharedVariable("extends", (TemplateModel)new ExtendsDirective());
        this.configuration.setSharedVariable("super", (TemplateModel)new SuperDirective());
    }

    private void setStaticModels(Map<String, String> staticClass) {
        this.freeMarkerViewResolver.setAttributesMap((Map)new FreeMarkerStaticModels(staticClass));
    }
}

